/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/output.h,v $
 * $Id: output.h,v 3.8 1999/10/17 22:08:55 heiner Exp $
 *
 *	Print analysis results
 */

#ifndef CHEST_output_h_INCLUDED
#define CHEST_output_h_INCLUDED

#include "types.h"
#include "board.h"
#include "lang.h"

Extern void	oflush (void);
Extern void	set_out_lang (int);

Extern char	chr_colour (Colour);
Extern char	chr_Colour (Colour);
Extern char	chr_figure (Figure);
Extern char	chr_Figure (Figure);
Extern int	chr_PosCol (Position);
Extern int	chr_PosLin (Position);

Extern const char*	mvc_L6  (Board*, const Move*);	/* -> static */
Extern const char*	mvc_L7  (Board*, const Move*);	/* -> static */
Extern const char*	mvc_SAN (Board*, const Move*);	/* -> static */

Extern char*	app_fen_board (const Board*, char*, int lang);  /* --> 0-term */
Extern char*	app_fen_tom   (const Board*, char*, int lang);  /* --> 0-term */
Extern char*	app_fen_castle(const Board*, char*, int lang);  /* --> 0-term */
Extern char*	app_fen_ep    (const Board*, char*, int lang);  /* --> 0-term */

Extern void	put_figure   (Figure);
Extern void	put_position (Position);
Extern void	put_control  (const Board*);
Extern void	put_fen    (const Board*, int, const char*);
Extern void	put_fen_eng(const Board*);
Extern void	put__move  (const Board*, const Move*);
Extern void	put_move   (const Board*, const Move*);
Extern void	put_list   (const Board*, const Movelist*);
Extern void	put_packed (const PackedBoard*, const char*);

Extern void	tit_put_line  (const char*);		/* immediate output */
Extern void	tit_clear     (void);
Extern void	tit_add_line  (const char*);
Extern void	put_tit_lines (void);

#endif	/* ndef CHEST_output_h_INCLUDED */
