/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/stats.c,v $
 * $Id: stats.c,v 3.3 1999/07/20 21:09:50 heiner Exp $
 *
 *	support statistics output
 */

#include <stdio.h>
#include "stats.h"


    static void
show(
    int		width,		/* field width */
    Counter	sc)		/* the value to print */
{
#if 1
    printf("%*lu", width, (unsigned long)sc);
#else
    printf("%*.0f", width, (double)sc);
#endif
}


    Eximpl void
show_nz(
    int		spc,		/* leading spaces */
    int		width,		/* field width */
    char	zeroc,		/* print this instead of value 0 */
    Counter	sc)		/* the value to print */
{
    if( spc > 0 ) {
	printf("%*s", spc, "");
    }
    if( sc ) {
	show(width, sc);
    }else {
	printf("%*c", width, (zeroc ? zeroc : '0'));
    }
}


    Eximpl void
show_scs(
    int		spc,		/* leading spaces */
    int		width,		/* field width */
    Counter	sc,		/* the value to print */
    const char*	ftr)		/* append this string */
{
    show_nz(spc, width, '0', sc);
    if( ftr ) {
	printf("%s", ftr);
    }
}


    Eximpl void
show_sc(
    int		spc,		/* leading spaces */
    int		width,		/* field width */
    Counter	sc)		/* the value to print */
{
    show_scs(spc, width, sc, (char*)0);
}


    Eximpl int
dec_length( register Counter sc )
{
    if( sc <= 9999 ) {
	if( sc <=   9 ) return 1;
	if( sc <=  99 ) return 2;
	if( sc <= 999 ) return 3;
	return 4;
    }
    {
	    register double	pot = 10000.0;
	    register double	d   = (double) sc;
	    register int	i   = 4;
	do {
	    i += 1;
	    pot *= 10.0;
	}while( ! (d < pot) );		/* FFS: Inf & NaN */
	return i;
    }
}


    Eximpl double
fraction( Counter part, Counter	total )
{
    return total ? ((double)part) / ((double)total) : 0.0;
}


    Eximpl double
percent( Counter part, Counter total )
{
    return 100.0 * fraction(part, total);
}
