# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, Optional, cast

import pytest

from cloudflare import Cloudflare, AsyncCloudflare
from tests.utils import assert_matches_type
from cloudflare.pagination import SyncSinglePage, AsyncSinglePage
from cloudflare.types.zero_trust import Device, DeviceGetResponse

# pyright: reportDeprecated=false

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestDevices:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_list(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            device = client.zero_trust.devices.list(
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert_matches_type(SyncSinglePage[Device], device, path=["response"])

    @parametrize
    def test_raw_response_list(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            response = client.zero_trust.devices.with_raw_response.list(
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        device = response.parse()
        assert_matches_type(SyncSinglePage[Device], device, path=["response"])

    @parametrize
    def test_streaming_response_list(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            with client.zero_trust.devices.with_streaming_response.list(
                account_id="699d98642c564d2e855e9661899b7252",
            ) as response:
                assert not response.is_closed
                assert response.http_request.headers.get("X-Stainless-Lang") == "python"

                device = response.parse()
                assert_matches_type(SyncSinglePage[Device], device, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_list(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            with pytest.raises(ValueError, match=r"Expected a non-empty value for `account_id` but received ''"):
                client.zero_trust.devices.with_raw_response.list(
                    account_id="",
                )

    @parametrize
    def test_method_get(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            device = client.zero_trust.devices.get(
                device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert_matches_type(Optional[DeviceGetResponse], device, path=["response"])

    @parametrize
    def test_raw_response_get(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            response = client.zero_trust.devices.with_raw_response.get(
                device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        device = response.parse()
        assert_matches_type(Optional[DeviceGetResponse], device, path=["response"])

    @parametrize
    def test_streaming_response_get(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            with client.zero_trust.devices.with_streaming_response.get(
                device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                account_id="699d98642c564d2e855e9661899b7252",
            ) as response:
                assert not response.is_closed
                assert response.http_request.headers.get("X-Stainless-Lang") == "python"

                device = response.parse()
                assert_matches_type(Optional[DeviceGetResponse], device, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_get(self, client: Cloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            with pytest.raises(ValueError, match=r"Expected a non-empty value for `account_id` but received ''"):
                client.zero_trust.devices.with_raw_response.get(
                    device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                    account_id="",
                )

            with pytest.raises(ValueError, match=r"Expected a non-empty value for `device_id` but received ''"):
                client.zero_trust.devices.with_raw_response.get(
                    device_id="",
                    account_id="699d98642c564d2e855e9661899b7252",
                )


class TestAsyncDevices:
    parametrize = pytest.mark.parametrize("async_client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    async def test_method_list(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            device = await async_client.zero_trust.devices.list(
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert_matches_type(AsyncSinglePage[Device], device, path=["response"])

    @parametrize
    async def test_raw_response_list(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            response = await async_client.zero_trust.devices.with_raw_response.list(
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        device = await response.parse()
        assert_matches_type(AsyncSinglePage[Device], device, path=["response"])

    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            async with async_client.zero_trust.devices.with_streaming_response.list(
                account_id="699d98642c564d2e855e9661899b7252",
            ) as response:
                assert not response.is_closed
                assert response.http_request.headers.get("X-Stainless-Lang") == "python"

                device = await response.parse()
                assert_matches_type(AsyncSinglePage[Device], device, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_list(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            with pytest.raises(ValueError, match=r"Expected a non-empty value for `account_id` but received ''"):
                await async_client.zero_trust.devices.with_raw_response.list(
                    account_id="",
                )

    @parametrize
    async def test_method_get(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            device = await async_client.zero_trust.devices.get(
                device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert_matches_type(Optional[DeviceGetResponse], device, path=["response"])

    @parametrize
    async def test_raw_response_get(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            response = await async_client.zero_trust.devices.with_raw_response.get(
                device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                account_id="699d98642c564d2e855e9661899b7252",
            )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        device = await response.parse()
        assert_matches_type(Optional[DeviceGetResponse], device, path=["response"])

    @parametrize
    async def test_streaming_response_get(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            async with async_client.zero_trust.devices.with_streaming_response.get(
                device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                account_id="699d98642c564d2e855e9661899b7252",
            ) as response:
                assert not response.is_closed
                assert response.http_request.headers.get("X-Stainless-Lang") == "python"

                device = await response.parse()
                assert_matches_type(Optional[DeviceGetResponse], device, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_get(self, async_client: AsyncCloudflare) -> None:
        with pytest.warns(DeprecationWarning):
            with pytest.raises(ValueError, match=r"Expected a non-empty value for `account_id` but received ''"):
                await async_client.zero_trust.devices.with_raw_response.get(
                    device_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
                    account_id="",
                )

            with pytest.raises(ValueError, match=r"Expected a non-empty value for `device_id` but received ''"):
                await async_client.zero_trust.devices.with_raw_response.get(
                    device_id="",
                    account_id="699d98642c564d2e855e9661899b7252",
                )
