use forgejo_api::{Auth, Forgejo};
use url::Url;

use crate::types::token::Token;

use crate::client::BergClient;

impl BergClient {
    pub fn new(token: &Token, base_url: Url) -> anyhow::Result<Self> {
        let Token(token) = token;
        Forgejo::new(Auth::Token(token), base_url)
            .map(Self)
            .map_err(anyhow::Error::from)
    }
}
