use anyhow::Context;
use std::path::PathBuf;

pub fn berg_data_dir() -> anyhow::Result<PathBuf> {
    let dir = dirs::data_dir().context("Couldn't find data directory for saving the token.")?;

    let data_dir = dir.join("berg-cli");

    // TODO: remove in a future version, added in 0.4.x
    //
    // This moves pre-existing data directories into the new "left" directory
    let legacy_data_dir = dir.join(".berg-cli");
    if legacy_data_dir.exists() {
        std::fs::rename(legacy_data_dir, data_dir.as_path()).map_err(anyhow::Error::from)?;
    }

    Ok(data_dir)
}

pub fn berg_config_dir() -> anyhow::Result<PathBuf> {
    let config_dir = dirs::config_dir()
        .context("Couldn't find config directory for saving global config")
        .map(|dir| dir.join("berg-cli"))?;

    // TODO: remove in a future version, added in 0.4.x
    //
    // This moves pre-existing configs into the new "left" directory
    dirs::data_dir()
        .into_iter()
        .flat_map(|data_dir| [data_dir.join("berg-cli"), data_dir.join(".berg-cli")])
        .for_each(|dir| {
            let file = dir.join("berg.toml");
            _ = std::fs::create_dir_all(config_dir.as_path());
            _ = std::fs::rename(file, config_dir.join("berg.toml"));
        });

    Ok(config_dir)
}

pub fn token_path() -> anyhow::Result<PathBuf> {
    berg_data_dir().map(|token_dir| token_dir.join("TOKEN"))
}

pub fn config_path() -> anyhow::Result<PathBuf> {
    berg_config_dir().map(|dir| dir.join("berg.toml"))
}
