{
  perSystem =
    {
      pkgs,
      lib,
      self',
      ...
    }:
    let
      general = [
        pkgs.pkg-config
        pkgs.udev
        pkgs.alsa-lib
        pkgs.vulkan-loader
        pkgs.wayland
        pkgs.libxkbcommon
        pkgs.openssl
      ];
    in
    {
      devShells = {
        default = pkgs.mkShell {
          packages = general ++ [
            self'.packages.devToolchain
            pkgs.cocogitto
          ];
          RUSTFLAGS = "-C link-args=-Wl,-rpath=${lib.makeLibraryPath general}";
        };
      };
    };
}
