{ inputs, ... }:
let
  sharedLib = inputs.self.sharedLib;
in
{
  perSystem =
    {
      self',
      pkgs,
      lib,
      ...
    }:
    let
      testLib = inputs.self.testLib { inherit self' lib pkgs; };
    in
    {
      checks =
        {
          releaseCreateBasic = {
            withChangeBranches = true;
            withRepoSetup = true;
            withAuth = true;
            test = ''
              forgejo.succeed("cd ${sharedLib.repo}; git tag v1.0.0; git push --tags")

              release = ${
                testLib.berg_run_json {
                  cmd = ''release create --tag v1.0.0'';
                  cdTestRepo = true;
                }
              }

              printj(release)

              assert release["tag_name"] == "v1.0.0", f"release tag name incorrect\ngot:{release}"
              assert release["name"] == "", f"release name incorrect\ngot:{release}"
              assert release["body"] == "", f"release description incorrect\ngot:{release}"
            '';
          };
          releaseCreateFull = {
            withChangeBranches = true;
            withRepoSetup = true;
            withAuth = true;
            test = ''
              forgejo.succeed("cd ${sharedLib.repo}; git tag v1.0.0; git push --tags")

              release = ${
                testLib.berg_run_json {
                  cmd = ''release create --tag v1.0.0 --name "first release" --description "a super cool release"'';
                  cdTestRepo = true;
                }
              }

              printj(release)

              assert release["tag_name"] == "v1.0.0", f"release tag name incorrect\ngot:{release}"
              assert release["name"] == "first release", f"release name incorrect\ngot:{release}"
              assert release["body"] == "a super cool release", f"release description incorrect\ngot:{release}"
            '';
          };
        }
        |> testLib.embeddInFlake;
    };
}
