use crate::actions::GlobalArgs;
use crate::paths::token_path;
use crate::render::ui::confirm_with_prompt;
use crate::types::context::BergContext;

use clap::Parser;
use miette::{Context, IntoDiagnostic};

/// Logout. Delete currently stored authentication token
#[derive(Parser, Debug)]
pub struct LogoutArgs {
    /// flag that skips the confirmation dialog if set
    #[arg(short, long)]
    pub skip_confirmation: bool,
}

impl LogoutArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        let _ = global_args;
        let ctx = BergContext::new(self, global_args).await?;
        if !ctx.args.skip_confirmation
            && !confirm_with_prompt(
                "Logging out deletes your current token. Do you want to proceed?",
            )?
        {
            return Ok(());
        }

        let token_path = token_path(ctx.config.base_url)?;

        std::fs::remove_file(token_path)
            .into_diagnostic()
            .context("Failed to remove token!")?;

        Ok(())
    }
}
