#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag / commit.
REPO='https://github.com/xiph/opus'; TAG='v1.5.2'
git clone "$REPO" --depth=1 --branch="${TAG}" /opus
cd /opus

# Gen scripts.
./autogen.sh

# Configure build parameters.
./configure --host=none \
            --disable-shared \
            --enable-static \
            --disable-doc \
            --disable-asm \
            --disable-rtcd \
            --disable-stack-protector \
            --disable-extra-programs \
            --disable-dot-product \
|| { cat config.log; exit 1; }

# Perform library build + install.
make -j $(nproc); make install
