package internal

import (
	"context"
	"os"
	"sync"

	"codeberg.org/gruf/go-ffmpreg/wasm"
	"github.com/tetratelabs/wazero"
)

// shared WASM runtime instance.
var runtime wazero.Runtime

// once protects runtime
// from multiple inits.
var once sync.Once

// Runtime provides a concurrency-safe,
// once initialized wazero runtime.
func Runtime() wazero.Runtime {
	once.Do(func() {
		var err error

		// Create new runtime config.
		cfg := wazero.NewRuntimeConfig()

		if dir := os.Getenv("WAZERO_COMPILATION_CACHE"); dir != "" {
			// Use on-filesystem compilation cache given by env.
			cache, err := wazero.NewCompilationCacheWithDir(dir)
			if err != nil {
				panic(err)
			}

			// Update runtime config with cache.
			cfg = cfg.WithCompilationCache(cache)
		}

		// Use background context.
		ctx := context.Background()

		// Initialize new runtime from config.
		runtime, err = wasm.NewRuntime(ctx, cfg)
		if err != nil {
			panic(err)
		}
	})

	return runtime
}
