// Code generated by go-swagger; DO NOT EDIT.

package pet

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/go-swagger/go-swagger/examples/contributed-templates/stratoscale/models"
)

// PetUpdateReader is a Reader for the PetUpdate structure.
type PetUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PetUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewPetUpdateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPetUpdateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewPetUpdateNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 405:
		result := NewPetUpdateMethodNotAllowed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /pet] PetUpdate", response, response.Code())
	}
}

// NewPetUpdateCreated creates a PetUpdateCreated with default headers values
func NewPetUpdateCreated() *PetUpdateCreated {
	return &PetUpdateCreated{}
}

/*
PetUpdateCreated describes a response with status code 201, with default header values.

Updated successfully
*/
type PetUpdateCreated struct {
	Payload *models.Pet
}

// IsSuccess returns true when this pet update created response has a 2xx status code
func (o *PetUpdateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pet update created response has a 3xx status code
func (o *PetUpdateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pet update created response has a 4xx status code
func (o *PetUpdateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this pet update created response has a 5xx status code
func (o *PetUpdateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this pet update created response a status code equal to that given
func (o *PetUpdateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the pet update created response
func (o *PetUpdateCreated) Code() int {
	return 201
}

func (o *PetUpdateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /pet][%d] petUpdateCreated %s", 201, payload)
}

func (o *PetUpdateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /pet][%d] petUpdateCreated %s", 201, payload)
}

func (o *PetUpdateCreated) GetPayload() *models.Pet {
	return o.Payload
}

func (o *PetUpdateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Pet)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPetUpdateBadRequest creates a PetUpdateBadRequest with default headers values
func NewPetUpdateBadRequest() *PetUpdateBadRequest {
	return &PetUpdateBadRequest{}
}

/*
PetUpdateBadRequest describes a response with status code 400, with default header values.

Invalid ID supplied
*/
type PetUpdateBadRequest struct {
}

// IsSuccess returns true when this pet update bad request response has a 2xx status code
func (o *PetUpdateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pet update bad request response has a 3xx status code
func (o *PetUpdateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pet update bad request response has a 4xx status code
func (o *PetUpdateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this pet update bad request response has a 5xx status code
func (o *PetUpdateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this pet update bad request response a status code equal to that given
func (o *PetUpdateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the pet update bad request response
func (o *PetUpdateBadRequest) Code() int {
	return 400
}

func (o *PetUpdateBadRequest) Error() string {
	return fmt.Sprintf("[PUT /pet][%d] petUpdateBadRequest", 400)
}

func (o *PetUpdateBadRequest) String() string {
	return fmt.Sprintf("[PUT /pet][%d] petUpdateBadRequest", 400)
}

func (o *PetUpdateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPetUpdateNotFound creates a PetUpdateNotFound with default headers values
func NewPetUpdateNotFound() *PetUpdateNotFound {
	return &PetUpdateNotFound{}
}

/*
PetUpdateNotFound describes a response with status code 404, with default header values.

Pet not found
*/
type PetUpdateNotFound struct {
}

// IsSuccess returns true when this pet update not found response has a 2xx status code
func (o *PetUpdateNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pet update not found response has a 3xx status code
func (o *PetUpdateNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pet update not found response has a 4xx status code
func (o *PetUpdateNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this pet update not found response has a 5xx status code
func (o *PetUpdateNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this pet update not found response a status code equal to that given
func (o *PetUpdateNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the pet update not found response
func (o *PetUpdateNotFound) Code() int {
	return 404
}

func (o *PetUpdateNotFound) Error() string {
	return fmt.Sprintf("[PUT /pet][%d] petUpdateNotFound", 404)
}

func (o *PetUpdateNotFound) String() string {
	return fmt.Sprintf("[PUT /pet][%d] petUpdateNotFound", 404)
}

func (o *PetUpdateNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPetUpdateMethodNotAllowed creates a PetUpdateMethodNotAllowed with default headers values
func NewPetUpdateMethodNotAllowed() *PetUpdateMethodNotAllowed {
	return &PetUpdateMethodNotAllowed{}
}

/*
PetUpdateMethodNotAllowed describes a response with status code 405, with default header values.

Validation exception
*/
type PetUpdateMethodNotAllowed struct {
}

// IsSuccess returns true when this pet update method not allowed response has a 2xx status code
func (o *PetUpdateMethodNotAllowed) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pet update method not allowed response has a 3xx status code
func (o *PetUpdateMethodNotAllowed) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pet update method not allowed response has a 4xx status code
func (o *PetUpdateMethodNotAllowed) IsClientError() bool {
	return true
}

// IsServerError returns true when this pet update method not allowed response has a 5xx status code
func (o *PetUpdateMethodNotAllowed) IsServerError() bool {
	return false
}

// IsCode returns true when this pet update method not allowed response a status code equal to that given
func (o *PetUpdateMethodNotAllowed) IsCode(code int) bool {
	return code == 405
}

// Code gets the status code for the pet update method not allowed response
func (o *PetUpdateMethodNotAllowed) Code() int {
	return 405
}

func (o *PetUpdateMethodNotAllowed) Error() string {
	return fmt.Sprintf("[PUT /pet][%d] petUpdateMethodNotAllowed", 405)
}

func (o *PetUpdateMethodNotAllowed) String() string {
	return fmt.Sprintf("[PUT /pet][%d] petUpdateMethodNotAllowed", 405)
}

func (o *PetUpdateMethodNotAllowed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
