package store_test

import (
	"context"
	"testing"

	"codeberg.org/superseriousbusiness/oauth2/v4/models"
	"codeberg.org/superseriousbusiness/oauth2/v4/store"

	. "github.com/smartystreets/goconvey/convey"
)

func TestClientStore(t *testing.T) {
	Convey("Test client store", t, func() {
		clientStore := store.NewClientStore()

		err := clientStore.Set(context.Background(), "1", models.New("1", "2", "", ""))
		So(err, ShouldBeNil)

		cli, err := clientStore.GetByID(context.Background(), "1")
		So(err, ShouldBeNil)
		So(cli.GetID(), ShouldEqual, "1")
	})
}
