#include "byte.h"

/**
  * @file byte.c
  * @author djb
  * @brief byte manipulation functions
  */

unsigned int byte_chr(char *s,unsigned int n,int c)
{
  char ch = c;
  char *t = s;

  for (;;) {
    if (!n) { break; } if (*t == ch) { break; } ++t; --n;
  }
  return t - s;
}

void byte_copy(void *to,unsigned int n,const void *from)
{
  char *out = to;         // share same address
  const char *in = from;  // one byte 

  for (;;) {
    if (!n) { return; } *out++ = *in++; --n;
  }
}

void byte_copyr(void *to,unsigned int n,const void *from)
{
  char *out = to + n;
  const char *in = from + n;

  for (;;) {
    if (!n) { return; } *--out = *--in; --n;
  }
}

int byte_diff(const void *s,unsigned int n,const void *t)
{
  const char *a = s;
  const char *b = t;

  for (;;) { 
    if (!n) { return 0; } if (*a != *b) { break; } ++a; ++b; --n;
  } 
  return ((int)(unsigned int)(unsigned char) *a)
       - ((int)(unsigned int)(unsigned char) *b);
}

unsigned int byte_rchr(char *s,unsigned int n,int c)
{
  char ch = c;
  char *t = s;
  char *u = 0;

  for (;;) {
    if (!n) { break; } if (*t == ch) { u = t; } ++t; --n; 
  }
  if (!u) { u = t; }
  return u - s;
}

void byte_zero(void *s,unsigned int n)
{
  char *out  = s;

  for (;;) {
    if (!n) { break; } *out++ = 0; --n;
  }
}

void byte_fill(void *to,unsigned int n,int c)
{
  char *s = to;
  char ch = c;

  for (;;) {
    if (!n) { break; } *s++ = ch; --n;
  }
}
