/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef BXX0_BASE64_IMAP_H
#define BXX0_BASE64_IMAP_H  1

#include <stddef.h>


/*! Library header for libbasexx Base 64 IMAP conversion module
 *
 * \file      base64_imap.h
 * \author    Michael Bäuerle
 * \date      2024
 * \copyright BSD-2-Clause
 *
 * Public API (compatible between all versions with same major number).
 *
 * API documentation: \ref BASE64_IMAP
 */


/*! \defgroup BASE64_IMAP Base 64 IMAP conversion
 *
 * Convert Base 64 to or from IMAP encoding (RFC 3501).
 *
 * Replace the character slash with comma (encode) and vice versa (decode).
 *
 * \attention
 * This module works with US-ASCII data. EBCDIC data must be converted to
 * US-ASCII first with \ref EBCDIC module.
 */
/*! \{ */


/*! Convert data from Base 64 to IMAP alphabet
 *
 * \param[out] buf  Pointer to buffer
 * \param[in]  len  Size of data to convert in buffer \e buf
 */
void bxx0_base64_imap_to(unsigned char *buf, size_t len);


/*! Convert data from IMAP alphabet to Base 64
 *
 * \param[out] buf  Pointer to buffer
 * \param[in]  len  Size of data to convert in buffer \e buf
 */
void bxx0_base64_imap_from(unsigned char *buf, size_t len);


/*! \} */


#endif  /* BXX0_BASE64_IMAP_H */
