# ==============================================================================
# PMBS fragment for documentation
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause

# Clear suffix list for inference rules
.SUFFIXES:

# If nothing is specified, make will use the first rule
all: documentation

# Build HTML documentation
documentation: Doxyfile README html/footer.html
	doxygen

Doxyfile: Doxyfile.in
	sed -e "s,@name@,$(PMBS_LIB_NAME_BASE),g" \
            -e "s,@release@,$(PMBS_RELEASE_VERSION),g" <$@.in >$@

# Strip SPDX license information for HTML documentation
README: ../../README
	sed -e '4d' -e '/SPDX-.*/d' <../../README >$@

html/footer.html: templates/footer.html
	mkdir html
	cat templates/footer.html >html/footer.html
