/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef SSIC0_I_ICONV_NAME_H
#define SSIC0_I_ICONV_NAME_H  1


/*
 * Header file for encoding names
 *
 * This file is used by the library and will not be installed.
 */


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/* IANA encoding names are limited to 40 US-ASCII characters */
#define SSIC0_I_NAME_MAX  40U


/*
 * Accept IANA alias names too, if nonzero.
 * Can be disabled to reduce memory footprint.
 */
#define SSIC0_I_NAME_ENABLE_ALIASES  1


/*
 * Accept some nonstandard alias names too, if nonzero.
 * Can be disabled to reduce memory footprint.
 */
#define SSIC0_I_NAME_ENABLE_NONSTANDARD  1


/* Flags to indicate source or target encoding */
#define SSIC0_I_NAME_SOURCE  0
#define SSIC0_I_NAME_TARGET  1


/* Encoding name/table definition */
struct ssic0_i_name_def
{
    const char  *name;   /* Name of encoding (NUL terminated string) */
    const char **table;  /* Mapping table from 0x80 (128 entries) */
};


/* Data type for name/table definition */
typedef struct ssic0_i_name_def  ssic0_i_name_def;


/* Name to table mappings */
extern const ssic0_i_name_def ssic0_i_name_tgt[];
extern const ssic0_i_name_def ssic0_i_name_src[];
#if SSIC0_I_NAME_ENABLE_ALIASES
extern const ssic0_i_name_def ssic0_i_name_src_alias[];
#endif  /* SSIC0_I_NAME_ENABLE_ALIASES */
#if SSIC0_I_NAME_ENABLE_NONSTANDARD
extern const ssic0_i_name_def ssic0_i_name_src_nonstd[];
#endif  /* SSIC0_I_NAME_ENABLE_NONSTANDARD */


/*! \endcond */


#pragma GCC visibility pop


#endif  /* SSIC0_I_ICONV_NAME_H */
