/*
 * Supported encoding list functions
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include <stddef.h>
#include <stdio.h>

#include "libuciconv-0/iconv.h"  /* Always include main header file first */
#include "iconv_name.h"


/* ========================================================================== */
#if UCIC0_I_NAME_ENABLE_ALIASES
static void ucic0_i_print_alias(ucic0_i_func func)
{
    size_t i = 0;

    while (NULL != ucic0_i_name_src_alias[i].name)
    {
        if (ucic0_i_name_src_alias[i].func == func)
        {
            printf(" %s", ucic0_i_name_src_alias[i].name);
        }
        ++i;
    }
}
#endif  /* UCIC0_I_NAME_ENABLE_ALIASES */


/* ========================================================================== */
#if UCIC0_I_NAME_ENABLE_NONSTANDARD
static void ucic0_i_print_nonstd(ucic0_i_func func)
{
    size_t i = 0;

    while (NULL != ucic0_i_name_src_nonstd[i].name)
    {
        if (ucic0_i_name_src_nonstd[i].func == func)
        {
            printf(" %s", ucic0_i_name_src_nonstd[i].name);
        }
        ++i;
    }
}
#endif  /* UCIC0_I_NAME_ENABLE_NONSTANDARD */


/* ========================================================================== */
void ucic0_print_codesets(void)
{

    printf("Supported output encodings\n");
    printf("--------------------------\n");
    printf("UTF-8\n");

    printf("\nSupported input encodings\n");
    printf("-------------------------\n");
    {
        size_t i = 0;

        while (NULL != ucic0_i_name_src[i].name)
        {
            printf("%s", ucic0_i_name_src[i].name);
#if UCIC0_I_NAME_ENABLE_ALIASES
            ucic0_i_print_alias(ucic0_i_name_src[i].func);
#endif  /* UCIC0_I_NAME_ENABLE_ALIASES */
#if UCIC0_I_NAME_ENABLE_NONSTANDARD
            ucic0_i_print_nonstd(ucic0_i_name_src[i].func);
#endif  /* UCIC0_I_NAME_ENABLE_NONSTANDARD */
            printf("\n");
            ++i;
        }
    }
}
