/*
 * Definition of pairs with encoding name and mapping table
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include <stddef.h>

#include "iconv_cesu-8.h"
#include "iconv_name.h"
#include "iconv_utf-7.h"


/* ========================================================================== */
/* IANA names supported as source encoding only */
const ucic0_i_name_def ucic0_i_name_src[] =
{
    { "UTF-7",  ucic0_i_conv_utf7 },

    { "CESU-8", ucic0_i_conv_cesu8 },

    { NULL, NULL }
};


#if UCIC0_I_NAME_ENABLE_ALIASES
/* ========================================================================== */
/* IANA aliases supported as source encoding only */
const ucic0_i_name_def ucic0_i_name_src_alias[] =
{
    { "csUTF7", ucic0_i_conv_utf7 },

    { "csCESU8",  ucic0_i_conv_cesu8 },
    { "csCESU-8", ucic0_i_conv_cesu8 },

    { NULL, NULL }
};
#endif  /* UCIC0_I_NAME_ENABLE_ALIASES */


#if UCIC0_I_NAME_ENABLE_NONSTANDARD
/* ========================================================================== */
/* Nonstandard aliases supported as source encoding only */
const ucic0_i_name_def ucic0_i_name_src_nonstd[] =
{
    { "UTF_7", ucic0_i_conv_utf7 },
    { "UTF7",  ucic0_i_conv_utf7 },

    { "CESU_8", ucic0_i_conv_cesu8 },
    { "CESU8",  ucic0_i_conv_cesu8 },

    { NULL, NULL }
};
#endif  /* UCIC0_I_NAME_ENABLE_NONSTANDARD */
