- [GitHub Attestation (Linux/MacOS/Windows)](#github-attestation-linuxmacoswindows)
- [MacOS Apple Signature and Notarization](#macos-apple-signature-and-notarization)
  - [Checking Signature](#checking-signature)
  - [Checking notarization](#checking-notarization)
- [Windows Code Sign](#windows-code-sign)
  - [Command Line](#command-line)
  - [GUI](#gui)

It's important to confirm you are always running an official GAM7 release. The following commands allow you to validate the GAM you have installed is official and has not been tampered with. Please report any suspicious files or concerns to the [GAM Group](https://groups.google.com/g/google-apps-manager) or the [GAM Chat Space](https://git.io/gam-chat)

# GitHub Attestation (Linux/MacOS/Windows)
GitHub offers [artifict attestations](https://docs.github.com/en/actions/security-for-github-actions/using-artifact-attestations/using-artifact-attestations-to-establish-provenance-for-builds) which prove if a given GAM binary or archive was built by the [GAM-team/GAM](https://gitHub.com/GAM-team/GAM) project and links to the build job. This offers you certainty that the GAM executable you are running or the GAM package you downloaded were officially generated by the [GAM-team/GAM](https://gitHub.com/GAM-team/GAM) project.

To verify a given GAM executable file or package (.zip, .msi or .tar.xz) is legitimate, use the following steps:
1. Install the [GitHub CLI command line tool](https://github.com/cli/cli#installation).
2. Login to the tool with the command. You need a [free GitHub account](https://gitHub.com/join) for this.
```
gh auth login
```
3. To verify the file and link to the build job that created it (assuming it is verified) run the command:

```
gh attestation verify --repo GAM-team/GAM --format=json \
  -q ".[].verificationResult.signature.certificate.runInvocationURI" \
  c:\GAM\gam.exe
```

4. If the GAM file or package is legit you'll see output like:
```
Loaded digest sha256:a63dc5e71c0b3335865877fc7dc9248bbf7481d22995c18253a2ae71fcb9793a for file://gam-7.00.00-windows-x86_64.msi
Loaded 1 attestation from GitHub API
✓ Verification succeeded!

https://github.com/GAM-team/GAM/actions/runs/9073209175/attempts/1
```

"✓ Verification succeeded!" means the file was created by the GAM-team/GAM project. The URL in the output is a link to the [GitHub Actions build job](https://docs.github.com/en/actions/about-github-actions/understanding-github-actions) that generated the file.

If you do not see the "Verification succeeded" response, the file you are using is not a GAM binary or package built by the project and may not be safe to use. Please report any suspicious files or concerns to the [GAM Group](https://groups.google.com/g/google-apps-manager) or the [GAM Chat Space](https://git.io/gam-chat).

# MacOS Apple Signature and Notarization
## Checking signature
To validate the signature on the GAM executable file, run the command:

```
codesign -dv --verbose=2 /path/to/gam
```

Here's an example output:

```
$ codesign -dv --verbose=2 ~/bin/gam7/gam
...
Authority=Developer ID Application: Jay Lee
Authority=Developer ID Certification Authority
Authority=Apple Root CA
...
```
"Authority=Developer ID Application: Jay Lee" is the most important line of the output and ensures your GAM executable was signed by Jay's Mac developer certificate which is only available to MacOS binaries generated by this [GAM-team/GAM](https://gitHub.com/GAM-team/GAM) project. Please report any suspicious files or concerns to the [GAM Group](https://groups.google.com/g/google-apps-manager) or the [GAM Chat Space](https://git.io/gam-chat).


## Checking notarization
To validate that Apple servers have notarized the GAM binary:

```
spctl -a -vvv -t install /path/to/gam
```

Here's an example output:

```
$ spctl -a -vvv -t install ~/bin/gam7/gam
gam: accepted
source=Notarized Developer ID
origin=Developer ID Application: Jay Lee (GZ85H2DRLM)
```
If you do not see "accepted" and "Jay Lee" as the developer ID, there may be a problem. Please report any suspicious files or concerns to the [GAM Group](https://groups.google.com/g/google-apps-manager) or the [GAM Chat Space](https://git.io/gam-chat).

# Windows Code Sign
On Windows, Official gam.exe files and MSI installer packages are signed by a [Certum Open Source code signing certificate](https://shop.certum.eu/open-source-code-signing.html). You can validate the signature and thus be sure you are running official GAM7 from the command line and GUI:
 
# Command Line
From PowerShell, run the following command:

```
Get-AuthenticodeSignature c:\gam7\gam.exe | Format-List -Property Status,StatusMessage,SignerCertificate
```

If your GAM installation is official and legitimate you should see output like:

```
Status            : Valid
StatusMessage     : Signature verified.
SignerCertificate : [Subject]
                      CN="Open Source Developer, James Lee", O=Open Source Developer, L=Plainsboro, S=New Jersey, C=US

                    [Issuer]
                      CN=Certum Code Signing 2021 CA, O=Asseco Data Systems S.A., C=PL

                    [Serial Number]
                      4E7C04C159B1E898C5FF41555C9934B7

                    [Not Before]
                      9/20/2024 7:18:46 AM

                    [Not After]
                      9/20/2025 7:18:45 AM

                    [Thumbprint]
                      590DC5BB10DFB31DBFF38C0E2F9C35EF0F6D0E9E
```

confirm that status is "Valid" and the SignerCertificate says "Open Source Developer, James Lee" (yes, James is Jay's legal name, now you know).

## GUI
From File Manager, you can right click on gam.exe or the MSI package and go to the Digital Signatures tab. From there you'll see the signing certificate which should show "Open Source Developer, James Lee".

![image](https://github.com/user-attachments/assets/dceb8cb8-36e0-4ed7-8b03-09322b49b06a)
