# rq Changelog

## v0.0.14

* bump embedded OPA version from v1.1.0 to v1.3.0
* add support for RFC8785 compliant canonical JSON output using the `json.canonical` option and the `-o jcs` output format alias
* `rq.template()` now has more helpful error messages
* added `str` builtin to `rq.template()` to coerce values of arbitrary types to string

## v0.0.13

* bump embedded OPA version from v1.0.0 to v1.1.0
* arguments for `rq.args()` can now be populated when using `rq script` in addition to when using `rq` as a shebang, resolving [#19](https://todo.sr.ht/~charles/rq/19)
* add `xml.list-style` output option
* new output formats:
    * `hcl`
* acknowledgments
    * HCL support is based on the implementation from `github.com/JFryy/qq`

## v0.0.12

* fixed bug where `RQ_REGO_V0` was not respected by `rq script`

## v0.0.11

* bump embedded OPA version from v0.69.0 to v1.0.0
* Rego is now run in v1 mode by default, though v0 compatibility may be enabled using the `--v0-compatible` flag or by defining `RQ_REGO_V0` environment variable to be a non-empty string
* fixed a bug where numbers in JSON inputs were incorrectly parsed into `float64` values rather than `json.Number`, resolving [#17](https://todo.sr.ht/~charles/rq/17)
* added additional helpful advice when dataspec characters are detected in `-i`/`-o`, resolving [#12](https://todo.sr.ht/~charles/rq/12)
* added `rq.strtonum()`builtin, resolving [#18](https://todo.sr.ht/~charles/rq/18)
* fixed behavior where undefined outputs evaluated to empty lists rather than `null`
* it is now possible to specify a `timeout` option for the `rq.run()` builtin, resolving [#13](https://todo.sr.ht/~charles/rq/13)
* fixed bug where syntax highlighting was not automatically disabled when the `--in-place` option was used
* removed the experimental `x.jp()` builtin

## v0.0.10

* bump embedded OPA version from v0.63.0 to v0.69.0
* new builtins:
	* `rq.slug()`
* new input formats: jsonc

## v0.0.9

* bump embedded OPA version from v0.58.0 to v0.63.0
* fixed a bug where a trailing newline would always be written to standard out, even when `-O` was asserted
* added `-c/--check` to make it easy to use rq from if statements in shell
* `-o null` now outputs 0 bytes, rather than a `\n`
* fixed a bug where incorrect TTY detection could cause piping the output of `rq` to another process to hang indefinitely

## v0.0.8

* bump embedded OPA version from v0.56.0 to v0.58.0
* `--ugly` now implies `--no-color`
* add `rq capabilities` subcommand to generate an OPA-style `capabilities.json` (#8)
* ship an OPA-style `capabilities.json` file for easier integration with tools that consume it (#8)
* adopt go-isatty for TTY detection (#9)
* disable output colorization on Windows unless `RQ_SUPPRESS_WINDOWS_NO_COLOR` is defined (#10)
* `rq.error()` now only displays the error string provided by the user (#6)
* `rq.run()` now accepts an `env` option to pass environment variables to the subprocess (#11)

## v0.0.7

* bump embedded OPA version from v0.54.0 to v0.56.0
* new builtins:
	* `rq.fake()`
	* `rq.sfake()`
	* `rq.quote()`
	* `rq.unquote()`
* new template functions:
	* `fake`
	* `sfake`
	* `quote`
	* `unquote`
* `text/template` is now used consistently throughout rq, which should fix template outputs sometimes containing URL-encoded characters
* added `-p/--in-place` option for modifying files in place
* new output formats: `null`
* refactored the `raw` output handler, added `raw.fl`, `raw.fs`, `raw.fr`, `raw.rl`, `raw.rs`, `raw.rr` options to bring it more inline with the `raw` input handler, and added support for tabular data
* `template` output handler now supports array shaped data by applying the template to each element, writing newlines (configurable by `template.sep`) in between

## v0.0.6

* bump embedded OPA version from v0.53.1 to v0.54.0
* removed completion support (I didn't feel it was good enough for a release yet)
* added "extension aliases" to treat `.yml` files as `.yaml` and `.jsonl` as `.ndjson` when the format is omitted from a dataspec
* add `tsv` input/output aliases, which use the `csv` handlers with appropriate settings for TSV
* add `-t / --template`
* add support for `strict=false` when parsing inputs, to silently ignore errors; the default behavior is unchanged
* new builtins:
	* `rq.abs()`
	* `rq.base()`
	* `rq.ext()`
	* `rq.dir()`
	* `rq.splitpath()`
	* `rq.joinpath()`
	* `raw.coalesce`
	* `rq.getwd()`
	* `rq.chdir()`
	* `rq.scriptpath()`
	* `rq.template()`
	* `rq.convert()`
* the `sh` output format now internally uses `subosito/gotenv`
* add `gotenv` output handler, which is an alias for `sh`
* add `install-completions` subcommand, which generates shell completions for bash, zsh, or fish
* factor out options common to only the `script` and `query` subcommands to reduce redundancy in `--help` output
* new input formats: raw, awk, tabular, lines, hjson, dhall, ndjson, template
* new output formats: toml, ndjson
* refactored the Makefile so it would be a bit more portable
* fixed issue where `-o md-table` could panic if any row had more columns than the header row
* switched from `github.com/BurntSushi/toml` to `github.com/pelletier/go-toml` to support marshaling outputs to TOML
* added ability to load OPA bundles using the `--bundle` flag
* added ability to save OPA bundles using the `--save-bundle` flag
* add experimental `x.jp()` builtin to execute [JSONPath](https://goessner.net/articles/JsonPath/) queries
* JSON input is now parsed using [jsoniter](https://github.com/json-iterator/go) for performance

## v0.0.5

* **backwards incompatible changes**
	* in situations where DataSpecs are used to specify formats and options but not file paths such as with `rq.run()`, providing a non-empty file path is now an error condition, rather than being silently ignored
	* when stringifying non-primitive values, the JSON marshaling of the value is now used unless it cannot be marshaled to JSON, in which case the previous behavior (`fmt.Sprintf("%v")`) is used
	* `github.com/yukithm/json2csv` has been replaced with a bespoke interface-to-table implementation in `util`, this changes the `csv` and `md-table` output handlers; fewer shapes of data are now supported
		* Array indices are no longer treated specially, so `some_field[0]` will now appear as `some_field.0` in CSV output
		* Only scalar primitive values, lists of lists, and lists of objects can be seralized to CSV now
	* `-d/--data` no longer supports comma-delimited DataSpecs; multiple DataSpecs can now only be specified by repeating the option
	* `-D/--csv-comma` now also applies to the output when combined with `-o csv`
	* `--version` has been replaced with the `version` subcommand
* fixed an issue where CSV files with UTF-8 byte order markers were not interpreted correctly by `-i csv` (thanks Cody!)
* bump embedded OPA version from v0.44.0 to v0.48.0
* new output formats: md-table, xml, sh
* new input formats: xml, ini, hcl, dotenv
* when converting floating point values to strings, trailing `.` symbols are now trimmed
* add `rq.encode()` builtin for encoding Rego values to string using an output handler
* add `rq.decode()` builtin for decoding strings to Rego values using an input handler
* the JSON, XML, and YAML output handlers now default to non-colorized, non-pretty printed output when instantiated (NOTE: this only impacts use of these handlers as libraries, the user-facing behavior of the `rq` tool is unchanged)
* add `rq.write()` builtin for encoding Rego values and writing them to a file using an `rq` output handler
* add `rq.read()` builtin for loading files from disk and decoding them to Rego values using an `rq` input handler
* add `csv.headers` to the `csv` output handler
* fixed an issue where attempting to use the `csv` output handler with heterogeneous row lengths would panic (thanks James!)
* add `rq.parsedate()` builtin for parsing dates in unknown formats
* fixed issue where JSON-formatted DataSpecs could not be used properly with `-d/--data` because the `,` was treated as a sequence separator rather than part of the argument
* fixed issue where `\t` could not be specified as the CSV comma character
* add `rq.version` builtin

## v0.0.4

The 0.0.4 release is identical to the 0.0.3 release except for the version number. The release tag had to be changed because the wrong version of `rq` ended up in the Go package cache under the `v0.0.3` tag.

## v0.0.3

* **backwards incompatible changes**
	* the format used for specifying paths with --data has changed
* new DataSpec format for specifying paths, formats, and options in a
  consistent way across the application
* refactor `input` and `output` packages into a single `io` package
* add `base64` input handler, for hard-coding inputs during testing
* add `--raw` as a shorthand for `-o raw`
* add `--input` to allow specifying arbitrary options for the input file
* add `--output` to allow specifying arbitrary options for the output file
* add helpful `TIP:` messages on standard error for some common failure modes
* bump embedded OPA version from v0.41.0 to v0.44.0
* add `rq.run()` builtin for running shell commands
* add `rq script` subcommand, support being used with `#!/usr/bin/env rq`
* add `rq.tree()` builtin for obtaining file listings
* `rq list-formats` is now guaranteed to list formats in sorted order
* add `rq.env()` builtin for accessing environment variables
* add `rq.args()` builtin for accessing script arguments
* `print()` now sends messages to standard error, rather than ignoring them
* add `rq.error()` builtin for error reporting
* the `json` input handler now automatically rewrites zero byte inputs to `{}`

## v0.02

* add support for `--data` to load external data files
* enable `print()` statements in Rego
* if stdin is a terminal, treat input as `{}` rather than exiting with an error
* new input formats: TOML
* new output formats: CSV, raw
* rename from rx to rq
* make JSON the default input handler
* add `rq list-formats` command
* for performance, do not invoke Rego when the query is empty

## v0.0.1

* initial version
* CSV, JSON, and YAML input support
* JSON and YAML output support
* support syntax highlighting with Chroma
