#!/bin/sh

# This is a regression test to ensure that the trailing newline is written to
# the target of -O, and not to standard output as it used to.

set -e
set -u
set -x

trap "rm -f ./actual.txt" EXIT

# this is needed because different platforms base64 implementations behave
# differently - some output a newline if the input is empty and others do not
REFERENCE="$(printf '' | base64)"

# the base64 is to make sure the $() does not eat the \n
OUT="$("$RQ" -O actual.txt '{}' | base64)"

if [ "$OUT" != "$REFERENCE" ] ; then
	echo "output should have been empty" 1>&2
	exit 1
fi

diff expect.txt actual.txt
