// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type EndpointScanTransportProtocol string

const (
	EndpointScanTransportProtocolUnknown EndpointScanTransportProtocol = ""
	EndpointScanTransportProtocolTCP     EndpointScanTransportProtocol = "tcp"
	EndpointScanTransportProtocolUDP     EndpointScanTransportProtocol = "udp"
	EndpointScanTransportProtocolIcmp    EndpointScanTransportProtocol = "icmp"
	EndpointScanTransportProtocolQuic    EndpointScanTransportProtocol = "quic"
)

func (e EndpointScanTransportProtocol) ToPointer() *EndpointScanTransportProtocol {
	return &e
}
func (e *EndpointScanTransportProtocol) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "tcp":
		fallthrough
	case "udp":
		fallthrough
	case "icmp":
		fallthrough
	case "quic":
		*e = EndpointScanTransportProtocol(v)
		return nil
	default:
		return fmt.Errorf("invalid value for EndpointScanTransportProtocol: %v", v)
	}
}

type EndpointScan struct {
	Banner            *string                        `json:"banner,omitempty"`
	BannerHashSha256  *string                        `json:"banner_hash_sha256,omitempty"`
	ChromeDevtools    *ChromeDevtools                `json:"chrome_devtools,omitempty"`
	CobaltStrike      *CobaltStrike                  `json:"cobalt_strike,omitempty"`
	Elasticsearch     *ElasticSearch                 `json:"elasticsearch,omitempty"`
	EndpointType      *string                        `json:"endpoint_type,omitempty"`
	Fortigate         *Fortigate                     `json:"fortigate,omitempty"`
	Graphql           *Graphql                       `json:"graphql,omitempty"`
	Hostname          *string                        `json:"hostname,omitempty"`
	HTTP              *HTTP                          `json:"http,omitempty"`
	IP                *string                        `json:"ip,omitempty"`
	IsSuccess         *bool                          `json:"is_success,omitempty"`
	IvantiAvalanche   *IvantiAvalanche               `json:"ivanti_avalanche,omitempty"`
	Kubernetes        *Kubernetes                    `json:"kubernetes,omitempty"`
	Ollama            *Ollama                        `json:"ollama,omitempty"`
	OpenDirectory     *OpenDirectory                 `json:"open_directory,omitempty"`
	Path              *string                        `json:"path,omitempty"`
	PlexMediaServer   *PlexMediaServer               `json:"plex_media_server,omitempty"`
	Port              *int                           `json:"port,omitempty"`
	Pprof             *Pprof                         `json:"pprof,omitempty"`
	Prometheus        *Prometheus                    `json:"prometheus,omitempty"`
	PrometheusTarget  *PrometheusTarget              `json:"prometheus_target,omitempty"`
	RedlionWeb        *RedlionWeb                    `json:"redlion_web,omitempty"`
	ScadaView         *ScadaView                     `json:"scada_view,omitempty"`
	ScanTime          *string                        `json:"scan_time,omitempty"`
	Screenshots       []Screenshot                   `json:"screenshots,omitempty"`
	TLS               *TLS                           `json:"tls,omitempty"`
	TransportProtocol *EndpointScanTransportProtocol `json:"transport_protocol,omitempty"`
}

func (o *EndpointScan) GetBanner() *string {
	if o == nil {
		return nil
	}
	return o.Banner
}

func (o *EndpointScan) GetBannerHashSha256() *string {
	if o == nil {
		return nil
	}
	return o.BannerHashSha256
}

func (o *EndpointScan) GetChromeDevtools() *ChromeDevtools {
	if o == nil {
		return nil
	}
	return o.ChromeDevtools
}

func (o *EndpointScan) GetCobaltStrike() *CobaltStrike {
	if o == nil {
		return nil
	}
	return o.CobaltStrike
}

func (o *EndpointScan) GetElasticsearch() *ElasticSearch {
	if o == nil {
		return nil
	}
	return o.Elasticsearch
}

func (o *EndpointScan) GetEndpointType() *string {
	if o == nil {
		return nil
	}
	return o.EndpointType
}

func (o *EndpointScan) GetFortigate() *Fortigate {
	if o == nil {
		return nil
	}
	return o.Fortigate
}

func (o *EndpointScan) GetGraphql() *Graphql {
	if o == nil {
		return nil
	}
	return o.Graphql
}

func (o *EndpointScan) GetHostname() *string {
	if o == nil {
		return nil
	}
	return o.Hostname
}

func (o *EndpointScan) GetHTTP() *HTTP {
	if o == nil {
		return nil
	}
	return o.HTTP
}

func (o *EndpointScan) GetIP() *string {
	if o == nil {
		return nil
	}
	return o.IP
}

func (o *EndpointScan) GetIsSuccess() *bool {
	if o == nil {
		return nil
	}
	return o.IsSuccess
}

func (o *EndpointScan) GetIvantiAvalanche() *IvantiAvalanche {
	if o == nil {
		return nil
	}
	return o.IvantiAvalanche
}

func (o *EndpointScan) GetKubernetes() *Kubernetes {
	if o == nil {
		return nil
	}
	return o.Kubernetes
}

func (o *EndpointScan) GetOllama() *Ollama {
	if o == nil {
		return nil
	}
	return o.Ollama
}

func (o *EndpointScan) GetOpenDirectory() *OpenDirectory {
	if o == nil {
		return nil
	}
	return o.OpenDirectory
}

func (o *EndpointScan) GetPath() *string {
	if o == nil {
		return nil
	}
	return o.Path
}

func (o *EndpointScan) GetPlexMediaServer() *PlexMediaServer {
	if o == nil {
		return nil
	}
	return o.PlexMediaServer
}

func (o *EndpointScan) GetPort() *int {
	if o == nil {
		return nil
	}
	return o.Port
}

func (o *EndpointScan) GetPprof() *Pprof {
	if o == nil {
		return nil
	}
	return o.Pprof
}

func (o *EndpointScan) GetPrometheus() *Prometheus {
	if o == nil {
		return nil
	}
	return o.Prometheus
}

func (o *EndpointScan) GetPrometheusTarget() *PrometheusTarget {
	if o == nil {
		return nil
	}
	return o.PrometheusTarget
}

func (o *EndpointScan) GetRedlionWeb() *RedlionWeb {
	if o == nil {
		return nil
	}
	return o.RedlionWeb
}

func (o *EndpointScan) GetScadaView() *ScadaView {
	if o == nil {
		return nil
	}
	return o.ScadaView
}

func (o *EndpointScan) GetScanTime() *string {
	if o == nil {
		return nil
	}
	return o.ScanTime
}

func (o *EndpointScan) GetScreenshots() []Screenshot {
	if o == nil {
		return nil
	}
	return o.Screenshots
}

func (o *EndpointScan) GetTLS() *TLS {
	if o == nil {
		return nil
	}
	return o.TLS
}

func (o *EndpointScan) GetTransportProtocol() *EndpointScanTransportProtocol {
	if o == nil {
		return nil
	}
	return o.TransportProtocol
}
