// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type JarmScanTransportProtocol string

const (
	JarmScanTransportProtocolUnknown JarmScanTransportProtocol = ""
	JarmScanTransportProtocolTCP     JarmScanTransportProtocol = "tcp"
	JarmScanTransportProtocolUDP     JarmScanTransportProtocol = "udp"
	JarmScanTransportProtocolIcmp    JarmScanTransportProtocol = "icmp"
	JarmScanTransportProtocolQuic    JarmScanTransportProtocol = "quic"
)

func (e JarmScanTransportProtocol) ToPointer() *JarmScanTransportProtocol {
	return &e
}
func (e *JarmScanTransportProtocol) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "tcp":
		fallthrough
	case "udp":
		fallthrough
	case "icmp":
		fallthrough
	case "quic":
		*e = JarmScanTransportProtocol(v)
		return nil
	default:
		return fmt.Errorf("invalid value for JarmScanTransportProtocol: %v", v)
	}
}

type JarmScan struct {
	// The first 30 character portion of the Jarm fingerprint.
	CipherAndVersionFingerprint *string `json:"cipher_and_version_fingerprint,omitempty"`
	// The 62 character Jarm fingerprint of the service.
	Fingerprint *string `json:"fingerprint,omitempty"`
	Hostname    *string `json:"hostname,omitempty"`
	IP          *string `json:"ip,omitempty"`
	IsSuccess   *bool   `json:"is_success,omitempty"`
	Port        *int    `json:"port,omitempty"`
	// The time the service was fingerprinted
	ScanTime *string `json:"scan_time,omitempty"`
	// The second 32 character portion of the Jarm fingerprint
	TLSExtensionsSha256 *string                    `json:"tls_extensions_sha256,omitempty"`
	TransportProtocol   *JarmScanTransportProtocol `json:"transport_protocol,omitempty"`
}

func (o *JarmScan) GetCipherAndVersionFingerprint() *string {
	if o == nil {
		return nil
	}
	return o.CipherAndVersionFingerprint
}

func (o *JarmScan) GetFingerprint() *string {
	if o == nil {
		return nil
	}
	return o.Fingerprint
}

func (o *JarmScan) GetHostname() *string {
	if o == nil {
		return nil
	}
	return o.Hostname
}

func (o *JarmScan) GetIP() *string {
	if o == nil {
		return nil
	}
	return o.IP
}

func (o *JarmScan) GetIsSuccess() *bool {
	if o == nil {
		return nil
	}
	return o.IsSuccess
}

func (o *JarmScan) GetPort() *int {
	if o == nil {
		return nil
	}
	return o.Port
}

func (o *JarmScan) GetScanTime() *string {
	if o == nil {
		return nil
	}
	return o.ScanTime
}

func (o *JarmScan) GetTLSExtensionsSha256() *string {
	if o == nil {
		return nil
	}
	return o.TLSExtensionsSha256
}

func (o *JarmScan) GetTransportProtocol() *JarmScanTransportProtocol {
	if o == nil {
		return nil
	}
	return o.TransportProtocol
}
