package hashutil

import (
	"crypto/hmac"
	"crypto/sha256"
	"encoding/hex"
)

// HashPasswd for quick hash an input password string, use sha256.
func HashPasswd(pwd, key string) string {
	hm := hmac.New(sha256.New, []byte(key))
	hm.Write([]byte(pwd))

	return hex.EncodeToString(hm.Sum(nil))
}

// VerifyPasswd for quick verify input password is valid
//
// - wantPwd from db or config, generated by EncryptPasswd()
func VerifyPasswd(wantPwd, pwd, key string) bool {
	decBts, err := hex.DecodeString(wantPwd)
	if err != nil {
		return false
	}

	hm := hmac.New(sha256.New, []byte(key))
	hm.Write([]byte(pwd))

	return hmac.Equal(decBts, hm.Sum(nil))
}
