// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Fleet Application Management Service API
//
// Fleet Application Management provides a centralized platform to help you automate resource management tasks, validate patch compliance, and enhance operational efficiency across an enterprise.
//

package fleetappsmanagement

import (
	"strings"
)

// CompliancePolicyRuleSortByEnum Enum with underlying type: string
type CompliancePolicyRuleSortByEnum string

// Set of constants representing the allowable values for CompliancePolicyRuleSortByEnum
const (
	CompliancePolicyRuleSortByTimeCreated CompliancePolicyRuleSortByEnum = "timeCreated"
	CompliancePolicyRuleSortByDisplayName CompliancePolicyRuleSortByEnum = "displayName"
)

var mappingCompliancePolicyRuleSortByEnum = map[string]CompliancePolicyRuleSortByEnum{
	"timeCreated": CompliancePolicyRuleSortByTimeCreated,
	"displayName": CompliancePolicyRuleSortByDisplayName,
}

var mappingCompliancePolicyRuleSortByEnumLowerCase = map[string]CompliancePolicyRuleSortByEnum{
	"timecreated": CompliancePolicyRuleSortByTimeCreated,
	"displayname": CompliancePolicyRuleSortByDisplayName,
}

// GetCompliancePolicyRuleSortByEnumValues Enumerates the set of values for CompliancePolicyRuleSortByEnum
func GetCompliancePolicyRuleSortByEnumValues() []CompliancePolicyRuleSortByEnum {
	values := make([]CompliancePolicyRuleSortByEnum, 0)
	for _, v := range mappingCompliancePolicyRuleSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetCompliancePolicyRuleSortByEnumStringValues Enumerates the set of values in String for CompliancePolicyRuleSortByEnum
func GetCompliancePolicyRuleSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingCompliancePolicyRuleSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingCompliancePolicyRuleSortByEnum(val string) (CompliancePolicyRuleSortByEnum, bool) {
	enum, ok := mappingCompliancePolicyRuleSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
