// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Digital Assistant Service Instance API
//
// API to create and maintain Oracle Digital Assistant service instances.
//

package oda

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ResourceTypeImportContract The contract guiding the import experience for the consumer and behavior of the resource provider for a single resourceType.
type ResourceTypeImportContract struct {

	// The type of resource to which this resourceType-specific contract applies
	ResourceType *string `mandatory:"true" json:"resourceType"`

	// A list of definitions for parameters that are required to import this package into a target instance.
	Parameters []ParameterDefinition `mandatory:"true" json:"parameters"`
}

func (m ResourceTypeImportContract) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ResourceTypeImportContract) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
