# typed: false
# frozen_string_literal: true

# This file was generated by GoReleaser. DO NOT EDIT.
class Actionlint < Formula
  desc "Static checker for GitHub Actions workflow files"
  homepage "https://github.com/rhysd/actionlint#readme"
  version "1.7.2"
  license "MIT"

  on_macos do
    on_intel do
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.2/actionlint_1.7.2_darwin_amd64.tar.gz"
      sha256 "78c3029bd85421347a550f9e30237f77f428226a9cb56ac19582e54e42dc7e37"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
    on_arm do
      url "https://github.com/rhysd/actionlint/releases/download/v1.7.2/actionlint_1.7.2_darwin_arm64.tar.gz"
      sha256 "a953f205b1a0693277c82b4b333d2e0e1df322d4c132ce008f11de26a2886e67"

      def install
        bin.install "actionlint"
        man1.install "man/actionlint.1"
      end
    end
  end

  on_linux do
    on_intel do
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.2/actionlint_1.7.2_linux_amd64.tar.gz"
        sha256 "e1537c2032d3517e2e257dc0ad51777da56be4a62d3cf0ee290e3aa36da012a1"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    on_arm do
      if !Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.2/actionlint_1.7.2_linux_armv6.tar.gz"
        sha256 "5677c1406741f499de4ac9108e05656d6375bff562dd9957d0a272c1fcc75021"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
    on_arm do
      if Hardware::CPU.is_64_bit?
        url "https://github.com/rhysd/actionlint/releases/download/v1.7.2/actionlint_1.7.2_linux_arm64.tar.gz"
        sha256 "44b6f6b97cf013b3d3dc2b4c491b6b718edebaa0af28512d273a74681ed7246e"

        def install
          bin.install "actionlint"
          man1.install "man/actionlint.1"
        end
      end
    end
  end

  test do
    system "#{bin}/actionlint -version"
  end
end
