// Bind shell payloads & listeners.
//
// The bindshell package contains all the code for generating bind shells that listen on a port for
// interaction.
//
// As with all the payload sub-packages, each of these payload types can be used either in the raw string
// format for manipulation or via the specific payload type provided by the project. This allows the
// following usage patterns to have the same output:
//
//	bindshell.Netcat.Default(1337)
//	bindshell.Netcat.Mknod(1337)
//	fmt.Sprintf(bindshell.NetcatMknod, 1337)
package bindshell

type BindShell interface {
	Default
}

type Default interface{}

type (
	NetcatPayload struct{}
	TelnetPayload struct{}
)

var (
	Netcat = &NetcatPayload{}
	Telnet = &TelnetPayload{}
)
