#!/bin/sh

test_description="Check that the following use-case won't rebuild everytime and has correct dependencies"
. $SHARNESS_TEST_SRCDIR/sharness.sh
export REDO_TOP_DIR="`pwd`" REDO_NO_PROGRESS=1

mkdir -p sub
cat >default.html.do <<EOF
redo-ifchange \$2.pre
echo HTML
cat \$2.pre
EOF
cat >default.pre.do <<EOF
redo-ifchange *.inc \$2.html.in
echo PRE
cat \$2.html.in
EOF
echo FOOTER >footer.inc
echo "<html>" >sub/index.html.in

test_expect_success Build "redo sub/index.html"
stat1=`stat sub/index.html`
test_expect_success Rebuild "redo-ifchange sub/index.html"
stat2=`stat sub/index.html`
test_expect_success "Was not rebuild" '[ "$stat1" = "$stat2" ]'

tgts=`redo-dep2rec sub/.redo/index.html.dep | sed -n "s/^Target: //p" | sort`
tgts=`echo $tgts`
tgts_expected="../default.html.do" # .do itself
tgts_expected="$tgts_expected default.do" # ifcreate
tgts_expected="$tgts_expected default.html.do" # ifcreate
tgts_expected="$tgts_expected index.html" # check for user-modification
tgts_expected="$tgts_expected index.html.do" # ifcreate
tgts_expected="$tgts_expected index.pre" # source
test_expect_success "Correct dependencies" '[ "$tgts" = "$tgts_expected" ]'

test_done
