# 域名屏蔽

GoToSocial 支持屏蔽/封禁那些你不想与你的实例联合的域名。在我们的文档中，“屏蔽”和“封禁”这两个术语在涉及域名时可以互换使用，因为它们的意思相同：屏蔽你的实例与目标域名上的实例相互通信，有效地切断两个实例之间的联合。

你可以使用[实例管理面板](./settings.md#域名权限)查看、创建和移除域名屏蔽和域名允许。

本文档重点说明域名屏蔽实际*作用*是什么，以及创建新域名屏蔽时会产生哪些副作用。

## 域名屏蔽如何工作

域名屏蔽通过两种方式工作：

首先，它指示你的实例拒绝来自目标域名的任何请求：

- 从被屏蔽域名到你的实例的所有传入请求将以 HTTP 状态码 `403 Forbidden` 响应。
- 这使目标域名上的帐户无法与你实例上的帐户或该帐户创建的任何贴文进行互动，因为你的实例会简单地拒绝处理请求。
- 这也延伸到 GET 请求：你的实例将不再对被屏蔽实例的请求提供 ActivityPub 响应，例如获取帐户简介或置顶贴文等。
- 你的实例上的帐户的贴文转发也不应对被屏蔽的实例可见，因为那些实例将无法获取已转发贴文的内容。

其次，域名屏蔽指示你的实例不再向目标实例发出任何请求。这意味着：

- 你的实例不会向被屏蔽域名上的实例发送任何消息。
- 也不会从该实例获取贴文、帐户、媒体或表情符号。

## 安全顾虑

### 屏蔽规避

域名屏蔽并不完全严密。GoToSocial *可以* 确保自身既不响应来自被屏蔽域名的请求，也不向这些实例发出请求。不幸的是，它*无法*保证你的实例上的帐户不会以任何方式对被屏蔽实例的用户可见。请考虑以下情况，这些都代表了一种[屏蔽规避](https://en.wikipedia.org/wiki/Block_(Internet)#Evasion)：

- 你屏蔽了 `blocked.instance.org`。`blocked.instance.org` 上的用户在 `not-blocked.domain` 上创建了一个帐户，以便他们可以使用新帐户与你的帖子互动或向你发送消息。他们可能会直接跳脸，告诉你他们是谁，或者使用假身份。
- 你屏蔽了 `blocked.instance.org`。`not-blocked.domain` 上的用户截屏了你的贴文并将其发送给 `blocked.instance.org` 上的某人。
- 你屏蔽了 `blocked.instance.org`。`blocked.instance.org` 上的用户通过浏览器访问你的个人资料，以查看你的公开贴文。
- 你屏蔽了 `blocked.instance.org`。你的个人资料启用了 RSS。`blocked.instance.org` 上的用户订阅了你的 RSS feed 以阅读你的公开贴文。

在上述情况下，`blocked.instance.org` 依然被屏蔽，但该实例的用户可能仍有其他方式查看你的贴文并可能联系到你。

考虑到这一点，你应始终将域名屏蔽视为隐私保护的*一个层次*。也就是说，域名屏蔽应该与其他层次一起部署，以实现你所满意的隐私水平。这应包括不公开发布敏感信息、不在照片中意外暴露个人信息等。

### 屏蔽公告机器人

不幸的是，联邦宇宙中有一些恶意用户，他们将域名屏蔽视为敌人而试图打破。为达到此目的，他们通常会针对那些使用域名屏蔽来保护用户的实例。

因此，联邦宇宙中有机器人抓取实例域名屏蔽，并向机器人的关注者宣布任何发现的屏蔽，从而使屏蔽实例的管理员可能面临骚扰。这些机器人使用 `api/v1/instance/peers?filter=suspended` 端点来收集域名屏蔽信息。

默认情况下，GoToSocial 不会公开此端点，因此你的实例将不会被这种方式抓取。然而，如果你在 config.yaml 文件中将 `instance-expose-suspended` 设置为 `true`，你可能会发现此端点偶尔会被抓取，并且你的屏蔽可能会被恶意机器人宣布。

## 创建域名屏蔽的副作用

当你创建新的域名屏蔽（或重新提交现有的域名屏蔽）时，你的实例将处理该屏蔽的副作用。这些副作用是：

1. 将数据库中存储自目标域的所有帐户标记为已封禁，并删除被标记帐户的大多数信息（简介、显示名称、字段等）。
2. 清除本地帐户与封禁帐户之间的所有互关或单方面关系（关注、被关注、关注请求、收藏等）。
3. 删除封禁帐户的所有贴文。
4. 删除封禁帐户及其贴文的所有媒体，包括媒体附件、头像、头图和表情符号。

!!! danger "危险"
    目前，上述大多数副作用是**不可逆**的。如果你在屏蔽后取消屏蔽一个域名，该域名上的所有帐户将不再被标记为已封禁，并且你将能够再次与他们互动，但所有关系仍将被清除，所有贴文和媒体将被删除。
    
    在屏蔽一个域名之前请仔细考虑。

## 屏蔽一个域名及其所有子域

当你添加一个新的域名屏蔽时，GoToSocial 也将屏蔽该域名的所有子域。如果你不信任域名所有者，你可以选择屏蔽某些特定子域，或者更一般地屏蔽整个域名。

一些例子：

1. 你屏蔽 `example.org`。这将屏蔽以下域名（非详尽列表）：`example.org`，`subdomain.example.org`，`another-subdomain.example.org`，`sub.sub.sub.domain.example.org`。
2. 你屏蔽 `baddies.example.org`。这将屏蔽以下域名（非详尽列表）：`baddies.example.org`，`really-bad.baddies.example.org`。然而，以下域名不会被屏蔽（非详尽列表）：`example.org`，`subdomain.example.org`，`not-baddies.example.org`。

一个更实际的例子：

某个家伙拥有域名 `fossbros-anonymous.io`。他们不仅在 `mastodon.fossbros-anonymous.io` 运行 Mastodon 实例，还在 `gts.fossbros-anonymous.io` 运行 GoToSocial 实例，以及在 `akko.fossbros-anonymous.io` 运行 Akkoma 实例。你希望一次性屏蔽他们的所有这些实例（以及他们可能在未来创建的任何实例，例如 `pl.fossbros-anonymous.io` 等）。你可以通过简单地为 `fossbros-anonymous.io` 创建域名屏蔽来实现。子域上的任何实例将无法与你的实例通信。搞定！
