# 媒体缓存

GoToSocial 使用配置的[存储后端](https://docs.gotosocial.org/zh-cn/latest/configuration/storage/)来存储由本站用户上传到实例的媒体（图像、视频等），并缓存从外站实例联合过来的贴文和个人资料中附带的媒体。

由本站用户上传的媒体将会永久保存在存储中（除非其所属的贴文或账户被删除），以便能够随时响应来自外站的请求。

另一方面，外站媒体仅会被临时缓存。经过一段时间（见下文）后，它将从存储中移除，以帮助缓解存储空间的使用。通过这种方式被移除缓存的外站媒体，如果再次需要，将自动从外站重新获取。

!!! info "为什么要缓存？"
    你可能会认为应该完全不缓存外站媒体，因为它始终可以在原始服务器上获取。为什么不完全放弃缓存，而依赖外站根据需求提供服务呢？

    虽然这是节省存储空间的一种简单方法，但它可能会引发其他问题，并且通常被认为是不够礼貌的做法。

    例如，假设某个小实例的用户发布了一条带有图片的有趣贴文。该贴文被一个拥有1000名跨5个不同实例（每个实例200人）关注者的账号转发。这1000人便会同时在时间线上看到这个图片。

    如果没有外站媒体缓存，可能会导致多达1000个请求同时冲击小实例，因为每个接收者的浏览器必须单独请求从小实例获取该图片。这会导致小实例的流量激增。在极端情况下，可能导致实例无响应或崩溃，本质上是对其进行分布式拒绝服务攻击（DDOS）。

    然而，通过启用外站媒体缓存，将一条贴文转发给1000名来自5个不同实例的用户仅会向小实例发出5个请求：每个实例1个请求。然后，每个实例会从缓存的外站图片版本为其本站用户提供200个请求，有效地分散了负载，保护了较小的实例。

## 清理

外站媒体缓存的清理是一个计划的后台进程，管理员无需手动干预。根据服务器速度、配置的存储速度和待处理的媒体数量，清理时间大约在5到30分钟之间。

GoToSocial 提供了三个变量，让你（管理员）可以调节何时以及如何进行这些操作：`media-remote-cache-days`、`media-cleanup-from` 和 `media-cleanup-every`。

默认情况下，这些变量设置如下：

| 变量名称                     | 默认值       | 含义     |
|-----------------------------|--------------|----------|
| `media-remote-cache-days`   | `7`          | 7天      |
| `media-cleanup-from`        | `"00:00"`    | 午夜     |
| `media-cleanup-every`       | `"24h"`      | 每日     |

换句话说，默认设置意味着每晚午夜，超过一周的外站媒体将被清除并从存储中移除。

你可以通过调节这些变量实现不同的效果。例如，如果你希望在凌晨4:30而不是午夜进行清理，你可以将 `media-cleanup-from` 改为 `"04:30"`。

如果你只想每隔几天而不是每晚进行清理，可以将 `media-cleanup-every` 设置为更高的值，如 `"48h"` 或 `"72h"`。

如果你想采用更积极的清理策略以尽量减少存储使用，可以设置以下值：

| 变量名称                     | 设置值       | 含义            |
|-----------------------------|--------------|-----------------|
| `media-remote-cache-days`   | `1`          | 1天             |
| `media-cleanup-from`        | `"00:00"`    | 午夜            |
| `media-cleanup-every`       | `"8h"`       | 每8小时         |

上述设置意味着从午夜开始每8小时，GoToSocial 将清除任何缓存超过1天（24小时）的媒体。清理任务将在 00:00、08:00 和 16:00，即午夜、上午8点和下午4点运行。使用此配置，你可能将外站媒体在存储中保留的最长时间约为32小时。

!!! tip "提示"
    将 `media-remote-cache-days` 设置为0或更小意味着外站媒体将永不被清除。然而，本站孤立媒体的清理任务和其他一致性检查仍将按其他变量定义的计划运行。

!!! tip "提示"
    如果你愿意，你也可以通过管理面板手动执行一次性清理操作（[查看文档](./settings.md#媒体)）。

!!! warning "警告"
    将 `media-cleanup-every` 设置为非常小的值，如 `"30m"` 或更小，可能会导致你的实例不断遍历附件，导致数据使用率高而效益甚微。我们不建议将该值设置为小于约 `"8h"`，即便如此，可能也显得过度。
