# 媒体

## 设置

```yaml
########################
##### 媒体配置 ######
########################

# 关于媒体上传（媒体，图片描述，表情符号）的配置。

# 大小。通过 API 上传的媒体最大大小（字节）。
#
# 增大此限制可能导致其他服务器无法获取贴文中的媒体。
#
# 示例: [2097152, 10485760, 40MB, 40MiB]
# 默认: 40MiB (41943040 字节)
media-local-max-size: 40MiB

# 大小。从其他实例下载媒体的最大大小（字节）。
#
# 降低此限制可能导致你的实例无法获取贴文中的媒体。
#
# 示例: [2097152, 10485760, 40MB, 40MiB]
# 默认: 40MiB (41943040 字节)
media-remote-max-size: 40MiB

# 整数。图像或视频描述所需的最小字符数。
# 示例: [500, 1000, 1500]
# 默认: 0 （无要求）
media-description-min-chars: 0

# 整数。图像或视频描述允许的最大字符数。
# 示例: [1000, 1500, 3000]
# 默认: 1500
media-description-max-chars: 1500

# 大小。通过管理员 API 上传到本站的表情最大大小（字节）。
#
# 默认值与 Mastodon 表情大小限制相同（50kb），这有助于实现良好的互操作性。提高此限制可能会影响表情在其他实例间的联合，需谨慎。
#
# 示例: [51200, 102400, 50KB, 50KiB]
# 默认: 50KiB (51200 字节)
media-emoji-local-max-size: 50KiB

# 大小。从其他实例下载表情的最大大小（字节）。
#
# 默认值为 100kb，是 media-emoji-local-max-size 默认值的两倍。这在较高表情大小限制的实例间保持良好的互操作性，并且不会占用太多存储空间。
#
# 示例: [51200, 102400, 100KB, 100KiB]
# 默认: 100KiB (102400 字节)
media-emoji-remote-max-size: 100KiB

# 整数。添加到媒体处理池中的 ffmpeg+ffprobe 实例数量。
#
# 增加此数量会加快并发媒体处理速度，但每增加一个实例将消耗约 250MB 的（峰值）内存。
#
# 如果你有多余的 RAM，并且/或者你为超过 50 人提供服务（他们发布/查看大量媒体），你可以增加这个数值，但单用户实例或在受限（低内存）环境中运行 GoToSocial 时应保持为 1。
#
# 如果将此数值设为 0 或更少，则会根据 GOMAXPROCS x 1 进行缩放，通常会在主机的每个 CPU 核上生成一个 ffmpeg 实例和一个 ffprobe 实例。
#
# 示例: [1, 2, -1, 8]
# 默认: 1
media-ffmpeg-pool-size: 1

# 以下媒体清理设置允许管理员自定义什么时候运行媒体清理 + 修剪作业及执行相关作业的频率，默认设置为相对合理（每晚午夜）。有关这些设置的具体操作及一些自定义示例，请参见文档:
# https://docs.gotosocial.org/zh-cn/latest/admin/media_caching#cleanup

# 整数。从外站实例缓存媒体的天数，到期之后它们将从缓存中移除。当外站媒体从缓存中移除时，它会从存储中删除，但媒体的数据库条目将保留，以便用户请求时可以重新获取。
#
# 如果设置为 0，外站实例的媒体将无限期缓存。
#
# 示例: [30, 60, 7, 0]
# 默认: 7
media-remote-cache-days: 7

# 字符串。24 小时格式的时间，格式为 hh:mm。
# 示例: ["14:30", "00:00", "04:00"]
# 默认: "00:00" (午夜)。
media-cleanup-from: "00:00"

# 时长。媒体清理运行之间的间隔。
# 每 24 小时多次清理不推荐并且可能是不必要的。将此值设置得过低（如每 10 分钟一次）可能会导致队列滞后并可能产生其他问题。
# 示例: ["24h", "72h", "12h"]
# 默认: "24h"（每天一次）。
media-cleanup-every: "24h"
```
