# 邮件配置 (smtp)

GoToSocial 支持通过[简单邮件传输协议](https://wikipedia.org/wiki/Simple_Mail_Transfer_Protocol)（即 **smtp**）向用户发送邮件。

配置 GoToSocial 发送邮件不是必需的，但它在发送确认邮件、通知以及处理密码重置请求等方面非常有用。

要使 GoToSocial 可以发送邮件，你需要一项支持 smtp 的邮件服务，可以在 GoToSocial 所运行的同一台机器上运行SMTP服务器，也可以使用像 [Mailgun](https://mailgun.com) 这样的外部服务。如果你的邮件提供商支持 smtp（请咨询他们—大多数都支持），也可能使用免费的个人电子邮件地址发送邮件，但如果发送大量邮件，可能会遇到问题。

要验证你的配置，你可以使用设置面板中的“管理 -> 操作 -> 邮件”部分来发送测试邮件。

## 设置

以下是 smtp 的配置选项：

```yaml
#######################
##### SMTP 配置 #####
#######################

# 配置通过 smtp 服务器发送邮件。详情请见 https://en.wikipedia.org/wiki/Simple_Mail_Transfer_Protocol

# 字符串。你想使用的 smtp 服务器的主机名。
# 如果未设置，将不使用 smtp 发送邮件，你可以忽略其他设置。
# 示例: ["mail.example.org", "localhost"]
# 默认值: ""
smtp-host: ""

# 整数。用于连接 smtp 服务器的端口。
# 在大多数情况下，你应使用端口 587。
# 示例: []
# 默认值: 0
smtp-port: 0

# 字符串。与 smtp 服务器进行身份验证时使用的用户名。
# 你的 smtp 服务应已提供给你。
# 这通常是（但不总是）一个电子邮件地址。
# 示例: ["maillord@example.org"]
# 默认值: ""
smtp-username: ""

# 字符串。与 smtp 服务器进行身份验证时使用的密码。
# 你的 smtp 服务应已提供给你。
# 示例: ["1234", "password"]
# 默认值: ""
smtp-password: ""

# 字符串。发送邮件的‘发件人’地址。
# 示例: ["mail@example.org"]
# 默认值: ""
smtp-from: ""

# 布尔值。如果为 true，当一封邮件有多个收件人时，每个收件人都将包含在收件人字段中，以便每个收件人可以看到其他谁收到了邮件，并且如果他们愿意，可以“回复所有人”。
#
# 如果为 false，邮件将发送给未公开的收件人，并且每个收件人将看不到其他收件人。
#
# 如果你希望通过“回复所有人”来讨论新的举报，可能需要将此设置更改为 'true'。
# 默认值: false
smtp-disclose-recipients: false
```

请注意，如果你没有设置 `Host`，则 smtp 发送邮件将被禁用，其他设置将被忽略。GoToSocial 仍会记录（跟踪级别）如果启用 smtp 本可以发送的邮件。

## 什么时候发送电子邮件？

目前，电子邮件在以下场景中发送：

- 向新用户通过注册页面或 API 创建新账户时，向其提交的电子邮件地址发送确认请求。
- 当新账户通过上述渠道创建账户时，向实例管理员发送通知。
- 当收到新的举报时，向所有活跃的实例管理员+站务发送通知。默认情况下，收件地址将位于密送列表中，但你可以通过设置 `smtp-disclose-recipients` 更改此行为。
- 当举报被管理员关闭时，向举报创建者（若为本站用户）发送邮件。

## HTML 与纯文本

默认情况下，邮件以纯文本形式发送。目前，没有选项可以发送 html 格式的邮件，但如果有足够的需求，这可能会在以后添加。

## 自定义

如果你愿意，可以自定义用于生成邮件的模板。请按照 `web/templates` 中的示例进行操作。
