# Copyright 2023 The gRPC Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
This file is generated by generate_dockerimage_current_versions_bzl.sh
It makes the info from testing docker image *.current_version files
accessible to bazel builds.
"""

DOCKERIMAGE_CURRENT_VERSIONS = {
    "third_party/rake-compiler-dock/rake_aarch64-linux-gnu.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_aarch64-linux-gnu@sha256:9d81abde3a25e720bfb28c978df8eb793adaa3bb4e145d507967d72fc6510c71",
    "third_party/rake-compiler-dock/rake_aarch64-linux-musl.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_aarch64-linux-musl@sha256:c01823e4e1323fe7a32547292a448f32ec5b90c286775a8c063dcefee8503d31",
    "third_party/rake-compiler-dock/rake_arm64-darwin.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_arm64-darwin@sha256:28a88cb72472608f716aa60e7f1f22182c60809cc4e96c035c0e38e708e4e9be",
    "third_party/rake-compiler-dock/rake_x64-mingw-ucrt.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_x64-mingw-ucrt@sha256:d6d34c393a66a3b36bb62364b149bd6e84f342258b586bfd0301972d9bdda34c",
    "third_party/rake-compiler-dock/rake_x86-linux-gnu.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_x86-linux-gnu@sha256:3c39ea31f79c07c78aa691d859ffd1b72496835a95db7c1b8ce8c8028c6e5418",
    "third_party/rake-compiler-dock/rake_x86-linux-musl.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_x86-linux-musl@sha256:3f67eac1e1da927bfe066fe2558389da49bf02b497192ebd061d53b15e9484ac",
    "third_party/rake-compiler-dock/rake_x86-mingw32.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_x86-mingw32@sha256:2be5e0decccc23f8b7ac1b2d5edd21ea814868dcfe08b955749167fd22f99a20",
    "third_party/rake-compiler-dock/rake_x86_64-darwin.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_x86_64-darwin@sha256:e01c02a18130b9669da57bb28b3f6c30458511e20eae5821b3899a41e09f394a",
    "third_party/rake-compiler-dock/rake_x86_64-linux-gnu.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_x86_64-linux-gnu@sha256:3687dc591d8b92d3e0c3066d1e93b1e82ced3f5f0d92b5859eb9bca283dcf4bf",
    "third_party/rake-compiler-dock/rake_x86_64-linux-musl.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rake_x86_64-linux-musl@sha256:435aa8daea38c6608e533c1c7b202fe35d4327e5293ed840f644cfb21b2e61ed",
    "tools/dockerfile/distribtest/cpp_debian11_aarch64_cross_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cpp_debian11_aarch64_cross_x64@sha256:5de93f45dee2263d45f8934a17bf820847145f69c49338fb491a9690cf346994",
    "tools/dockerfile/distribtest/cpp_debian11_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cpp_debian11_x64@sha256:5cf417d8fc575685922959292b3eae91844c2480040b0c605485eae009eb67db",
    "tools/dockerfile/distribtest/csharp_alpine_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/csharp_alpine_x64@sha256:17d9f984e34b978114e5835224f7ad9c9ac59b2a101787efb0f4d265efd592e0",
    "tools/dockerfile/distribtest/csharp_debian11_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/csharp_debian11_x64@sha256:e79a68c91a6ba8a2cb512671c96565f67b9e6efefb05c75eefd3b57c51f4d705",
    "tools/dockerfile/distribtest/csharp_dotnet31_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/csharp_dotnet31_x64@sha256:1fb798ba335d0f010ea988723e375f5b8766a8107a814c39c7b3d89558c15e98",
    "tools/dockerfile/distribtest/csharp_dotnet5_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/csharp_dotnet5_x64@sha256:9234c28596f48f82628ca58437a20c63148cd818a10bd15f7b85490bb432d923",
    "tools/dockerfile/distribtest/csharp_ubuntu2204_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/csharp_ubuntu2204_x64@sha256:2ce824e9dcd7b3eb6a6bf004298d33c9720fd362939b08cb7cdd6808d7ecf807",
    "tools/dockerfile/distribtest/php8_debian12_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/php8_debian12_x64@sha256:f81b0702bd28823f12402cfabc8eaecebd0fd2b58a28ba93ef40f9832b25196f",
    "tools/dockerfile/distribtest/python_alpine_aarch64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_alpine_aarch64@sha256:ad38e1307cef00d8e99b65274f98af3645203caf6ab34226505509d85ac48819",
    "tools/dockerfile/distribtest/python_alpine_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_alpine_x64@sha256:7b5ec7e008baa5d3f83daeca7fee53fee8f5f03d77df8c58104626eb4c2a239b",
    "tools/dockerfile/distribtest/python_arch_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_arch_x64@sha256:cc4c9bafe3bfee407bb1bec22d8c62c1a29db718a3926b9073128d311067f7bb",
    "tools/dockerfile/distribtest/python_bullseye_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_bullseye_x64@sha256:9d4281e3c006dc9092417aef8916e5e5a2e4893df21ab7482fb6902025b96eb8",
    "tools/dockerfile/distribtest/python_bullseye_x86.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_bullseye_x86@sha256:6b0a6c4418e37df9ce3ed664afdf7197093739db9f4f9f05799f55b6ab7e166c",
    "tools/dockerfile/distribtest/python_dev_alpine3.18_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_dev_alpine3.18_x64@sha256:85ca50caccad9f37564989c23566f1daec4b9164d9f03095c90d18514f1354c0",
    "tools/dockerfile/distribtest/python_dev_arch_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_dev_arch_x64@sha256:b9cf804646fc6ea424f86e5d071372e73b8d1fc8629dece6b9b81237d4228d30",
    "tools/dockerfile/distribtest/python_dev_bullseye_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_dev_bullseye_x64@sha256:2c1da4cad1a5c5f825d66881229ec8a92d99941174b7a320d97f5e01cfc3ce8a",
    "tools/dockerfile/distribtest/python_dev_bullseye_x86.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_dev_bullseye_x86@sha256:6a781b5064658d63e8eb11cd12f71f0c90b7af2f4e7eb41ccfb07897278349a1",
    "tools/dockerfile/distribtest/python_dev_fedora40_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_dev_fedora40_x64@sha256:b364875e084d1d63d596086ff744895addc6bb6f299864f52883afd2591a19bd",
    "tools/dockerfile/distribtest/python_dev_ubuntu2204_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_dev_ubuntu2204_x64@sha256:46065078c896d6a0df383015a809048ff996791b327821bbc78d79835b39b27f",
    "tools/dockerfile/distribtest/python_dev_ubuntu2404_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_dev_ubuntu2404_x64@sha256:0cabe4974ad439dd1fa9fd5225eb53607c2a605cb25183514252e7154df62018",
    "tools/dockerfile/distribtest/python_fedora40_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_fedora40_x64@sha256:21a6a88eeccb14fcc73daa099899500f9270ca85a0bece3769411b24bd0858ee",
    "tools/dockerfile/distribtest/python_opensuse_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_opensuse_x64@sha256:c06efa1964d268c60eeb14d82e26bc6691f22a4888bbfe921b1e9df4519821af",
    "tools/dockerfile/distribtest/python_python39_buster_aarch64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_python39_buster_aarch64@sha256:081affeaa7c2b4a6f9c2816cfc2dc3ff9704c12dc1c7b16e360ef7bfdfeac1d2",
    "tools/dockerfile/distribtest/python_ubuntu2204_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_ubuntu2204_x64@sha256:0b8c6f54f40c4a9f20bad558841c6f43ad75059ba9c63e4a1dc918c6be0d35ee",
    "tools/dockerfile/distribtest/python_ubuntu2404_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_ubuntu2404_x64@sha256:59bbb8ecbe653e0610343f46615b94a27292f843b65a7fe4acfc36940e09a7b1",
    "tools/dockerfile/distribtest/ruby_alpine_x64_ruby_3_1.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_alpine_x64_ruby_3_1@sha256:b34f276da64eb3ced596b7a6979910e6f592006c40b2a06b23152ac180df073f",
    "tools/dockerfile/distribtest/ruby_alpine_x64_ruby_3_2.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_alpine_x64_ruby_3_2@sha256:31e84462d53243bb93a1453e0873ee620832463f88867847249eff32d7a8bba5",
    "tools/dockerfile/distribtest/ruby_alpine_x64_ruby_3_3.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_alpine_x64_ruby_3_3@sha256:0e0c8c849ada2ad9e078a81d5ce2c054134a519fc4e01ff009922d378ed5e90f",
    "tools/dockerfile/distribtest/ruby_alpine_x64_ruby_3_4.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_alpine_x64_ruby_3_4@sha256:76206c4329f67c354ecdcfed4b785c9d1dd420fd32b2170d4f93dd7e076701fc",
    "tools/dockerfile/distribtest/ruby_debian11_x64_ruby_3_1.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_debian11_x64_ruby_3_1@sha256:11347339e57c04866585511dd2de87df483179395869b4754a09724a54c1c77e",
    "tools/dockerfile/distribtest/ruby_debian11_x64_ruby_3_2.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_debian11_x64_ruby_3_2@sha256:c4eb679928e92f660fc8e8ebfd8c76a5d6b6f22e5b6e875c52fa42b166ab5c55",
    "tools/dockerfile/distribtest/ruby_debian11_x64_ruby_3_3.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_debian11_x64_ruby_3_3@sha256:7def7f623814dd9439ccb33ff0400bae9763bee7b9334c6542884ff240070c83",
    "tools/dockerfile/distribtest/ruby_debian11_x64_ruby_3_4.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_debian11_x64_ruby_3_4@sha256:208fadc38e1e279fae7e338841ce147088150d0f141d2961f5527bd6ea09b711",
    "tools/dockerfile/distribtest/ruby_ubuntu2204_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_ubuntu2204_x64@sha256:7970ff2b6cc22816248e0b2b44ae7e90c5a0f5a830b79ec1a56093df3ee8e235",
    "tools/dockerfile/distribtest/ruby_ubuntu2404_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_ubuntu2404_x64@sha256:f777c0c37fe3947346bc72e267aa28c168001af96b5f0b46cf347df3ce09f17d",
    "tools/dockerfile/grpc_artifact_manylinux2014_aarch64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_manylinux2014_aarch64@sha256:9d6f150da39d1b16269d601010876d3f8a2138121db289abad40fdaf7fad287b",
    "tools/dockerfile/grpc_artifact_manylinux2014_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_manylinux2014_x64@sha256:0f1e61a35200df7ddbe8626e353b634ab831ab556860ff85d55b650617c5385b",
    "tools/dockerfile/grpc_artifact_manylinux2014_x86.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_manylinux2014_x86@sha256:b8d3242fc9402ed55cf2fe20d13be7491141e793bc76c12e6452c8cb072624cf",
    "tools/dockerfile/grpc_artifact_python_linux_armv7.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_python_linux_armv7@sha256:bca9679ec579aac202f57ce59c3390618052385ca9ed2b125541b37b604cc8b9",
    "tools/dockerfile/grpc_artifact_python_manylinux2014_aarch64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_python_manylinux2014_aarch64@sha256:81794e9c482771722ac7596e2e41d0c20e151365510149b290164cd579e4504c",
    "tools/dockerfile/grpc_artifact_python_manylinux2014_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_python_manylinux2014_x64@sha256:399ece2f021854bcd3b1deea6639fd5d1038f50e7e646c4c646b58135917f977",
    "tools/dockerfile/grpc_artifact_python_manylinux2014_x86.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_python_manylinux2014_x86@sha256:82accaf8514e324d88086da2b54f0f7a048bdf5b969c11ca4e506f5c7f56679e",
    "tools/dockerfile/grpc_artifact_python_musllinux_1_2_aarch64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_python_musllinux_1_2_aarch64@sha256:60cb5603ae8c075e06c7f1a24dd1caf4467c836920f4f2b4f9b614340f0b651f",
    "tools/dockerfile/grpc_artifact_python_musllinux_1_2_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_python_musllinux_1_2_x64@sha256:341e2299e4ccf6d018a4bcd03c93d429a07372b521615a372d29197de360fd6c",
    "tools/dockerfile/grpc_artifact_python_musllinux_1_2_x86.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_artifact_python_musllinux_1_2_x86@sha256:98c512247de84d255ec70ccb8eeffd163f938523a66edd7a8f3eb50b0ec000a1",
    "tools/dockerfile/interoptest/grpc_interop_aspnetcore.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_aspnetcore@sha256:aedf6ba703f9e73bb072fedb6805c96c4db255e6917d22353383d287455f4e14",
    "tools/dockerfile/interoptest/grpc_interop_cxx.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_cxx@sha256:3e6016519cc5d5b5fcd67eb570d6d56da739164dbc7604f55d914ef7546fdad5",
    "tools/dockerfile/interoptest/grpc_interop_dart.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_dart@sha256:0a9b335b3f26083f52037717182a09e54675bbaa5e7aa813b2b3217cbcf53a65",
    "tools/dockerfile/interoptest/grpc_interop_go.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_go@sha256:61a86fb789e99b9eec2782638124fd6ed40de3f1d4b7b243cc92a437a23f2f7f",
    "tools/dockerfile/interoptest/grpc_interop_go1.11.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_go1.11@sha256:597b7577008299de519b3e33dd31480b210fb5d6372f5c91a67b416e1e87ebee",
    "tools/dockerfile/interoptest/grpc_interop_go1.16.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_go1.16@sha256:eade2ade2831197fe2e894d537ca4ddbdcd6ae5eb7b6efb00ae7f4b8b92efb48",
    "tools/dockerfile/interoptest/grpc_interop_go1.19.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_go1.19@sha256:fb4c87752e6b1eafa6fb57b5a8d7f7de813d3207ebe378c2d5685208739a9f7f",
    "tools/dockerfile/interoptest/grpc_interop_go1.8.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_go1.8@sha256:7830a301b37539252c592b9cd7fa30a6142d0afc717a05fc8d2b82c74fb45efe",
    "tools/dockerfile/interoptest/grpc_interop_go1.x.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_go1.x@sha256:61a86fb789e99b9eec2782638124fd6ed40de3f1d4b7b243cc92a437a23f2f7f",
    "tools/dockerfile/interoptest/grpc_interop_http2.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_http2@sha256:f99b4cb1d1afdc9ba19cf81f9ebe33cc90e966af17a699aaa4890ef13914c80b",
    "tools/dockerfile/interoptest/grpc_interop_java.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_java@sha256:91ff5d28c2de63eaf6ee121429e7a7b269c83110833a5e2a9a46a2954dcbfb4a",
    "tools/dockerfile/interoptest/grpc_interop_node.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_node@sha256:c30e8af219aae32f5c682c1027dfceaa489ea412613b151cc351e4c6daa3bb69",
    "tools/dockerfile/interoptest/grpc_interop_nodepurejs.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_nodepurejs@sha256:b990c14434ed85caede949170c2f917085166874de34410be2452b9447e42371",
    "tools/dockerfile/interoptest/grpc_interop_php7.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_php7@sha256:3377c55c0a697f20e8391c49bffea5396cc6f7cffa86671ea1efbc32191f6934",
    "tools/dockerfile/interoptest/grpc_interop_python.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_python@sha256:ca2dfcb62ae1d4011b0c5398a5ffaac89fd7e694d6accd240e0d1399eb93786e",
    "tools/dockerfile/interoptest/grpc_interop_pythonasyncio.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_pythonasyncio@sha256:e3fcb433d1600597109bff57a353c2c0935143788b011a75a7bf2e6b69c70872",
    "tools/dockerfile/interoptest/grpc_interop_ruby.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/grpc_interop_ruby@sha256:1b4160c0bf66ba79bc423e4bb75e2e8945162287ed73895b51d5cd0c0c522616",
    "tools/dockerfile/interoptest/lb_interop_fake_servers.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/lb_interop_fake_servers@sha256:ba4c19a2b8e4af7a2d112ef65e6475fb44394cadb2fe17d6f0d434c5b1849bed",
    "tools/dockerfile/test/android_ndk.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/android_ndk@sha256:2f0b941ddf7c0eb913a9c81df27e28c3c227cdde00654b0076b49aff51cc0c02",
    "tools/dockerfile/test/bazel.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/bazel@sha256:814f79b30656de4627c88e53bbf1c457037748971055702a74745a5828de12fa",
    "tools/dockerfile/test/bazel_arm64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/bazel_arm64@sha256:a5b84a1c6845fb6a9f2816a36d305b56dba46a6db56cb1d537aadd989e71b773",
    "tools/dockerfile/test/csharp_debian11_arm64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/csharp_debian11_arm64@sha256:53ce3ccdc74b8c264c7706f4e98830cdc1cf79c4460ed98db6122da6fc26f119",
    "tools/dockerfile/test/csharp_debian11_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/csharp_debian11_x64@sha256:021b6a99ea13597fbe09cfe129774f1e2b9d7d3ab21eabd5ff6ce0aec1f6f88b",
    "tools/dockerfile/test/cxx_alpine_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_alpine_x64@sha256:b5323a506187c5d280b2251c0b1fc7c2cf24958226e8a92b7f7834d7ebcf2293",
    "tools/dockerfile/test/cxx_clang_11_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_clang_11_x64@sha256:875f9035aaa7675014155fef14512263869c9e9cf9c83efbc3225770e9e0d9f5",
    "tools/dockerfile/test/cxx_clang_19_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_clang_19_x64@sha256:9ac2450171225829309a24827b8aadecb2e4435badf959094c2e554a44014e00",
    "tools/dockerfile/test/cxx_debian11_openssl102_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_debian11_openssl102_x64@sha256:594e649a690393e558a8b5b5b59a5da4aa32b5c298264c647676cb8796d32d44",
    "tools/dockerfile/test/cxx_debian11_openssl111_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_debian11_openssl111_x64@sha256:411066788199dc645aebc6bb444d5604347e46d3df6becb01399e9227f866ba5",
    "tools/dockerfile/test/cxx_debian11_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_debian11_x64@sha256:6b913694d832053ea61086cb24e9720449516a80672e997b87b0bc46ae0b1ec4",
    "tools/dockerfile/test/cxx_debian11_x86.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_debian11_x86@sha256:14127eef4583f61fe9e53e962d1e1e8f2de5d2be3942980c9983df335e9297fa",
    "tools/dockerfile/test/cxx_debian12_openssl309_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_debian12_openssl309_x64@sha256:b1124f70491059b7859787bbea64cbaa812bdeadd9a803509097c54240ac1c59",
    "tools/dockerfile/test/cxx_gcc_14_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_gcc_14_x64@sha256:eff0a2f6efd68c061d752b15b578bad127f1ad644b8dd1d7da9bc94d532afe36",
    "tools/dockerfile/test/cxx_gcc_7_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_gcc_7_x64@sha256:7e2eff34ce0bcd05e39fa5b69fc4cd6e8fbf5e5b78d95ee7949e0df340d276da",
    "tools/dockerfile/test/cxx_gcc_8_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/cxx_gcc_8_x64@sha256:3d4bcff016858a4637ae34d89088e463c16b6e8047c951d909d90ee939c7ea3a",
    "tools/dockerfile/test/php8_debian12_arm64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/php8_debian12_arm64@sha256:b6111d2e6f7addf605322ffafd342f4c72e40e0a6ea4f437683e09d0b921f57f",
    "tools/dockerfile/test/php8_debian12_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/php8_debian12_x64@sha256:c39a84e5b275c9cf9ab7af558460e1edff62ae426bc8d31ef85cd4c21cf8a923",
    "tools/dockerfile/test/php8_zts_debian12_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/php8_zts_debian12_x64@sha256:3497f75483612a447d9b460ac94443b2be0b467232cdd7b8cef0965f7c3d688c",
    "tools/dockerfile/test/python_alpine_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_alpine_x64@sha256:54e011d920390974ff446f4e83b9f5436d56eb228c7010360cf32ae34c799a33",
    "tools/dockerfile/test/python_debian11_default_arm64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_debian11_default_arm64@sha256:005bce89f0d7757f30850ca97688cb10baf72f7a3b194383f3ea9aeebb8ff90f",
    "tools/dockerfile/test/python_debian11_default_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/python_debian11_default_x64@sha256:50ed546b398e48a1dbb8479f1e30147c082e4d88b0ccfb325581137eed99a132",
    "tools/dockerfile/test/rbe_debian11_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rbe_debian11_x64@sha256:5db86f5086ddf76e8ae28a131aac0af32465be9bf69246514e765574b51bcb00",
    "tools/dockerfile/test/rbe_ubuntu2004.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/rbe_ubuntu2004@sha256:bce8453713efcff3f4effe0d7bb0ef743ec4e772c63bac637c38d0af0e1a9ad9",
    "tools/dockerfile/test/ruby_debian11_arm64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_debian11_arm64@sha256:8b1c4a9d7802f843356104b7bda4809403462b12174fe87844549a9b23cc16fc",
    "tools/dockerfile/test/ruby_debian11_x64.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/ruby_debian11_x64@sha256:ef468a9965ea594f7146b308e931ca96fd723a8ca7d4d80687b1761805d5e5fe",
    "tools/dockerfile/test/sanity.current_version": "docker://us-docker.pkg.dev/grpc-testing/testing-images-public/sanity@sha256:afea9ca2129607dfaf03b6f2b58e5998a1bc18e094c8a4816cba462ddb9c2295",
}
