/* Single-character transliterations (based on Unidecode) */
/*
import sys
import itertools
import unicodedata
from unidecode import unidecode

unicode_ranges = itertools.chain(
    range(0x0020, 0x007F+1),    # Basic Latin
    range(0x00A0, 0x00FF+1),    # Latin-1 Supplement
    range(0x0100, 0x017F+1),    # Latin Extended-A
    range(0x0180, 0x024F+1),    # Latin Extended-B
    range(0x0400, 0x04FF+1),    # Cyrillic
    range(0x0500, 0x052F+1),    # Cyrillic Supplementary
    range(0x2000, 0x206F+1),    # General Punctuation
)

def char_literal(c):
    s = chr(c)
    s = s.replace('\\', '\\\\')
    s = s.replace('\n', '\\n')
    s = s.replace('\'', '\\\'')
    return f"'{s}'"

sys.stdout = open('unicode_translit.h', 'w')
print('/%s Single-character transliterations (based on Unidecode) %s/' % ('*', '*')) # shenanigans to keep the Python code C comment-friendly
with open(__file__, 'r') as source:
    print('/%s\n%s\n%s/' % ('*', source.read(), '*'))
print("static const struct { uint16_t code; char remap[2]; } unicode_translit_src[] =\n{")
for codepoint in unicode_ranges:
    if 0xd800 <= codepoint <= 0xdfff:
        continue
    srcstr = chr(codepoint)
    src = srcstr.encode()
    translit = unidecode(srcstr).encode()
    if src != translit and 0 < len(translit) <= min(2, len(src)):
        print('\t{0x%04X, {%s}}, // %s' % (codepoint, ', '.join([char_literal(c) for c in translit]), unicodedata.name(srcstr)))
print("};")
*/
static const struct { uint16_t code; char remap[2]; } unicode_translit_src[] =
{
	{0x00A0, {' '}}, // NO-BREAK SPACE
	{0x00A1, {'!'}}, // INVERTED EXCLAMATION MARK
	{0x00A2, {'C', '/'}}, // CENT SIGN
	{0x00A3, {'P', 'S'}}, // POUND SIGN
	{0x00A4, {'$', '?'}}, // CURRENCY SIGN
	{0x00A5, {'Y', '='}}, // YEN SIGN
	{0x00A6, {'|'}}, // BROKEN BAR
	{0x00A7, {'S', 'S'}}, // SECTION SIGN
	{0x00A8, {'"'}}, // DIAERESIS
	{0x00AA, {'a'}}, // FEMININE ORDINAL INDICATOR
	{0x00AB, {'<', '<'}}, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00AC, {'!'}}, // NOT SIGN
	{0x00AF, {'-'}}, // MACRON
	{0x00B1, {'+', '-'}}, // PLUS-MINUS SIGN
	{0x00B2, {'2'}}, // SUPERSCRIPT TWO
	{0x00B3, {'3'}}, // SUPERSCRIPT THREE
	{0x00B4, {'\''}}, // ACUTE ACCENT
	{0x00B5, {'u'}}, // MICRO SIGN
	{0x00B6, {'P'}}, // PILCROW SIGN
	{0x00B7, {'*'}}, // MIDDLE DOT
	{0x00B8, {','}}, // CEDILLA
	{0x00B9, {'1'}}, // SUPERSCRIPT ONE
	{0x00BA, {'o'}}, // MASCULINE ORDINAL INDICATOR
	{0x00BB, {'>', '>'}}, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00BF, {'?'}}, // INVERTED QUESTION MARK
	{0x00C0, {'A'}}, // LATIN CAPITAL LETTER A WITH GRAVE
	{0x00C1, {'A'}}, // LATIN CAPITAL LETTER A WITH ACUTE
	{0x00C2, {'A'}}, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
	{0x00C3, {'A'}}, // LATIN CAPITAL LETTER A WITH TILDE
	{0x00C4, {'A'}}, // LATIN CAPITAL LETTER A WITH DIAERESIS
	{0x00C5, {'A'}}, // LATIN CAPITAL LETTER A WITH RING ABOVE
	{0x00C6, {'A', 'E'}}, // LATIN CAPITAL LETTER AE
	{0x00C7, {'C'}}, // LATIN CAPITAL LETTER C WITH CEDILLA
	{0x00C8, {'E'}}, // LATIN CAPITAL LETTER E WITH GRAVE
	{0x00C9, {'E'}}, // LATIN CAPITAL LETTER E WITH ACUTE
	{0x00CA, {'E'}}, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	{0x00CB, {'E'}}, // LATIN CAPITAL LETTER E WITH DIAERESIS
	{0x00CC, {'I'}}, // LATIN CAPITAL LETTER I WITH GRAVE
	{0x00CD, {'I'}}, // LATIN CAPITAL LETTER I WITH ACUTE
	{0x00CE, {'I'}}, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
	{0x00CF, {'I'}}, // LATIN CAPITAL LETTER I WITH DIAERESIS
	{0x00D0, {'D'}}, // LATIN CAPITAL LETTER ETH
	{0x00D1, {'N'}}, // LATIN CAPITAL LETTER N WITH TILDE
	{0x00D2, {'O'}}, // LATIN CAPITAL LETTER O WITH GRAVE
	{0x00D3, {'O'}}, // LATIN CAPITAL LETTER O WITH ACUTE
	{0x00D4, {'O'}}, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	{0x00D5, {'O'}}, // LATIN CAPITAL LETTER O WITH TILDE
	{0x00D6, {'O'}}, // LATIN CAPITAL LETTER O WITH DIAERESIS
	{0x00D7, {'x'}}, // MULTIPLICATION SIGN
	{0x00D8, {'O'}}, // LATIN CAPITAL LETTER O WITH STROKE
	{0x00D9, {'U'}}, // LATIN CAPITAL LETTER U WITH GRAVE
	{0x00DA, {'U'}}, // LATIN CAPITAL LETTER U WITH ACUTE
	{0x00DB, {'U'}}, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
	{0x00DC, {'U'}}, // LATIN CAPITAL LETTER U WITH DIAERESIS
	{0x00DD, {'Y'}}, // LATIN CAPITAL LETTER Y WITH ACUTE
	{0x00DE, {'T', 'h'}}, // LATIN CAPITAL LETTER THORN
	{0x00DF, {'s', 's'}}, // LATIN SMALL LETTER SHARP S
	{0x00E0, {'a'}}, // LATIN SMALL LETTER A WITH GRAVE
	{0x00E1, {'a'}}, // LATIN SMALL LETTER A WITH ACUTE
	{0x00E2, {'a'}}, // LATIN SMALL LETTER A WITH CIRCUMFLEX
	{0x00E3, {'a'}}, // LATIN SMALL LETTER A WITH TILDE
	{0x00E4, {'a'}}, // LATIN SMALL LETTER A WITH DIAERESIS
	{0x00E5, {'a'}}, // LATIN SMALL LETTER A WITH RING ABOVE
	{0x00E6, {'a', 'e'}}, // LATIN SMALL LETTER AE
	{0x00E7, {'c'}}, // LATIN SMALL LETTER C WITH CEDILLA
	{0x00E8, {'e'}}, // LATIN SMALL LETTER E WITH GRAVE
	{0x00E9, {'e'}}, // LATIN SMALL LETTER E WITH ACUTE
	{0x00EA, {'e'}}, // LATIN SMALL LETTER E WITH CIRCUMFLEX
	{0x00EB, {'e'}}, // LATIN SMALL LETTER E WITH DIAERESIS
	{0x00EC, {'i'}}, // LATIN SMALL LETTER I WITH GRAVE
	{0x00ED, {'i'}}, // LATIN SMALL LETTER I WITH ACUTE
	{0x00EE, {'i'}}, // LATIN SMALL LETTER I WITH CIRCUMFLEX
	{0x00EF, {'i'}}, // LATIN SMALL LETTER I WITH DIAERESIS
	{0x00F0, {'d'}}, // LATIN SMALL LETTER ETH
	{0x00F1, {'n'}}, // LATIN SMALL LETTER N WITH TILDE
	{0x00F2, {'o'}}, // LATIN SMALL LETTER O WITH GRAVE
	{0x00F3, {'o'}}, // LATIN SMALL LETTER O WITH ACUTE
	{0x00F4, {'o'}}, // LATIN SMALL LETTER O WITH CIRCUMFLEX
	{0x00F5, {'o'}}, // LATIN SMALL LETTER O WITH TILDE
	{0x00F6, {'o'}}, // LATIN SMALL LETTER O WITH DIAERESIS
	{0x00F7, {'/'}}, // DIVISION SIGN
	{0x00F8, {'o'}}, // LATIN SMALL LETTER O WITH STROKE
	{0x00F9, {'u'}}, // LATIN SMALL LETTER U WITH GRAVE
	{0x00FA, {'u'}}, // LATIN SMALL LETTER U WITH ACUTE
	{0x00FB, {'u'}}, // LATIN SMALL LETTER U WITH CIRCUMFLEX
	{0x00FC, {'u'}}, // LATIN SMALL LETTER U WITH DIAERESIS
	{0x00FD, {'y'}}, // LATIN SMALL LETTER Y WITH ACUTE
	{0x00FE, {'t', 'h'}}, // LATIN SMALL LETTER THORN
	{0x00FF, {'y'}}, // LATIN SMALL LETTER Y WITH DIAERESIS
	{0x0100, {'A'}}, // LATIN CAPITAL LETTER A WITH MACRON
	{0x0101, {'a'}}, // LATIN SMALL LETTER A WITH MACRON
	{0x0102, {'A'}}, // LATIN CAPITAL LETTER A WITH BREVE
	{0x0103, {'a'}}, // LATIN SMALL LETTER A WITH BREVE
	{0x0104, {'A'}}, // LATIN CAPITAL LETTER A WITH OGONEK
	{0x0105, {'a'}}, // LATIN SMALL LETTER A WITH OGONEK
	{0x0106, {'C'}}, // LATIN CAPITAL LETTER C WITH ACUTE
	{0x0107, {'c'}}, // LATIN SMALL LETTER C WITH ACUTE
	{0x0108, {'C'}}, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
	{0x0109, {'c'}}, // LATIN SMALL LETTER C WITH CIRCUMFLEX
	{0x010A, {'C'}}, // LATIN CAPITAL LETTER C WITH DOT ABOVE
	{0x010B, {'c'}}, // LATIN SMALL LETTER C WITH DOT ABOVE
	{0x010C, {'C'}}, // LATIN CAPITAL LETTER C WITH CARON
	{0x010D, {'c'}}, // LATIN SMALL LETTER C WITH CARON
	{0x010E, {'D'}}, // LATIN CAPITAL LETTER D WITH CARON
	{0x010F, {'d'}}, // LATIN SMALL LETTER D WITH CARON
	{0x0110, {'D'}}, // LATIN CAPITAL LETTER D WITH STROKE
	{0x0111, {'d'}}, // LATIN SMALL LETTER D WITH STROKE
	{0x0112, {'E'}}, // LATIN CAPITAL LETTER E WITH MACRON
	{0x0113, {'e'}}, // LATIN SMALL LETTER E WITH MACRON
	{0x0114, {'E'}}, // LATIN CAPITAL LETTER E WITH BREVE
	{0x0115, {'e'}}, // LATIN SMALL LETTER E WITH BREVE
	{0x0116, {'E'}}, // LATIN CAPITAL LETTER E WITH DOT ABOVE
	{0x0117, {'e'}}, // LATIN SMALL LETTER E WITH DOT ABOVE
	{0x0118, {'E'}}, // LATIN CAPITAL LETTER E WITH OGONEK
	{0x0119, {'e'}}, // LATIN SMALL LETTER E WITH OGONEK
	{0x011A, {'E'}}, // LATIN CAPITAL LETTER E WITH CARON
	{0x011B, {'e'}}, // LATIN SMALL LETTER E WITH CARON
	{0x011C, {'G'}}, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
	{0x011D, {'g'}}, // LATIN SMALL LETTER G WITH CIRCUMFLEX
	{0x011E, {'G'}}, // LATIN CAPITAL LETTER G WITH BREVE
	{0x011F, {'g'}}, // LATIN SMALL LETTER G WITH BREVE
	{0x0120, {'G'}}, // LATIN CAPITAL LETTER G WITH DOT ABOVE
	{0x0121, {'g'}}, // LATIN SMALL LETTER G WITH DOT ABOVE
	{0x0122, {'G'}}, // LATIN CAPITAL LETTER G WITH CEDILLA
	{0x0123, {'g'}}, // LATIN SMALL LETTER G WITH CEDILLA
	{0x0124, {'H'}}, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
	{0x0125, {'h'}}, // LATIN SMALL LETTER H WITH CIRCUMFLEX
	{0x0126, {'H'}}, // LATIN CAPITAL LETTER H WITH STROKE
	{0x0127, {'h'}}, // LATIN SMALL LETTER H WITH STROKE
	{0x0128, {'I'}}, // LATIN CAPITAL LETTER I WITH TILDE
	{0x0129, {'i'}}, // LATIN SMALL LETTER I WITH TILDE
	{0x012A, {'I'}}, // LATIN CAPITAL LETTER I WITH MACRON
	{0x012B, {'i'}}, // LATIN SMALL LETTER I WITH MACRON
	{0x012C, {'I'}}, // LATIN CAPITAL LETTER I WITH BREVE
	{0x012D, {'i'}}, // LATIN SMALL LETTER I WITH BREVE
	{0x012E, {'I'}}, // LATIN CAPITAL LETTER I WITH OGONEK
	{0x012F, {'i'}}, // LATIN SMALL LETTER I WITH OGONEK
	{0x0130, {'I'}}, // LATIN CAPITAL LETTER I WITH DOT ABOVE
	{0x0131, {'i'}}, // LATIN SMALL LETTER DOTLESS I
	{0x0132, {'I', 'J'}}, // LATIN CAPITAL LIGATURE IJ
	{0x0133, {'i', 'j'}}, // LATIN SMALL LIGATURE IJ
	{0x0134, {'J'}}, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
	{0x0135, {'j'}}, // LATIN SMALL LETTER J WITH CIRCUMFLEX
	{0x0136, {'K'}}, // LATIN CAPITAL LETTER K WITH CEDILLA
	{0x0137, {'k'}}, // LATIN SMALL LETTER K WITH CEDILLA
	{0x0138, {'k'}}, // LATIN SMALL LETTER KRA
	{0x0139, {'L'}}, // LATIN CAPITAL LETTER L WITH ACUTE
	{0x013A, {'l'}}, // LATIN SMALL LETTER L WITH ACUTE
	{0x013B, {'L'}}, // LATIN CAPITAL LETTER L WITH CEDILLA
	{0x013C, {'l'}}, // LATIN SMALL LETTER L WITH CEDILLA
	{0x013D, {'L'}}, // LATIN CAPITAL LETTER L WITH CARON
	{0x013E, {'l'}}, // LATIN SMALL LETTER L WITH CARON
	{0x013F, {'L'}}, // LATIN CAPITAL LETTER L WITH MIDDLE DOT
	{0x0140, {'l'}}, // LATIN SMALL LETTER L WITH MIDDLE DOT
	{0x0141, {'L'}}, // LATIN CAPITAL LETTER L WITH STROKE
	{0x0142, {'l'}}, // LATIN SMALL LETTER L WITH STROKE
	{0x0143, {'N'}}, // LATIN CAPITAL LETTER N WITH ACUTE
	{0x0144, {'n'}}, // LATIN SMALL LETTER N WITH ACUTE
	{0x0145, {'N'}}, // LATIN CAPITAL LETTER N WITH CEDILLA
	{0x0146, {'n'}}, // LATIN SMALL LETTER N WITH CEDILLA
	{0x0147, {'N'}}, // LATIN CAPITAL LETTER N WITH CARON
	{0x0148, {'n'}}, // LATIN SMALL LETTER N WITH CARON
	{0x0149, {'\'', 'n'}}, // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
	{0x014A, {'n', 'g'}}, // LATIN CAPITAL LETTER ENG
	{0x014B, {'N', 'G'}}, // LATIN SMALL LETTER ENG
	{0x014C, {'O'}}, // LATIN CAPITAL LETTER O WITH MACRON
	{0x014D, {'o'}}, // LATIN SMALL LETTER O WITH MACRON
	{0x014E, {'O'}}, // LATIN CAPITAL LETTER O WITH BREVE
	{0x014F, {'o'}}, // LATIN SMALL LETTER O WITH BREVE
	{0x0150, {'O'}}, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
	{0x0151, {'o'}}, // LATIN SMALL LETTER O WITH DOUBLE ACUTE
	{0x0152, {'O', 'E'}}, // LATIN CAPITAL LIGATURE OE
	{0x0153, {'o', 'e'}}, // LATIN SMALL LIGATURE OE
	{0x0154, {'R'}}, // LATIN CAPITAL LETTER R WITH ACUTE
	{0x0155, {'r'}}, // LATIN SMALL LETTER R WITH ACUTE
	{0x0156, {'R'}}, // LATIN CAPITAL LETTER R WITH CEDILLA
	{0x0157, {'r'}}, // LATIN SMALL LETTER R WITH CEDILLA
	{0x0158, {'R'}}, // LATIN CAPITAL LETTER R WITH CARON
	{0x0159, {'r'}}, // LATIN SMALL LETTER R WITH CARON
	{0x015A, {'S'}}, // LATIN CAPITAL LETTER S WITH ACUTE
	{0x015B, {'s'}}, // LATIN SMALL LETTER S WITH ACUTE
	{0x015C, {'S'}}, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
	{0x015D, {'s'}}, // LATIN SMALL LETTER S WITH CIRCUMFLEX
	{0x015E, {'S'}}, // LATIN CAPITAL LETTER S WITH CEDILLA
	{0x015F, {'s'}}, // LATIN SMALL LETTER S WITH CEDILLA
	{0x0160, {'S'}}, // LATIN CAPITAL LETTER S WITH CARON
	{0x0161, {'s'}}, // LATIN SMALL LETTER S WITH CARON
	{0x0162, {'T'}}, // LATIN CAPITAL LETTER T WITH CEDILLA
	{0x0163, {'t'}}, // LATIN SMALL LETTER T WITH CEDILLA
	{0x0164, {'T'}}, // LATIN CAPITAL LETTER T WITH CARON
	{0x0165, {'t'}}, // LATIN SMALL LETTER T WITH CARON
	{0x0166, {'T'}}, // LATIN CAPITAL LETTER T WITH STROKE
	{0x0167, {'t'}}, // LATIN SMALL LETTER T WITH STROKE
	{0x0168, {'U'}}, // LATIN CAPITAL LETTER U WITH TILDE
	{0x0169, {'u'}}, // LATIN SMALL LETTER U WITH TILDE
	{0x016A, {'U'}}, // LATIN CAPITAL LETTER U WITH MACRON
	{0x016B, {'u'}}, // LATIN SMALL LETTER U WITH MACRON
	{0x016C, {'U'}}, // LATIN CAPITAL LETTER U WITH BREVE
	{0x016D, {'u'}}, // LATIN SMALL LETTER U WITH BREVE
	{0x016E, {'U'}}, // LATIN CAPITAL LETTER U WITH RING ABOVE
	{0x016F, {'u'}}, // LATIN SMALL LETTER U WITH RING ABOVE
	{0x0170, {'U'}}, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
	{0x0171, {'u'}}, // LATIN SMALL LETTER U WITH DOUBLE ACUTE
	{0x0172, {'U'}}, // LATIN CAPITAL LETTER U WITH OGONEK
	{0x0173, {'u'}}, // LATIN SMALL LETTER U WITH OGONEK
	{0x0174, {'W'}}, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
	{0x0175, {'w'}}, // LATIN SMALL LETTER W WITH CIRCUMFLEX
	{0x0176, {'Y'}}, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
	{0x0177, {'y'}}, // LATIN SMALL LETTER Y WITH CIRCUMFLEX
	{0x0178, {'Y'}}, // LATIN CAPITAL LETTER Y WITH DIAERESIS
	{0x0179, {'Z'}}, // LATIN CAPITAL LETTER Z WITH ACUTE
	{0x017A, {'z'}}, // LATIN SMALL LETTER Z WITH ACUTE
	{0x017B, {'Z'}}, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
	{0x017C, {'z'}}, // LATIN SMALL LETTER Z WITH DOT ABOVE
	{0x017D, {'Z'}}, // LATIN CAPITAL LETTER Z WITH CARON
	{0x017E, {'z'}}, // LATIN SMALL LETTER Z WITH CARON
	{0x017F, {'s'}}, // LATIN SMALL LETTER LONG S
	{0x0180, {'b'}}, // LATIN SMALL LETTER B WITH STROKE
	{0x0181, {'B'}}, // LATIN CAPITAL LETTER B WITH HOOK
	{0x0182, {'B'}}, // LATIN CAPITAL LETTER B WITH TOPBAR
	{0x0183, {'b'}}, // LATIN SMALL LETTER B WITH TOPBAR
	{0x0184, {'6'}}, // LATIN CAPITAL LETTER TONE SIX
	{0x0185, {'6'}}, // LATIN SMALL LETTER TONE SIX
	{0x0186, {'O'}}, // LATIN CAPITAL LETTER OPEN O
	{0x0187, {'C'}}, // LATIN CAPITAL LETTER C WITH HOOK
	{0x0188, {'c'}}, // LATIN SMALL LETTER C WITH HOOK
	{0x0189, {'D'}}, // LATIN CAPITAL LETTER AFRICAN D
	{0x018A, {'D'}}, // LATIN CAPITAL LETTER D WITH HOOK
	{0x018B, {'D'}}, // LATIN CAPITAL LETTER D WITH TOPBAR
	{0x018C, {'d'}}, // LATIN SMALL LETTER D WITH TOPBAR
	{0x018D, {'d'}}, // LATIN SMALL LETTER TURNED DELTA
	{0x018E, {'3'}}, // LATIN CAPITAL LETTER REVERSED E
	{0x018F, {'@'}}, // LATIN CAPITAL LETTER SCHWA
	{0x0190, {'E'}}, // LATIN CAPITAL LETTER OPEN E
	{0x0191, {'F'}}, // LATIN CAPITAL LETTER F WITH HOOK
	{0x0192, {'f'}}, // LATIN SMALL LETTER F WITH HOOK
	{0x0193, {'G'}}, // LATIN CAPITAL LETTER G WITH HOOK
	{0x0194, {'G'}}, // LATIN CAPITAL LETTER GAMMA
	{0x0195, {'h', 'v'}}, // LATIN SMALL LETTER HV
	{0x0196, {'I'}}, // LATIN CAPITAL LETTER IOTA
	{0x0197, {'I'}}, // LATIN CAPITAL LETTER I WITH STROKE
	{0x0198, {'K'}}, // LATIN CAPITAL LETTER K WITH HOOK
	{0x0199, {'k'}}, // LATIN SMALL LETTER K WITH HOOK
	{0x019A, {'l'}}, // LATIN SMALL LETTER L WITH BAR
	{0x019B, {'l'}}, // LATIN SMALL LETTER LAMBDA WITH STROKE
	{0x019C, {'W'}}, // LATIN CAPITAL LETTER TURNED M
	{0x019D, {'N'}}, // LATIN CAPITAL LETTER N WITH LEFT HOOK
	{0x019E, {'n'}}, // LATIN SMALL LETTER N WITH LONG RIGHT LEG
	{0x019F, {'O'}}, // LATIN CAPITAL LETTER O WITH MIDDLE TILDE
	{0x01A0, {'O'}}, // LATIN CAPITAL LETTER O WITH HORN
	{0x01A1, {'o'}}, // LATIN SMALL LETTER O WITH HORN
	{0x01A2, {'O', 'I'}}, // LATIN CAPITAL LETTER OI
	{0x01A3, {'o', 'i'}}, // LATIN SMALL LETTER OI
	{0x01A4, {'P'}}, // LATIN CAPITAL LETTER P WITH HOOK
	{0x01A5, {'p'}}, // LATIN SMALL LETTER P WITH HOOK
	{0x01A6, {'Y', 'R'}}, // LATIN LETTER YR
	{0x01A7, {'2'}}, // LATIN CAPITAL LETTER TONE TWO
	{0x01A8, {'2'}}, // LATIN SMALL LETTER TONE TWO
	{0x01A9, {'S', 'H'}}, // LATIN CAPITAL LETTER ESH
	{0x01AA, {'s', 'h'}}, // LATIN LETTER REVERSED ESH LOOP
	{0x01AB, {'t'}}, // LATIN SMALL LETTER T WITH PALATAL HOOK
	{0x01AC, {'T'}}, // LATIN CAPITAL LETTER T WITH HOOK
	{0x01AD, {'t'}}, // LATIN SMALL LETTER T WITH HOOK
	{0x01AE, {'T'}}, // LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
	{0x01AF, {'U'}}, // LATIN CAPITAL LETTER U WITH HORN
	{0x01B0, {'u'}}, // LATIN SMALL LETTER U WITH HORN
	{0x01B1, {'Y'}}, // LATIN CAPITAL LETTER UPSILON
	{0x01B2, {'V'}}, // LATIN CAPITAL LETTER V WITH HOOK
	{0x01B3, {'Y'}}, // LATIN CAPITAL LETTER Y WITH HOOK
	{0x01B4, {'y'}}, // LATIN SMALL LETTER Y WITH HOOK
	{0x01B5, {'Z'}}, // LATIN CAPITAL LETTER Z WITH STROKE
	{0x01B6, {'z'}}, // LATIN SMALL LETTER Z WITH STROKE
	{0x01B7, {'Z', 'H'}}, // LATIN CAPITAL LETTER EZH
	{0x01B8, {'Z', 'H'}}, // LATIN CAPITAL LETTER EZH REVERSED
	{0x01B9, {'z', 'h'}}, // LATIN SMALL LETTER EZH REVERSED
	{0x01BA, {'z', 'h'}}, // LATIN SMALL LETTER EZH WITH TAIL
	{0x01BB, {'2'}}, // LATIN LETTER TWO WITH STROKE
	{0x01BC, {'5'}}, // LATIN CAPITAL LETTER TONE FIVE
	{0x01BD, {'5'}}, // LATIN SMALL LETTER TONE FIVE
	{0x01BE, {'t', 's'}}, // LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE
	{0x01BF, {'w'}}, // LATIN LETTER WYNN
	{0x01C0, {'|'}}, // LATIN LETTER DENTAL CLICK
	{0x01C1, {'|', '|'}}, // LATIN LETTER LATERAL CLICK
	{0x01C2, {'|', '='}}, // LATIN LETTER ALVEOLAR CLICK
	{0x01C3, {'!'}}, // LATIN LETTER RETROFLEX CLICK
	{0x01C4, {'D', 'Z'}}, // LATIN CAPITAL LETTER DZ WITH CARON
	{0x01C5, {'D', 'z'}}, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
	{0x01C6, {'d', 'z'}}, // LATIN SMALL LETTER DZ WITH CARON
	{0x01C7, {'L', 'J'}}, // LATIN CAPITAL LETTER LJ
	{0x01C8, {'L', 'j'}}, // LATIN CAPITAL LETTER L WITH SMALL LETTER J
	{0x01C9, {'l', 'j'}}, // LATIN SMALL LETTER LJ
	{0x01CA, {'N', 'J'}}, // LATIN CAPITAL LETTER NJ
	{0x01CB, {'N', 'j'}}, // LATIN CAPITAL LETTER N WITH SMALL LETTER J
	{0x01CC, {'n', 'j'}}, // LATIN SMALL LETTER NJ
	{0x01CD, {'A'}}, // LATIN CAPITAL LETTER A WITH CARON
	{0x01CE, {'a'}}, // LATIN SMALL LETTER A WITH CARON
	{0x01CF, {'I'}}, // LATIN CAPITAL LETTER I WITH CARON
	{0x01D0, {'i'}}, // LATIN SMALL LETTER I WITH CARON
	{0x01D1, {'O'}}, // LATIN CAPITAL LETTER O WITH CARON
	{0x01D2, {'o'}}, // LATIN SMALL LETTER O WITH CARON
	{0x01D3, {'U'}}, // LATIN CAPITAL LETTER U WITH CARON
	{0x01D4, {'u'}}, // LATIN SMALL LETTER U WITH CARON
	{0x01D5, {'U'}}, // LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
	{0x01D6, {'u'}}, // LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
	{0x01D7, {'U'}}, // LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
	{0x01D8, {'u'}}, // LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
	{0x01D9, {'U'}}, // LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
	{0x01DA, {'u'}}, // LATIN SMALL LETTER U WITH DIAERESIS AND CARON
	{0x01DB, {'U'}}, // LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
	{0x01DC, {'u'}}, // LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
	{0x01DD, {'@'}}, // LATIN SMALL LETTER TURNED E
	{0x01DE, {'A'}}, // LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
	{0x01DF, {'a'}}, // LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
	{0x01E0, {'A'}}, // LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
	{0x01E1, {'a'}}, // LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
	{0x01E2, {'A', 'E'}}, // LATIN CAPITAL LETTER AE WITH MACRON
	{0x01E3, {'a', 'e'}}, // LATIN SMALL LETTER AE WITH MACRON
	{0x01E4, {'G'}}, // LATIN CAPITAL LETTER G WITH STROKE
	{0x01E5, {'g'}}, // LATIN SMALL LETTER G WITH STROKE
	{0x01E6, {'G'}}, // LATIN CAPITAL LETTER G WITH CARON
	{0x01E7, {'g'}}, // LATIN SMALL LETTER G WITH CARON
	{0x01E8, {'K'}}, // LATIN CAPITAL LETTER K WITH CARON
	{0x01E9, {'k'}}, // LATIN SMALL LETTER K WITH CARON
	{0x01EA, {'O'}}, // LATIN CAPITAL LETTER O WITH OGONEK
	{0x01EB, {'o'}}, // LATIN SMALL LETTER O WITH OGONEK
	{0x01EC, {'O'}}, // LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
	{0x01ED, {'o'}}, // LATIN SMALL LETTER O WITH OGONEK AND MACRON
	{0x01EE, {'Z', 'H'}}, // LATIN CAPITAL LETTER EZH WITH CARON
	{0x01EF, {'z', 'h'}}, // LATIN SMALL LETTER EZH WITH CARON
	{0x01F0, {'j'}}, // LATIN SMALL LETTER J WITH CARON
	{0x01F1, {'D', 'Z'}}, // LATIN CAPITAL LETTER DZ
	{0x01F2, {'D', 'z'}}, // LATIN CAPITAL LETTER D WITH SMALL LETTER Z
	{0x01F3, {'d', 'z'}}, // LATIN SMALL LETTER DZ
	{0x01F4, {'G'}}, // LATIN CAPITAL LETTER G WITH ACUTE
	{0x01F5, {'g'}}, // LATIN SMALL LETTER G WITH ACUTE
	{0x01F6, {'H', 'V'}}, // LATIN CAPITAL LETTER HWAIR
	{0x01F7, {'W'}}, // LATIN CAPITAL LETTER WYNN
	{0x01F8, {'N'}}, // LATIN CAPITAL LETTER N WITH GRAVE
	{0x01F9, {'n'}}, // LATIN SMALL LETTER N WITH GRAVE
	{0x01FA, {'A'}}, // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
	{0x01FB, {'a'}}, // LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
	{0x01FC, {'A', 'E'}}, // LATIN CAPITAL LETTER AE WITH ACUTE
	{0x01FD, {'a', 'e'}}, // LATIN SMALL LETTER AE WITH ACUTE
	{0x01FE, {'O'}}, // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
	{0x01FF, {'o'}}, // LATIN SMALL LETTER O WITH STROKE AND ACUTE
	{0x0200, {'A'}}, // LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
	{0x0201, {'a'}}, // LATIN SMALL LETTER A WITH DOUBLE GRAVE
	{0x0202, {'A'}}, // LATIN CAPITAL LETTER A WITH INVERTED BREVE
	{0x0203, {'a'}}, // LATIN SMALL LETTER A WITH INVERTED BREVE
	{0x0204, {'E'}}, // LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
	{0x0205, {'e'}}, // LATIN SMALL LETTER E WITH DOUBLE GRAVE
	{0x0206, {'E'}}, // LATIN CAPITAL LETTER E WITH INVERTED BREVE
	{0x0207, {'e'}}, // LATIN SMALL LETTER E WITH INVERTED BREVE
	{0x0208, {'I'}}, // LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
	{0x0209, {'i'}}, // LATIN SMALL LETTER I WITH DOUBLE GRAVE
	{0x020A, {'I'}}, // LATIN CAPITAL LETTER I WITH INVERTED BREVE
	{0x020B, {'i'}}, // LATIN SMALL LETTER I WITH INVERTED BREVE
	{0x020C, {'O'}}, // LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
	{0x020D, {'o'}}, // LATIN SMALL LETTER O WITH DOUBLE GRAVE
	{0x020E, {'O'}}, // LATIN CAPITAL LETTER O WITH INVERTED BREVE
	{0x020F, {'o'}}, // LATIN SMALL LETTER O WITH INVERTED BREVE
	{0x0210, {'R'}}, // LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
	{0x0211, {'r'}}, // LATIN SMALL LETTER R WITH DOUBLE GRAVE
	{0x0212, {'R'}}, // LATIN CAPITAL LETTER R WITH INVERTED BREVE
	{0x0213, {'r'}}, // LATIN SMALL LETTER R WITH INVERTED BREVE
	{0x0214, {'U'}}, // LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
	{0x0215, {'u'}}, // LATIN SMALL LETTER U WITH DOUBLE GRAVE
	{0x0216, {'U'}}, // LATIN CAPITAL LETTER U WITH INVERTED BREVE
	{0x0217, {'u'}}, // LATIN SMALL LETTER U WITH INVERTED BREVE
	{0x0218, {'S'}}, // LATIN CAPITAL LETTER S WITH COMMA BELOW
	{0x0219, {'s'}}, // LATIN SMALL LETTER S WITH COMMA BELOW
	{0x021A, {'T'}}, // LATIN CAPITAL LETTER T WITH COMMA BELOW
	{0x021B, {'t'}}, // LATIN SMALL LETTER T WITH COMMA BELOW
	{0x021C, {'Y'}}, // LATIN CAPITAL LETTER YOGH
	{0x021D, {'y'}}, // LATIN SMALL LETTER YOGH
	{0x021E, {'H'}}, // LATIN CAPITAL LETTER H WITH CARON
	{0x021F, {'h'}}, // LATIN SMALL LETTER H WITH CARON
	{0x0220, {'N'}}, // LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
	{0x0221, {'d'}}, // LATIN SMALL LETTER D WITH CURL
	{0x0222, {'O', 'U'}}, // LATIN CAPITAL LETTER OU
	{0x0223, {'o', 'u'}}, // LATIN SMALL LETTER OU
	{0x0224, {'Z'}}, // LATIN CAPITAL LETTER Z WITH HOOK
	{0x0225, {'z'}}, // LATIN SMALL LETTER Z WITH HOOK
	{0x0226, {'A'}}, // LATIN CAPITAL LETTER A WITH DOT ABOVE
	{0x0227, {'a'}}, // LATIN SMALL LETTER A WITH DOT ABOVE
	{0x0228, {'E'}}, // LATIN CAPITAL LETTER E WITH CEDILLA
	{0x0229, {'e'}}, // LATIN SMALL LETTER E WITH CEDILLA
	{0x022A, {'O'}}, // LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
	{0x022B, {'o'}}, // LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
	{0x022C, {'O'}}, // LATIN CAPITAL LETTER O WITH TILDE AND MACRON
	{0x022D, {'o'}}, // LATIN SMALL LETTER O WITH TILDE AND MACRON
	{0x022E, {'O'}}, // LATIN CAPITAL LETTER O WITH DOT ABOVE
	{0x022F, {'o'}}, // LATIN SMALL LETTER O WITH DOT ABOVE
	{0x0230, {'O'}}, // LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
	{0x0231, {'o'}}, // LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
	{0x0232, {'Y'}}, // LATIN CAPITAL LETTER Y WITH MACRON
	{0x0233, {'y'}}, // LATIN SMALL LETTER Y WITH MACRON
	{0x0234, {'l'}}, // LATIN SMALL LETTER L WITH CURL
	{0x0235, {'n'}}, // LATIN SMALL LETTER N WITH CURL
	{0x0236, {'t'}}, // LATIN SMALL LETTER T WITH CURL
	{0x0237, {'j'}}, // LATIN SMALL LETTER DOTLESS J
	{0x0238, {'d', 'b'}}, // LATIN SMALL LETTER DB DIGRAPH
	{0x0239, {'q', 'p'}}, // LATIN SMALL LETTER QP DIGRAPH
	{0x023A, {'A'}}, // LATIN CAPITAL LETTER A WITH STROKE
	{0x023B, {'C'}}, // LATIN CAPITAL LETTER C WITH STROKE
	{0x023C, {'c'}}, // LATIN SMALL LETTER C WITH STROKE
	{0x023D, {'L'}}, // LATIN CAPITAL LETTER L WITH BAR
	{0x023E, {'T'}}, // LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
	{0x023F, {'s'}}, // LATIN SMALL LETTER S WITH SWASH TAIL
	{0x0240, {'z'}}, // LATIN SMALL LETTER Z WITH SWASH TAIL
	{0x0243, {'B'}}, // LATIN CAPITAL LETTER B WITH STROKE
	{0x0244, {'U'}}, // LATIN CAPITAL LETTER U BAR
	{0x0245, {'^'}}, // LATIN CAPITAL LETTER TURNED V
	{0x0246, {'E'}}, // LATIN CAPITAL LETTER E WITH STROKE
	{0x0247, {'e'}}, // LATIN SMALL LETTER E WITH STROKE
	{0x0248, {'J'}}, // LATIN CAPITAL LETTER J WITH STROKE
	{0x0249, {'j'}}, // LATIN SMALL LETTER J WITH STROKE
	{0x024A, {'q'}}, // LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
	{0x024B, {'q'}}, // LATIN SMALL LETTER Q WITH HOOK TAIL
	{0x024C, {'R'}}, // LATIN CAPITAL LETTER R WITH STROKE
	{0x024D, {'r'}}, // LATIN SMALL LETTER R WITH STROKE
	{0x024E, {'Y'}}, // LATIN CAPITAL LETTER Y WITH STROKE
	{0x024F, {'y'}}, // LATIN SMALL LETTER Y WITH STROKE
	{0x0400, {'I', 'e'}}, // CYRILLIC CAPITAL LETTER IE WITH GRAVE
	{0x0401, {'I', 'o'}}, // CYRILLIC CAPITAL LETTER IO
	{0x0402, {'D', 'j'}}, // CYRILLIC CAPITAL LETTER DJE
	{0x0403, {'G', 'j'}}, // CYRILLIC CAPITAL LETTER GJE
	{0x0404, {'I', 'e'}}, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
	{0x0405, {'D', 'z'}}, // CYRILLIC CAPITAL LETTER DZE
	{0x0406, {'I'}}, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
	{0x0407, {'Y', 'i'}}, // CYRILLIC CAPITAL LETTER YI
	{0x0408, {'J'}}, // CYRILLIC CAPITAL LETTER JE
	{0x0409, {'L', 'j'}}, // CYRILLIC CAPITAL LETTER LJE
	{0x040A, {'N', 'j'}}, // CYRILLIC CAPITAL LETTER NJE
	{0x040C, {'K', 'j'}}, // CYRILLIC CAPITAL LETTER KJE
	{0x040D, {'I'}}, // CYRILLIC CAPITAL LETTER I WITH GRAVE
	{0x040E, {'U'}}, // CYRILLIC CAPITAL LETTER SHORT U
	{0x0410, {'A'}}, // CYRILLIC CAPITAL LETTER A
	{0x0411, {'B'}}, // CYRILLIC CAPITAL LETTER BE
	{0x0412, {'V'}}, // CYRILLIC CAPITAL LETTER VE
	{0x0413, {'G'}}, // CYRILLIC CAPITAL LETTER GHE
	{0x0414, {'D'}}, // CYRILLIC CAPITAL LETTER DE
	{0x0415, {'E'}}, // CYRILLIC CAPITAL LETTER IE
	{0x0416, {'Z', 'h'}}, // CYRILLIC CAPITAL LETTER ZHE
	{0x0417, {'Z'}}, // CYRILLIC CAPITAL LETTER ZE
	{0x0418, {'I'}}, // CYRILLIC CAPITAL LETTER I
	{0x0419, {'I'}}, // CYRILLIC CAPITAL LETTER SHORT I
	{0x041A, {'K'}}, // CYRILLIC CAPITAL LETTER KA
	{0x041B, {'L'}}, // CYRILLIC CAPITAL LETTER EL
	{0x041C, {'M'}}, // CYRILLIC CAPITAL LETTER EM
	{0x041D, {'N'}}, // CYRILLIC CAPITAL LETTER EN
	{0x041E, {'O'}}, // CYRILLIC CAPITAL LETTER O
	{0x041F, {'P'}}, // CYRILLIC CAPITAL LETTER PE
	{0x0420, {'R'}}, // CYRILLIC CAPITAL LETTER ER
	{0x0421, {'S'}}, // CYRILLIC CAPITAL LETTER ES
	{0x0422, {'T'}}, // CYRILLIC CAPITAL LETTER TE
	{0x0423, {'U'}}, // CYRILLIC CAPITAL LETTER U
	{0x0424, {'F'}}, // CYRILLIC CAPITAL LETTER EF
	{0x0425, {'K', 'h'}}, // CYRILLIC CAPITAL LETTER HA
	{0x0426, {'T', 's'}}, // CYRILLIC CAPITAL LETTER TSE
	{0x0427, {'C', 'h'}}, // CYRILLIC CAPITAL LETTER CHE
	{0x0428, {'S', 'h'}}, // CYRILLIC CAPITAL LETTER SHA
	{0x042A, {'\''}}, // CYRILLIC CAPITAL LETTER HARD SIGN
	{0x042B, {'Y'}}, // CYRILLIC CAPITAL LETTER YERU
	{0x042C, {'\''}}, // CYRILLIC CAPITAL LETTER SOFT SIGN
	{0x042D, {'E'}}, // CYRILLIC CAPITAL LETTER E
	{0x042E, {'I', 'u'}}, // CYRILLIC CAPITAL LETTER YU
	{0x042F, {'I', 'a'}}, // CYRILLIC CAPITAL LETTER YA
	{0x0430, {'a'}}, // CYRILLIC SMALL LETTER A
	{0x0431, {'b'}}, // CYRILLIC SMALL LETTER BE
	{0x0432, {'v'}}, // CYRILLIC SMALL LETTER VE
	{0x0433, {'g'}}, // CYRILLIC SMALL LETTER GHE
	{0x0434, {'d'}}, // CYRILLIC SMALL LETTER DE
	{0x0435, {'e'}}, // CYRILLIC SMALL LETTER IE
	{0x0436, {'z', 'h'}}, // CYRILLIC SMALL LETTER ZHE
	{0x0437, {'z'}}, // CYRILLIC SMALL LETTER ZE
	{0x0438, {'i'}}, // CYRILLIC SMALL LETTER I
	{0x0439, {'i'}}, // CYRILLIC SMALL LETTER SHORT I
	{0x043A, {'k'}}, // CYRILLIC SMALL LETTER KA
	{0x043B, {'l'}}, // CYRILLIC SMALL LETTER EL
	{0x043C, {'m'}}, // CYRILLIC SMALL LETTER EM
	{0x043D, {'n'}}, // CYRILLIC SMALL LETTER EN
	{0x043E, {'o'}}, // CYRILLIC SMALL LETTER O
	{0x043F, {'p'}}, // CYRILLIC SMALL LETTER PE
	{0x0440, {'r'}}, // CYRILLIC SMALL LETTER ER
	{0x0441, {'s'}}, // CYRILLIC SMALL LETTER ES
	{0x0442, {'t'}}, // CYRILLIC SMALL LETTER TE
	{0x0443, {'u'}}, // CYRILLIC SMALL LETTER U
	{0x0444, {'f'}}, // CYRILLIC SMALL LETTER EF
	{0x0445, {'k', 'h'}}, // CYRILLIC SMALL LETTER HA
	{0x0446, {'t', 's'}}, // CYRILLIC SMALL LETTER TSE
	{0x0447, {'c', 'h'}}, // CYRILLIC SMALL LETTER CHE
	{0x0448, {'s', 'h'}}, // CYRILLIC SMALL LETTER SHA
	{0x044A, {'\''}}, // CYRILLIC SMALL LETTER HARD SIGN
	{0x044B, {'y'}}, // CYRILLIC SMALL LETTER YERU
	{0x044C, {'\''}}, // CYRILLIC SMALL LETTER SOFT SIGN
	{0x044D, {'e'}}, // CYRILLIC SMALL LETTER E
	{0x044E, {'i', 'u'}}, // CYRILLIC SMALL LETTER YU
	{0x044F, {'i', 'a'}}, // CYRILLIC SMALL LETTER YA
	{0x0450, {'i', 'e'}}, // CYRILLIC SMALL LETTER IE WITH GRAVE
	{0x0451, {'i', 'o'}}, // CYRILLIC SMALL LETTER IO
	{0x0452, {'d', 'j'}}, // CYRILLIC SMALL LETTER DJE
	{0x0453, {'g', 'j'}}, // CYRILLIC SMALL LETTER GJE
	{0x0454, {'i', 'e'}}, // CYRILLIC SMALL LETTER UKRAINIAN IE
	{0x0455, {'d', 'z'}}, // CYRILLIC SMALL LETTER DZE
	{0x0456, {'i'}}, // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
	{0x0457, {'y', 'i'}}, // CYRILLIC SMALL LETTER YI
	{0x0458, {'j'}}, // CYRILLIC SMALL LETTER JE
	{0x0459, {'l', 'j'}}, // CYRILLIC SMALL LETTER LJE
	{0x045A, {'n', 'j'}}, // CYRILLIC SMALL LETTER NJE
	{0x045C, {'k', 'j'}}, // CYRILLIC SMALL LETTER KJE
	{0x045D, {'i'}}, // CYRILLIC SMALL LETTER I WITH GRAVE
	{0x045E, {'u'}}, // CYRILLIC SMALL LETTER SHORT U
	{0x0460, {'O'}}, // CYRILLIC CAPITAL LETTER OMEGA
	{0x0461, {'o'}}, // CYRILLIC SMALL LETTER OMEGA
	{0x0462, {'E'}}, // CYRILLIC CAPITAL LETTER YAT
	{0x0463, {'e'}}, // CYRILLIC SMALL LETTER YAT
	{0x0464, {'I', 'e'}}, // CYRILLIC CAPITAL LETTER IOTIFIED E
	{0x0465, {'i', 'e'}}, // CYRILLIC SMALL LETTER IOTIFIED E
	{0x0466, {'E'}}, // CYRILLIC CAPITAL LETTER LITTLE YUS
	{0x0467, {'e'}}, // CYRILLIC SMALL LETTER LITTLE YUS
	{0x0468, {'I', 'e'}}, // CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
	{0x0469, {'i', 'e'}}, // CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
	{0x046A, {'O'}}, // CYRILLIC CAPITAL LETTER BIG YUS
	{0x046B, {'o'}}, // CYRILLIC SMALL LETTER BIG YUS
	{0x046C, {'I', 'o'}}, // CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
	{0x046D, {'i', 'o'}}, // CYRILLIC SMALL LETTER IOTIFIED BIG YUS
	{0x046E, {'K', 's'}}, // CYRILLIC CAPITAL LETTER KSI
	{0x046F, {'k', 's'}}, // CYRILLIC SMALL LETTER KSI
	{0x0470, {'P', 's'}}, // CYRILLIC CAPITAL LETTER PSI
	{0x0471, {'p', 's'}}, // CYRILLIC SMALL LETTER PSI
	{0x0472, {'F'}}, // CYRILLIC CAPITAL LETTER FITA
	{0x0473, {'f'}}, // CYRILLIC SMALL LETTER FITA
	{0x0474, {'Y'}}, // CYRILLIC CAPITAL LETTER IZHITSA
	{0x0475, {'y'}}, // CYRILLIC SMALL LETTER IZHITSA
	{0x0476, {'Y'}}, // CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
	{0x0477, {'y'}}, // CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
	{0x0478, {'u'}}, // CYRILLIC CAPITAL LETTER UK
	{0x0479, {'u'}}, // CYRILLIC SMALL LETTER UK
	{0x047A, {'O'}}, // CYRILLIC CAPITAL LETTER ROUND OMEGA
	{0x047B, {'o'}}, // CYRILLIC SMALL LETTER ROUND OMEGA
	{0x047C, {'O'}}, // CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
	{0x047D, {'o'}}, // CYRILLIC SMALL LETTER OMEGA WITH TITLO
	{0x047E, {'O', 't'}}, // CYRILLIC CAPITAL LETTER OT
	{0x047F, {'o', 't'}}, // CYRILLIC SMALL LETTER OT
	{0x0480, {'Q'}}, // CYRILLIC CAPITAL LETTER KOPPA
	{0x0481, {'q'}}, // CYRILLIC SMALL LETTER KOPPA
	{0x048C, {'"'}}, // CYRILLIC CAPITAL LETTER SEMISOFT SIGN
	{0x048D, {'"'}}, // CYRILLIC SMALL LETTER SEMISOFT SIGN
	{0x048E, {'R', '\''}}, // CYRILLIC CAPITAL LETTER ER WITH TICK
	{0x048F, {'r', '\''}}, // CYRILLIC SMALL LETTER ER WITH TICK
	{0x0490, {'G', '\''}}, // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
	{0x0491, {'g', '\''}}, // CYRILLIC SMALL LETTER GHE WITH UPTURN
	{0x0492, {'G', '\''}}, // CYRILLIC CAPITAL LETTER GHE WITH STROKE
	{0x0493, {'g', '\''}}, // CYRILLIC SMALL LETTER GHE WITH STROKE
	{0x0494, {'G', '\''}}, // CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
	{0x0495, {'g', '\''}}, // CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
	{0x0498, {'Z', '\''}}, // CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
	{0x0499, {'z', '\''}}, // CYRILLIC SMALL LETTER ZE WITH DESCENDER
	{0x049A, {'K', '\''}}, // CYRILLIC CAPITAL LETTER KA WITH DESCENDER
	{0x049B, {'k', '\''}}, // CYRILLIC SMALL LETTER KA WITH DESCENDER
	{0x049C, {'K', '\''}}, // CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
	{0x049D, {'k', '\''}}, // CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
	{0x049E, {'K', '\''}}, // CYRILLIC CAPITAL LETTER KA WITH STROKE
	{0x049F, {'k', '\''}}, // CYRILLIC SMALL LETTER KA WITH STROKE
	{0x04A0, {'K', '\''}}, // CYRILLIC CAPITAL LETTER BASHKIR KA
	{0x04A1, {'k', '\''}}, // CYRILLIC SMALL LETTER BASHKIR KA
	{0x04A2, {'N', '\''}}, // CYRILLIC CAPITAL LETTER EN WITH DESCENDER
	{0x04A3, {'n', '\''}}, // CYRILLIC SMALL LETTER EN WITH DESCENDER
	{0x04A4, {'N', 'g'}}, // CYRILLIC CAPITAL LIGATURE EN GHE
	{0x04A5, {'n', 'g'}}, // CYRILLIC SMALL LIGATURE EN GHE
	{0x04A6, {'P', '\''}}, // CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
	{0x04A7, {'p', '\''}}, // CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
	{0x04A8, {'K', 'h'}}, // CYRILLIC CAPITAL LETTER ABKHASIAN HA
	{0x04A9, {'k', 'h'}}, // CYRILLIC SMALL LETTER ABKHASIAN HA
	{0x04AA, {'S', '\''}}, // CYRILLIC CAPITAL LETTER ES WITH DESCENDER
	{0x04AB, {'s', '\''}}, // CYRILLIC SMALL LETTER ES WITH DESCENDER
	{0x04AC, {'T', '\''}}, // CYRILLIC CAPITAL LETTER TE WITH DESCENDER
	{0x04AD, {'t', '\''}}, // CYRILLIC SMALL LETTER TE WITH DESCENDER
	{0x04AE, {'U'}}, // CYRILLIC CAPITAL LETTER STRAIGHT U
	{0x04AF, {'u'}}, // CYRILLIC SMALL LETTER STRAIGHT U
	{0x04B0, {'U', '\''}}, // CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
	{0x04B1, {'u', '\''}}, // CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
	{0x04BA, {'H'}}, // CYRILLIC CAPITAL LETTER SHHA
	{0x04BB, {'h'}}, // CYRILLIC SMALL LETTER SHHA
	{0x04BC, {'C', 'h'}}, // CYRILLIC CAPITAL LETTER ABKHASIAN CHE
	{0x04BD, {'c', 'h'}}, // CYRILLIC SMALL LETTER ABKHASIAN CHE
	{0x04C0, {'`'}}, // CYRILLIC LETTER PALOCHKA
	{0x04C1, {'Z', 'h'}}, // CYRILLIC CAPITAL LETTER ZHE WITH BREVE
	{0x04C2, {'z', 'h'}}, // CYRILLIC SMALL LETTER ZHE WITH BREVE
	{0x04C3, {'K', '\''}}, // CYRILLIC CAPITAL LETTER KA WITH HOOK
	{0x04C4, {'k', '\''}}, // CYRILLIC SMALL LETTER KA WITH HOOK
	{0x04C7, {'N', '\''}}, // CYRILLIC CAPITAL LETTER EN WITH HOOK
	{0x04C8, {'n', '\''}}, // CYRILLIC SMALL LETTER EN WITH HOOK
	{0x04CB, {'C', 'h'}}, // CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
	{0x04CC, {'c', 'h'}}, // CYRILLIC SMALL LETTER KHAKASSIAN CHE
	{0x04D0, {'a'}}, // CYRILLIC CAPITAL LETTER A WITH BREVE
	{0x04D1, {'a'}}, // CYRILLIC SMALL LETTER A WITH BREVE
	{0x04D2, {'A'}}, // CYRILLIC CAPITAL LETTER A WITH DIAERESIS
	{0x04D3, {'a'}}, // CYRILLIC SMALL LETTER A WITH DIAERESIS
	{0x04D4, {'A', 'e'}}, // CYRILLIC CAPITAL LIGATURE A IE
	{0x04D5, {'a', 'e'}}, // CYRILLIC SMALL LIGATURE A IE
	{0x04D6, {'I', 'e'}}, // CYRILLIC CAPITAL LETTER IE WITH BREVE
	{0x04D7, {'i', 'e'}}, // CYRILLIC SMALL LETTER IE WITH BREVE
	{0x04D8, {'@'}}, // CYRILLIC CAPITAL LETTER SCHWA
	{0x04D9, {'@'}}, // CYRILLIC SMALL LETTER SCHWA
	{0x04DA, {'@'}}, // CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
	{0x04DB, {'@'}}, // CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
	{0x04DC, {'Z', 'h'}}, // CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
	{0x04DD, {'z', 'h'}}, // CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
	{0x04DE, {'Z'}}, // CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
	{0x04DF, {'z'}}, // CYRILLIC SMALL LETTER ZE WITH DIAERESIS
	{0x04E0, {'D', 'z'}}, // CYRILLIC CAPITAL LETTER ABKHASIAN DZE
	{0x04E1, {'d', 'z'}}, // CYRILLIC SMALL LETTER ABKHASIAN DZE
	{0x04E2, {'I'}}, // CYRILLIC CAPITAL LETTER I WITH MACRON
	{0x04E3, {'i'}}, // CYRILLIC SMALL LETTER I WITH MACRON
	{0x04E4, {'I'}}, // CYRILLIC CAPITAL LETTER I WITH DIAERESIS
	{0x04E5, {'i'}}, // CYRILLIC SMALL LETTER I WITH DIAERESIS
	{0x04E6, {'O'}}, // CYRILLIC CAPITAL LETTER O WITH DIAERESIS
	{0x04E7, {'o'}}, // CYRILLIC SMALL LETTER O WITH DIAERESIS
	{0x04E8, {'O'}}, // CYRILLIC CAPITAL LETTER BARRED O
	{0x04E9, {'o'}}, // CYRILLIC SMALL LETTER BARRED O
	{0x04EA, {'O'}}, // CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
	{0x04EB, {'o'}}, // CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
	{0x04EC, {'E'}}, // CYRILLIC CAPITAL LETTER E WITH DIAERESIS
	{0x04ED, {'e'}}, // CYRILLIC SMALL LETTER E WITH DIAERESIS
	{0x04EE, {'U'}}, // CYRILLIC CAPITAL LETTER U WITH MACRON
	{0x04EF, {'u'}}, // CYRILLIC SMALL LETTER U WITH MACRON
	{0x04F0, {'U'}}, // CYRILLIC CAPITAL LETTER U WITH DIAERESIS
	{0x04F1, {'u'}}, // CYRILLIC SMALL LETTER U WITH DIAERESIS
	{0x04F2, {'U'}}, // CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
	{0x04F3, {'u'}}, // CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
	{0x04F4, {'C', 'h'}}, // CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
	{0x04F5, {'c', 'h'}}, // CYRILLIC SMALL LETTER CHE WITH DIAERESIS
	{0x04F8, {'Y'}}, // CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
	{0x04F9, {'y'}}, // CYRILLIC SMALL LETTER YERU WITH DIAERESIS
	{0x2000, {' '}}, // EN QUAD
	{0x2001, {' '}}, // EM QUAD
	{0x2002, {' '}}, // EN SPACE
	{0x2003, {' '}}, // EM SPACE
	{0x2004, {' '}}, // THREE-PER-EM SPACE
	{0x2005, {' '}}, // FOUR-PER-EM SPACE
	{0x2006, {' '}}, // SIX-PER-EM SPACE
	{0x2007, {' '}}, // FIGURE SPACE
	{0x2008, {' '}}, // PUNCTUATION SPACE
	{0x2009, {' '}}, // THIN SPACE
	{0x200A, {' '}}, // HAIR SPACE
	{0x200B, {' '}}, // ZERO WIDTH SPACE
	{0x2010, {'-'}}, // HYPHEN
	{0x2011, {'-'}}, // NON-BREAKING HYPHEN
	{0x2012, {'-'}}, // FIGURE DASH
	{0x2013, {'-'}}, // EN DASH
	{0x2014, {'-', '-'}}, // EM DASH
	{0x2015, {'-', '-'}}, // HORIZONTAL BAR
	{0x2016, {'|', '|'}}, // DOUBLE VERTICAL LINE
	{0x2017, {'_'}}, // DOUBLE LOW LINE
	{0x2018, {'\''}}, // LEFT SINGLE QUOTATION MARK
	{0x2019, {'\''}}, // RIGHT SINGLE QUOTATION MARK
	{0x201A, {','}}, // SINGLE LOW-9 QUOTATION MARK
	{0x201B, {'\''}}, // SINGLE HIGH-REVERSED-9 QUOTATION MARK
	{0x201C, {'"'}}, // LEFT DOUBLE QUOTATION MARK
	{0x201D, {'"'}}, // RIGHT DOUBLE QUOTATION MARK
	{0x201E, {',', ','}}, // DOUBLE LOW-9 QUOTATION MARK
	{0x201F, {'"'}}, // DOUBLE HIGH-REVERSED-9 QUOTATION MARK
	{0x2020, {'+'}}, // DAGGER
	{0x2021, {'+', '+'}}, // DOUBLE DAGGER
	{0x2022, {'*'}}, // BULLET
	{0x2023, {'*', '>'}}, // TRIANGULAR BULLET
	{0x2024, {'.'}}, // ONE DOT LEADER
	{0x2025, {'.', '.'}}, // TWO DOT LEADER
	{0x2027, {'.'}}, // HYPHENATION POINT
	{0x2028, {'\n'}}, // LINE SEPARATOR
	{0x2029, {'\n', '\n'}}, // PARAGRAPH SEPARATOR
	{0x202F, {' '}}, // NARROW NO-BREAK SPACE
	{0x2030, {'%', '0'}}, // PER MILLE SIGN
	{0x2032, {'\''}}, // PRIME
	{0x2033, {'\'', '\''}}, // DOUBLE PRIME
	{0x2035, {'`'}}, // REVERSED PRIME
	{0x2036, {'`', '`'}}, // REVERSED DOUBLE PRIME
	{0x2038, {'^'}}, // CARET
	{0x2039, {'<'}}, // SINGLE LEFT-POINTING ANGLE QUOTATION MARK
	{0x203A, {'>'}}, // SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
	{0x203B, {'*'}}, // REFERENCE MARK
	{0x203C, {'!', '!'}}, // DOUBLE EXCLAMATION MARK
	{0x203D, {'!', '?'}}, // INTERROBANG
	{0x203E, {'-'}}, // OVERLINE
	{0x203F, {'_'}}, // UNDERTIE
	{0x2040, {'-'}}, // CHARACTER TIE
	{0x2041, {'^'}}, // CARET INSERTION POINT
	{0x2043, {'-', '-'}}, // HYPHEN BULLET
	{0x2044, {'/'}}, // FRACTION SLASH
	{0x2045, {'-', '['}}, // LEFT SQUARE BRACKET WITH QUILL
	{0x2046, {']', '-'}}, // RIGHT SQUARE BRACKET WITH QUILL
	{0x2047, {'?', '?'}}, // DOUBLE QUESTION MARK
	{0x2048, {'?', '!'}}, // QUESTION EXCLAMATION MARK
	{0x2049, {'!', '?'}}, // EXCLAMATION QUESTION MARK
	{0x204A, {'&'}}, // TIRONIAN SIGN ET
	{0x204B, {'P', 'P'}}, // REVERSED PILCROW SIGN
	{0x204C, {'(', ']'}}, // BLACK LEFTWARDS BULLET
	{0x204D, {'[', ')'}}, // BLACK RIGHTWARDS BULLET
	{0x204E, {'*'}}, // LOW ASTERISK
	{0x2052, {'%'}}, // COMMERCIAL MINUS SIGN
	{0x2053, {'~'}}, // SWUNG DASH
	{0x205F, {' '}}, // MEDIUM MATHEMATICAL SPACE
};
