/*
 * Copyright @ 2018 - Present, 8x8 Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jitsi.nlj.rtp

import org.jitsi.rtp.rtp.RtpPacket

open class AudioRtpPacket(
    buffer: ByteArray,
    offset: Int,
    length: Int
) : RtpPacket(buffer, offset, length) {

    override fun clone(): AudioRtpPacket = AudioRtpPacket(
        cloneBuffer(BYTES_TO_LEAVE_AT_START_OF_PACKET),
        BYTES_TO_LEAVE_AT_START_OF_PACKET,
        length
    ).also { postClone(it) }
}
