--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

with Ada.Unchecked_Conversion;

with Langkit_Support.Diagnostics;       use Langkit_Support.Diagnostics;
with Langkit_Support.File_Readers;      use Langkit_Support.File_Readers;
with Langkit_Support.Generic_API;       use Langkit_Support.Generic_API;
with Langkit_Support.Generic_API.Introspection;
use Langkit_Support.Generic_API.Introspection;
with Langkit_Support.Internal;          use Langkit_Support.Internal;
with Langkit_Support.Internal.Analysis; use Langkit_Support.Internal.Analysis;
with Langkit_Support.Internal.Descriptor;
use Langkit_Support.Internal.Descriptor;
with Langkit_Support.Slocs;             use Langkit_Support.Slocs;
with Langkit_Support.Text;              use Langkit_Support.Text;
with Langkit_Support.Types;             use Langkit_Support.Types;

with Libadalang.Implementation;
with Libadalang.Generic_Introspection;
use Libadalang.Generic_Introspection;
with Libadalang.Unparsers;
with Libadalang.Private_Converters; use Libadalang.Private_Converters;

with Libadalang.Common;

--  This package provide Libadalang-specific implementations for the
--  generic operations defined in Langkit_Support.Internal.Descriptor.

private package Libadalang.Generic_Impl is

   

   function "+" is new Ada.Unchecked_Conversion
     (Internal_Context, Implementation.Internal_Context);
   function "+" is new Ada.Unchecked_Conversion
     (Implementation.Internal_Context, Internal_Context);

   function "+" is new Ada.Unchecked_Conversion
     (Internal_Unit, Implementation.Internal_Unit);
   function "+" is new Ada.Unchecked_Conversion
     (Implementation.Internal_Unit, Internal_Unit);

   function "+" is new Ada.Unchecked_Conversion
     (Internal_Node, Implementation.Bare_Ada_Node);
   function "+" is new Ada.Unchecked_Conversion
     (Implementation.Bare_Ada_Node, Internal_Node);

   function "+"
     (Entity : Internal_Entity) return Implementation.Internal_Entity
     with Export,
          External_Name => "Libadalang__from_generic_internal_entity";
   function "+"
     (Entity : Implementation.Internal_Entity) return Internal_Entity
     with Export,
          External_Name => "Libadalang__to_generic_internal_entity";

   function "+" (Rule : Grammar_Rule_Index) return Common.Grammar_Rule
   is (Common.Grammar_Rule'Val (Rule - 1));
   --  Grammar rules start at 1 in the generic API: rebase the value before
   --  converting it to the native type.

   function "+" (Token : Common.Token_Reference) return Internal_Token
   is ((Get_Token_TDH (Token), Get_Token_Index (Token)));

   function Wrap_Token
     (Context : Internal_Context;
      Token   : Internal_Token) return Common.Token_Reference
   is (Wrap_Token_Reference (+Context, Token.TDH, Token.Index));

   --  Descriptors for token kinds

   
      
      Token_Kind_Name_1 : aliased constant Text_Type :=
        "Abort";
      
      Token_Kind_Name_2 : aliased constant Text_Type :=
        "Abs";
      
      Token_Kind_Name_3 : aliased constant Text_Type :=
        "Accept";
      
      Token_Kind_Name_4 : aliased constant Text_Type :=
        "Access";
      
      Token_Kind_Name_5 : aliased constant Text_Type :=
        "All";
      
      Token_Kind_Name_6 : aliased constant Text_Type :=
        "Amp";
      
      Token_Kind_Name_7 : aliased constant Text_Type :=
        "And";
      
      Token_Kind_Name_8 : aliased constant Text_Type :=
        "Array";
      
      Token_Kind_Name_9 : aliased constant Text_Type :=
        "Arrow";
      
      Token_Kind_Name_10 : aliased constant Text_Type :=
        "Assign";
      
      Token_Kind_Name_11 : aliased constant Text_Type :=
        "At";
      
      Token_Kind_Name_12 : aliased constant Text_Type :=
        "Begin";
      
      Token_Kind_Name_13 : aliased constant Text_Type :=
        "Body";
      
      Token_Kind_Name_14 : aliased constant Text_Type :=
        "Brack_Close";
      
      Token_Kind_Name_15 : aliased constant Text_Type :=
        "Brack_Open";
      
      Token_Kind_Name_16 : aliased constant Text_Type :=
        "Case";
      
      Token_Kind_Name_17 : aliased constant Text_Type :=
        "Char";
      
      Token_Kind_Name_18 : aliased constant Text_Type :=
        "Colon";
      
      Token_Kind_Name_19 : aliased constant Text_Type :=
        "Comma";
      
      Token_Kind_Name_20 : aliased constant Text_Type :=
        "Comment";
      
      Token_Kind_Name_21 : aliased constant Text_Type :=
        "Constant";
      
      Token_Kind_Name_22 : aliased constant Text_Type :=
        "Decimal";
      
      Token_Kind_Name_23 : aliased constant Text_Type :=
        "Declare";
      
      Token_Kind_Name_24 : aliased constant Text_Type :=
        "Delay";
      
      Token_Kind_Name_25 : aliased constant Text_Type :=
        "Delta";
      
      Token_Kind_Name_26 : aliased constant Text_Type :=
        "Diamond";
      
      Token_Kind_Name_27 : aliased constant Text_Type :=
        "Digits";
      
      Token_Kind_Name_28 : aliased constant Text_Type :=
        "Divide";
      
      Token_Kind_Name_29 : aliased constant Text_Type :=
        "Do";
      
      Token_Kind_Name_30 : aliased constant Text_Type :=
        "Dot";
      
      Token_Kind_Name_31 : aliased constant Text_Type :=
        "Doubledot";
      
      Token_Kind_Name_32 : aliased constant Text_Type :=
        "Else";
      
      Token_Kind_Name_33 : aliased constant Text_Type :=
        "Elsif";
      
      Token_Kind_Name_34 : aliased constant Text_Type :=
        "End";
      
      Token_Kind_Name_35 : aliased constant Text_Type :=
        "Entry";
      
      Token_Kind_Name_36 : aliased constant Text_Type :=
        "Equal";
      
      Token_Kind_Name_37 : aliased constant Text_Type :=
        "Exception";
      
      Token_Kind_Name_38 : aliased constant Text_Type :=
        "Exit";
      
      Token_Kind_Name_39 : aliased constant Text_Type :=
        "For";
      
      Token_Kind_Name_40 : aliased constant Text_Type :=
        "Format_String_End";
      
      Token_Kind_Name_41 : aliased constant Text_Type :=
        "Format_String_Mid";
      
      Token_Kind_Name_42 : aliased constant Text_Type :=
        "Format_String_Start";
      
      Token_Kind_Name_43 : aliased constant Text_Type :=
        "Format_String_String";
      
      Token_Kind_Name_44 : aliased constant Text_Type :=
        "Function";
      
      Token_Kind_Name_45 : aliased constant Text_Type :=
        "Generic";
      
      Token_Kind_Name_46 : aliased constant Text_Type :=
        "Goto";
      
      Token_Kind_Name_47 : aliased constant Text_Type :=
        "Gt";
      
      Token_Kind_Name_48 : aliased constant Text_Type :=
        "Gte";
      
      Token_Kind_Name_49 : aliased constant Text_Type :=
        "Identifier";
      
      Token_Kind_Name_50 : aliased constant Text_Type :=
        "If";
      
      Token_Kind_Name_51 : aliased constant Text_Type :=
        "In";
      
      Token_Kind_Name_52 : aliased constant Text_Type :=
        "Integer";
      
      Token_Kind_Name_53 : aliased constant Text_Type :=
        "Is";
      
      Token_Kind_Name_54 : aliased constant Text_Type :=
        "Label_End";
      
      Token_Kind_Name_55 : aliased constant Text_Type :=
        "Label_Start";
      
      Token_Kind_Name_56 : aliased constant Text_Type :=
        "Lexing_Failure";
      
      Token_Kind_Name_57 : aliased constant Text_Type :=
        "Limited";
      
      Token_Kind_Name_58 : aliased constant Text_Type :=
        "Loop";
      
      Token_Kind_Name_59 : aliased constant Text_Type :=
        "Lt";
      
      Token_Kind_Name_60 : aliased constant Text_Type :=
        "Lte";
      
      Token_Kind_Name_61 : aliased constant Text_Type :=
        "Minus";
      
      Token_Kind_Name_62 : aliased constant Text_Type :=
        "Mod";
      
      Token_Kind_Name_63 : aliased constant Text_Type :=
        "Mult";
      
      Token_Kind_Name_64 : aliased constant Text_Type :=
        "New";
      
      Token_Kind_Name_65 : aliased constant Text_Type :=
        "Not";
      
      Token_Kind_Name_66 : aliased constant Text_Type :=
        "Notequal";
      
      Token_Kind_Name_67 : aliased constant Text_Type :=
        "Null";
      
      Token_Kind_Name_68 : aliased constant Text_Type :=
        "Of";
      
      Token_Kind_Name_69 : aliased constant Text_Type :=
        "Or";
      
      Token_Kind_Name_70 : aliased constant Text_Type :=
        "Others";
      
      Token_Kind_Name_71 : aliased constant Text_Type :=
        "Out";
      
      Token_Kind_Name_72 : aliased constant Text_Type :=
        "Package";
      
      Token_Kind_Name_73 : aliased constant Text_Type :=
        "Par_Close";
      
      Token_Kind_Name_74 : aliased constant Text_Type :=
        "Par_Open";
      
      Token_Kind_Name_75 : aliased constant Text_Type :=
        "Pipe";
      
      Token_Kind_Name_76 : aliased constant Text_Type :=
        "Plus";
      
      Token_Kind_Name_77 : aliased constant Text_Type :=
        "Power";
      
      Token_Kind_Name_78 : aliased constant Text_Type :=
        "Pragma";
      
      Token_Kind_Name_79 : aliased constant Text_Type :=
        "Prep_Line";
      
      Token_Kind_Name_80 : aliased constant Text_Type :=
        "Private";
      
      Token_Kind_Name_81 : aliased constant Text_Type :=
        "Procedure";
      
      Token_Kind_Name_82 : aliased constant Text_Type :=
        "Raise";
      
      Token_Kind_Name_83 : aliased constant Text_Type :=
        "Range";
      
      Token_Kind_Name_84 : aliased constant Text_Type :=
        "Record";
      
      Token_Kind_Name_85 : aliased constant Text_Type :=
        "Rem";
      
      Token_Kind_Name_86 : aliased constant Text_Type :=
        "Renames";
      
      Token_Kind_Name_87 : aliased constant Text_Type :=
        "Return";
      
      Token_Kind_Name_88 : aliased constant Text_Type :=
        "Reverse";
      
      Token_Kind_Name_89 : aliased constant Text_Type :=
        "Select";
      
      Token_Kind_Name_90 : aliased constant Text_Type :=
        "Semicolon";
      
      Token_Kind_Name_91 : aliased constant Text_Type :=
        "Separate";
      
      Token_Kind_Name_92 : aliased constant Text_Type :=
        "String";
      
      Token_Kind_Name_93 : aliased constant Text_Type :=
        "Subtype";
      
      Token_Kind_Name_94 : aliased constant Text_Type :=
        "Target";
      
      Token_Kind_Name_95 : aliased constant Text_Type :=
        "Task";
      
      Token_Kind_Name_96 : aliased constant Text_Type :=
        "Terminate";
      
      Token_Kind_Name_97 : aliased constant Text_Type :=
        "Termination";
      
      Token_Kind_Name_98 : aliased constant Text_Type :=
        "Then";
      
      Token_Kind_Name_99 : aliased constant Text_Type :=
        "Tick";
      
      Token_Kind_Name_100 : aliased constant Text_Type :=
        "Type";
      
      Token_Kind_Name_101 : aliased constant Text_Type :=
        "Use";
      
      Token_Kind_Name_102 : aliased constant Text_Type :=
        "When";
      
      Token_Kind_Name_103 : aliased constant Text_Type :=
        "While";
      
      Token_Kind_Name_104 : aliased constant Text_Type :=
        "Whitespace";
      
      Token_Kind_Name_105 : aliased constant Text_Type :=
        "With";
      
      Token_Kind_Name_106 : aliased constant Text_Type :=
        "Xor";
   Token_Kind_Descriptors : aliased constant Token_Kind_Descriptor_Array := (
      Token_Index_For_Ada_Abort =>
       (Name       => Token_Kind_Name_1'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Abs =>
       (Name       => Token_Kind_Name_2'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Accept =>
       (Name       => Token_Kind_Name_3'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Access =>
       (Name       => Token_Kind_Name_4'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_All =>
       (Name       => Token_Kind_Name_5'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Amp =>
       (Name       => Token_Kind_Name_6'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_And =>
       (Name       => Token_Kind_Name_7'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Array =>
       (Name       => Token_Kind_Name_8'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Arrow =>
       (Name       => Token_Kind_Name_9'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Assign =>
       (Name       => Token_Kind_Name_10'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_At =>
       (Name       => Token_Kind_Name_11'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Begin =>
       (Name       => Token_Kind_Name_12'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Body =>
       (Name       => Token_Kind_Name_13'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Brack_Close =>
       (Name       => Token_Kind_Name_14'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Brack_Open =>
       (Name       => Token_Kind_Name_15'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Case =>
       (Name       => Token_Kind_Name_16'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Char =>
       (Name       => Token_Kind_Name_17'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Colon =>
       (Name       => Token_Kind_Name_18'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Comma =>
       (Name       => Token_Kind_Name_19'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Comment =>
       (Name       => Token_Kind_Name_20'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => True),
      Token_Index_For_Ada_Constant =>
       (Name       => Token_Kind_Name_21'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Decimal =>
       (Name       => Token_Kind_Name_22'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Declare =>
       (Name       => Token_Kind_Name_23'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Delay =>
       (Name       => Token_Kind_Name_24'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Delta =>
       (Name       => Token_Kind_Name_25'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Diamond =>
       (Name       => Token_Kind_Name_26'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Digits =>
       (Name       => Token_Kind_Name_27'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Divide =>
       (Name       => Token_Kind_Name_28'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Do =>
       (Name       => Token_Kind_Name_29'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Dot =>
       (Name       => Token_Kind_Name_30'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Doubledot =>
       (Name       => Token_Kind_Name_31'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Else =>
       (Name       => Token_Kind_Name_32'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Elsif =>
       (Name       => Token_Kind_Name_33'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_End =>
       (Name       => Token_Kind_Name_34'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Entry =>
       (Name       => Token_Kind_Name_35'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Equal =>
       (Name       => Token_Kind_Name_36'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Exception =>
       (Name       => Token_Kind_Name_37'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Exit =>
       (Name       => Token_Kind_Name_38'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_For =>
       (Name       => Token_Kind_Name_39'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Format_String_End =>
       (Name       => Token_Kind_Name_40'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Format_String_Mid =>
       (Name       => Token_Kind_Name_41'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Format_String_Start =>
       (Name       => Token_Kind_Name_42'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Format_String_String =>
       (Name       => Token_Kind_Name_43'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Function =>
       (Name       => Token_Kind_Name_44'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Generic =>
       (Name       => Token_Kind_Name_45'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Goto =>
       (Name       => Token_Kind_Name_46'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Gt =>
       (Name       => Token_Kind_Name_47'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Gte =>
       (Name       => Token_Kind_Name_48'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Identifier =>
       (Name       => Token_Kind_Name_49'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_If =>
       (Name       => Token_Kind_Name_50'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_In =>
       (Name       => Token_Kind_Name_51'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Integer =>
       (Name       => Token_Kind_Name_52'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Is =>
       (Name       => Token_Kind_Name_53'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Label_End =>
       (Name       => Token_Kind_Name_54'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Label_Start =>
       (Name       => Token_Kind_Name_55'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Lexing_Failure =>
       (Name       => Token_Kind_Name_56'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Limited =>
       (Name       => Token_Kind_Name_57'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Loop =>
       (Name       => Token_Kind_Name_58'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Lt =>
       (Name       => Token_Kind_Name_59'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Lte =>
       (Name       => Token_Kind_Name_60'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Minus =>
       (Name       => Token_Kind_Name_61'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Mod =>
       (Name       => Token_Kind_Name_62'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Mult =>
       (Name       => Token_Kind_Name_63'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_New =>
       (Name       => Token_Kind_Name_64'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Not =>
       (Name       => Token_Kind_Name_65'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Notequal =>
       (Name       => Token_Kind_Name_66'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Null =>
       (Name       => Token_Kind_Name_67'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Of =>
       (Name       => Token_Kind_Name_68'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Or =>
       (Name       => Token_Kind_Name_69'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Others =>
       (Name       => Token_Kind_Name_70'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Out =>
       (Name       => Token_Kind_Name_71'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Package =>
       (Name       => Token_Kind_Name_72'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Par_Close =>
       (Name       => Token_Kind_Name_73'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Par_Open =>
       (Name       => Token_Kind_Name_74'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Pipe =>
       (Name       => Token_Kind_Name_75'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Plus =>
       (Name       => Token_Kind_Name_76'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Power =>
       (Name       => Token_Kind_Name_77'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Pragma =>
       (Name       => Token_Kind_Name_78'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Prep_Line =>
       (Name       => Token_Kind_Name_79'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Private =>
       (Name       => Token_Kind_Name_80'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Procedure =>
       (Name       => Token_Kind_Name_81'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Raise =>
       (Name       => Token_Kind_Name_82'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Range =>
       (Name       => Token_Kind_Name_83'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Record =>
       (Name       => Token_Kind_Name_84'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Rem =>
       (Name       => Token_Kind_Name_85'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Renames =>
       (Name       => Token_Kind_Name_86'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Return =>
       (Name       => Token_Kind_Name_87'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Reverse =>
       (Name       => Token_Kind_Name_88'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Select =>
       (Name       => Token_Kind_Name_89'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Semicolon =>
       (Name       => Token_Kind_Name_90'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Separate =>
       (Name       => Token_Kind_Name_91'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_String =>
       (Name       => Token_Kind_Name_92'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Subtype =>
       (Name       => Token_Kind_Name_93'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Target =>
       (Name       => Token_Kind_Name_94'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Task =>
       (Name       => Token_Kind_Name_95'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Terminate =>
       (Name       => Token_Kind_Name_96'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Termination =>
       (Name       => Token_Kind_Name_97'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Then =>
       (Name       => Token_Kind_Name_98'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Tick =>
       (Name       => Token_Kind_Name_99'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_Type =>
       (Name       => Token_Kind_Name_100'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Use =>
       (Name       => Token_Kind_Name_101'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_When =>
       (Name       => Token_Kind_Name_102'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_While =>
       (Name       => Token_Kind_Name_103'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Whitespace =>
       (Name       => Token_Kind_Name_104'Access,
        Family     => Token_Index_For_Default_Family,
        Is_Comment => False),
      Token_Index_For_Ada_With =>
       (Name       => Token_Kind_Name_105'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False),
      Token_Index_For_Ada_Xor =>
       (Name       => Token_Kind_Name_106'Access,
        Family     => Token_Index_For_Alphanumericals,
        Is_Comment => False)
   );

   --  Descriptors for token families

   
      
      Token_Family_Name_1 : aliased constant Text_Type := "Alphanumericals";
      
      Token_Family_Name_2 : aliased constant Text_Type := "Default_Family";
   Token_Family_Names : aliased constant Token_Family_Name_Array :=
     (1 => Token_Family_Name_1'Access, 2 => Token_Family_Name_2'Access);

   --  Implementations for generic operations on analysis types

   function Create_Context
     (Charset     : String;
      File_Reader : File_Reader_Reference;
      With_Trivia : Boolean;
      Tab_Stop    : Natural) return Internal_Context;

   procedure Context_Inc_Ref (Context : Internal_Context);
   procedure Context_Dec_Ref (Context : in out Internal_Context);
   function Context_Version (Context : Internal_Context) return Version_Number;
   function Context_Has_With_Trivia
     (Context : Internal_Context) return Boolean;
   function Context_Has_Unit
     (Context : Internal_Context; Unit_Filename : String) return Boolean;
   function Context_Get_From_File
     (Context           : Internal_Context;
      Filename, Charset : String;
      Reparse           : Boolean;
      Rule              : Grammar_Rule_Index) return Internal_Unit;
   function Context_Get_From_Buffer
     (Context                   : Internal_Context;
      Filename, Buffer, Charset : String;
      Rule                      : Grammar_Rule_Index) return Internal_Unit;

   function Unit_Context (Unit : Internal_Unit) return Internal_Context;
   function Unit_Version (Unit : Internal_Unit) return Version_Number;
   procedure Unit_Reparse_From_File (Unit : Internal_Unit; Charset : String);
   procedure Unit_Reparse_From_Buffer
     (Unit : Internal_Unit; Buffer : String; Charset : String);
   function Unit_Filename (Unit : Internal_Unit) return String;
   function Unit_Charset (Unit : Internal_Unit) return String;
   function Unit_Diagnostics (Unit : Internal_Unit) return Diagnostics_Access;
   function Unit_Format_GNU_Diagnostic
     (Unit : Internal_Unit; D : Diagnostic) return String;
   function Unit_Root (Unit : Internal_Unit) return Internal_Node;
   function Unit_First_Token (Unit : Internal_Unit) return Internal_Token;
   function Unit_Last_Token (Unit : Internal_Unit) return Internal_Token;
   function Unit_Lookup_Token
     (Unit : Internal_Unit; Sloc : Source_Location) return Internal_Token;
   function Unit_Token_Count (Unit : Internal_Unit) return Natural;
   function Unit_Trivia_Count (Unit : Internal_Unit) return Natural;
   function Unit_Get_Line
     (Unit : Internal_Unit; Line_Number : Positive) return Text_Type;

   type Internal_Node_Metadata_Type is record
      Ref_Count : Natural;
      Internal  : Implementation.Internal_Metadata;
   end record;
   type Internal_Node_Metadata_Access is
      access all Internal_Node_Metadata_Type;

   function "+" is new Ada.Unchecked_Conversion
     (Internal_Node_Metadata, Internal_Node_Metadata_Access);
   function "+" is new Ada.Unchecked_Conversion
     (Internal_Node_Metadata_Access, Internal_Node_Metadata);

   procedure Node_Metadata_Inc_Ref (Metadata : Internal_Node_Metadata);
   procedure Node_Metadata_Dec_Ref (Metadata : in out Internal_Node_Metadata);
   function Node_Metadata_Compare
     (L, R : Internal_Node_Metadata) return Boolean;

   function Node_Unit (Node : Internal_Node) return Internal_Unit;
   function Node_Kind (Node : Internal_Node) return Type_Index;
   function Node_Parent (Node : Internal_Entity) return Internal_Entity;
   function Node_Parents
     (Node : Internal_Entity; With_Self : Boolean) return Internal_Entity_Array;
   function Node_Children_Count (Node : Internal_Node) return Natural;
   procedure Node_Get_Child
     (Node            : Internal_Node;
      Index           : Positive;
      Index_In_Bounds : out Boolean;
      Result          : out Internal_Node);
   function Node_Fetch_Sibling
     (Node : Internal_Node; Offset : Integer) return Internal_Node;
   function Node_Is_Ghost (Node : Analysis.Internal_Node) return Boolean;
   function Node_Token_Start (Node : Internal_Node) return Internal_Token;
   function Node_Token_End (Node : Internal_Node) return Internal_Token;
   function Node_Text (Node : Internal_Node) return Text_Type;
   function Node_Sloc_Range
     (Node : Internal_Node) return Source_Location_Range;
   function Node_Lookup
     (Node : Analysis.Internal_Node;
      Sloc : Source_Location) return Analysis.Internal_Node;
   function Node_Last_Attempted_Child (Node : Internal_Node) return Integer;
   function Node_Children_And_Trivia
     (Node : Internal_Node) return Node_Or_Token_Array_Access;

   function Entity_Image (Entity : Internal_Entity) return String;

   function Token_Is_Equivalent
     (Left, Right       : Internal_Token;
      Left_SN, Right_SN : Token_Safety_Net) return Boolean;

   --  Language descriptor table for Libadalang.
   --
   --  We define it here and export its address to avoid making the
   --  $.Generic_API spec (which is public) depend on other implementation
   --  units, which allows not exporting the many symbols from the private
   --  units when building a shared library (Windows has a small limit for the
   --  number of exported symbols).

   Language_Name : aliased constant Text_Type :=
     "Ada";

   No_Metadata_Value : aliased Internal_Node_Metadata_Type :=
     (0, Implementation.No_Metadata);
   No_Metadata       : Internal_Node_Metadata_Access :=
     No_Metadata_Value'Access;

   Desc : aliased constant Language_Descriptor :=
     (Language_Name => Language_Name'Access,

      Default_Grammar_Rule => 107,
      Grammar_Rules        => Grammar_Rules'Access,

      Token_Kinds        => Token_Kind_Descriptors'Access,
      Token_Family_Names => Token_Family_Names'Access,

      Types          => Generic_Introspection.Types'Access,
      Enum_Types     => Generic_Introspection.Enum_Types'Access,
      Array_Types    => Generic_Introspection.Array_Types'Access,
      Iterator_Types => Generic_Introspection.Iterator_Types'Access,
      Struct_Types   => Generic_Introspection.Struct_Types'Access,
      Builtin_Types  => Generic_Introspection.Builtin_Types'Access,
      First_Node     => Generic_Introspection.First_Node,
      Struct_Members => Generic_Introspection.Struct_Members'Access,
      First_Property => Generic_Introspection.First_Property,
      Unparsers      => Libadalang.Unparsers.Unparsers'Access,

      Create_Context          => Create_Context'Access,
      Context_Inc_Ref         => Context_Inc_Ref'Access,
      Context_Dec_Ref         => Context_Dec_Ref'Access,
      Context_Version         => Context_Version'Access,
      Context_Has_With_Trivia => Context_Has_With_Trivia'Access,
      Context_Has_Unit        => Context_Has_Unit'Access,
      Context_Get_From_File   => Context_Get_From_File'Access,
      Context_Get_From_Buffer => Context_Get_From_Buffer'Access,

      Unit_Context               => Unit_Context'Access,
      Unit_Version               => Unit_Version'Access,
      Unit_Reparse_From_File     => Unit_Reparse_From_File'Access,
      Unit_Reparse_From_Buffer   => Unit_Reparse_From_Buffer'Access,
      Unit_Filename              => Unit_Filename'Access,
      Unit_Charset               => Unit_Charset'Access,
      Unit_Diagnostics           => Unit_Diagnostics'Access,
      Unit_Format_GNU_Diagnostic => Unit_Format_GNU_Diagnostic'Access,
      Unit_Root                  => Unit_Root'Access,
      Unit_First_Token           => Unit_First_Token'Access,
      Unit_Last_Token            => Unit_Last_Token'Access,
      Unit_Lookup_Token          => Unit_Lookup_Token'Access,
      Unit_Token_Count           => Unit_Token_Count'Access,
      Unit_Trivia_Count          => Unit_Trivia_Count'Access,
      Unit_Get_Line              => Unit_Get_Line'Access,

      Node_Metadata_Inc_Ref => Node_Metadata_Inc_Ref'Access,
      Node_Metadata_Dec_Ref => Node_Metadata_Dec_Ref'Access,
      Node_Metadata_Compare => Node_Metadata_Compare'Access,
      Null_Metadata         => +No_Metadata,

      Node_Unit                 => Node_Unit'Access,
      Node_Kind                 => Node_Kind'Access,
      Node_Parent               => Node_Parent'Access,
      Node_Parents              => Node_Parents'Access,
      Node_Children_Count       => Node_Children_Count'Access,
      Node_Get_Child            => Node_Get_Child'Access,
      Node_Fetch_Sibling        => Node_Fetch_Sibling'Access,
      Node_Is_Ghost             => Node_Is_Ghost'Access,
      Node_Token_Start          => Node_Token_Start'Access,
      Node_Token_End            => Node_Token_End'Access,
      Node_Text                 => Node_Text'Access,
      Node_Sloc_Range           => Node_Sloc_Range'Access,
      Node_Lookup               => Node_Lookup'Access,
      Node_Last_Attempted_Child => Node_Last_Attempted_Child'Access,
      Node_Children_And_Trivia  => Node_Children_And_Trivia'Access,

      Entity_Image => Entity_Image'Access,

      Token_Is_Equivalent => Token_Is_Equivalent'Access,

      Create_Enum      => Create_Enum'Access,
      Create_Array     => Create_Array'Access,
      Create_Struct    => Create_Struct'Access,
      Eval_Node_Member => Eval_Node_Member'Access,
      Is_Managed_Error => Implementation.Properties_May_Raise'Access);

end Libadalang.Generic_Impl;
