; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define double @copysign_f64(double %a, double %b) {
; CHECK-LABEL: copysign_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v2.2d, #0xffffffffffffffff
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    fneg v2.2d, v2.2d
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.copysign.f64(double %a, double %b)
  ret double %c
}

define float @copysign_f32(float %a, float %b) {
; CHECK-SD-LABEL: copysign_f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-SD-NEXT:    // kill: def $s1 killed $s1 def $q1
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: copysign_f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mvni v2.2s, #128, lsl #24
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 def $d0
; CHECK-GI-NEXT:    // kill: def $s1 killed $s1 def $d1
; CHECK-GI-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    // kill: def $s0 killed $s0 killed $d0
; CHECK-GI-NEXT:    ret
entry:
  %c = call float @llvm.copysign.f32(float %a, float %b)
  ret float %c
}

define half @copysign_f16(half %a, half %b) {
; CHECK-SD-LABEL: copysign_f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fcvt s1, h1
; CHECK-SD-NEXT:    fcvt s0, h0
; CHECK-SD-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    fcvt h0, s0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: copysign_f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mvni v2.4h, #128, lsl #8
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 def $d0
; CHECK-GI-NEXT:    // kill: def $h1 killed $h1 def $d1
; CHECK-GI-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-GI-NEXT:    // kill: def $h0 killed $h0 killed $d0
; CHECK-GI-NEXT:    ret
entry:
  %c = call half @llvm.copysign.f16(half %a, half %b)
  ret half %c
}

define <2 x double> @copysign_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: copysign_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v2.2d, #0xffffffffffffffff
; CHECK-NEXT:    fneg v2.2d, v2.2d
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.copysign.v2f64(<2 x double> %a, <2 x double> %b)
  ret <2 x double> %c
}

define <3 x double> @copysign_v3f64(<3 x double> %a, <3 x double> %b) {
; CHECK-SD-LABEL: copysign_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    movi v6.2d, #0xffffffffffffffff
; CHECK-SD-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    // kill: def $d5 killed $d5 def $q5
; CHECK-SD-NEXT:    mov v3.d[1], v4.d[0]
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    fneg v1.2d, v6.2d
; CHECK-SD-NEXT:    bif v0.16b, v3.16b, v1.16b
; CHECK-SD-NEXT:    bif v2.16b, v5.16b, v1.16b
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: copysign_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    movi v6.2d, #0xffffffffffffffff
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-GI-NEXT:    // kill: def $d4 killed $d4 def $q4
; CHECK-GI-NEXT:    fmov x8, d2
; CHECK-GI-NEXT:    fmov x9, d5
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    mov v3.d[1], v4.d[0]
; CHECK-GI-NEXT:    and x8, x8, #0x7fffffffffffffff
; CHECK-GI-NEXT:    and x9, x9, #0x8000000000000000
; CHECK-GI-NEXT:    fneg v1.2d, v6.2d
; CHECK-GI-NEXT:    orr x8, x8, x9
; CHECK-GI-NEXT:    fmov d2, x8
; CHECK-GI-NEXT:    bif v0.16b, v3.16b, v1.16b
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.copysign.v3f64(<3 x double> %a, <3 x double> %b)
  ret <3 x double> %c
}

define <4 x double> @copysign_v4f64(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: copysign_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v4.2d, #0xffffffffffffffff
; CHECK-NEXT:    fneg v4.2d, v4.2d
; CHECK-NEXT:    bif v0.16b, v2.16b, v4.16b
; CHECK-NEXT:    bif v1.16b, v3.16b, v4.16b
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.copysign.v4f64(<4 x double> %a, <4 x double> %b)
  ret <4 x double> %c
}

define <2 x float> @copysign_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: copysign_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mvni v2.2s, #128, lsl #24
; CHECK-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.copysign.v2f32(<2 x float> %a, <2 x float> %b)
  ret <2 x float> %c
}

define <3 x float> @copysign_v3f32(<3 x float> %a, <3 x float> %b) {
; CHECK-SD-LABEL: copysign_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: copysign_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, #-2147483648 // =0x80000000
; CHECK-GI-NEXT:    mov w9, #2147483647 // =0x7fffffff
; CHECK-GI-NEXT:    fmov s2, w9
; CHECK-GI-NEXT:    fmov s3, w8
; CHECK-GI-NEXT:    mov v2.s[1], w9
; CHECK-GI-NEXT:    mov v3.s[1], w8
; CHECK-GI-NEXT:    mov v2.s[2], w9
; CHECK-GI-NEXT:    mov v3.s[2], w8
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v3.16b
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.copysign.v3f32(<3 x float> %a, <3 x float> %b)
  ret <3 x float> %c
}

define <4 x float> @copysign_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: copysign_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mvni v2.4s, #128, lsl #24
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.copysign.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define <8 x float> @copysign_v8f32(<8 x float> %a, <8 x float> %b) {
; CHECK-LABEL: copysign_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mvni v4.4s, #128, lsl #24
; CHECK-NEXT:    bif v0.16b, v2.16b, v4.16b
; CHECK-NEXT:    bif v1.16b, v3.16b, v4.16b
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.copysign.v8f32(<8 x float> %a, <8 x float> %b)
  ret <8 x float> %c
}

define <7 x half> @copysign_v7f16(<7 x half> %a, <7 x half> %b) {
; CHECK-SD-LABEL: copysign_v7f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mvni v2.8h, #128, lsl #8
; CHECK-SD-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: copysign_v7f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov w8, #32768 // =0x8000
; CHECK-GI-NEXT:    mov w9, #32767 // =0x7fff
; CHECK-GI-NEXT:    fmov s2, w9
; CHECK-GI-NEXT:    fmov s3, w8
; CHECK-GI-NEXT:    mov v4.16b, v2.16b
; CHECK-GI-NEXT:    mov v5.16b, v3.16b
; CHECK-GI-NEXT:    mov v4.h[1], v2.h[0]
; CHECK-GI-NEXT:    mov v5.h[1], v3.h[0]
; CHECK-GI-NEXT:    mov v4.h[2], v2.h[0]
; CHECK-GI-NEXT:    mov v5.h[2], v3.h[0]
; CHECK-GI-NEXT:    mov v4.h[3], v2.h[0]
; CHECK-GI-NEXT:    mov v5.h[3], v3.h[0]
; CHECK-GI-NEXT:    mov v4.h[4], v2.h[0]
; CHECK-GI-NEXT:    mov v5.h[4], v3.h[0]
; CHECK-GI-NEXT:    mov v4.h[5], v2.h[0]
; CHECK-GI-NEXT:    mov v5.h[5], v3.h[0]
; CHECK-GI-NEXT:    mov v4.h[6], v2.h[0]
; CHECK-GI-NEXT:    mov v5.h[6], v3.h[0]
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v4.16b
; CHECK-GI-NEXT:    and v1.16b, v1.16b, v5.16b
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.copysign.v7f16(<7 x half> %a, <7 x half> %b)
  ret <7 x half> %c
}

define <4 x half> @copysign_v4f16(<4 x half> %a, <4 x half> %b) {
; CHECK-LABEL: copysign_v4f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mvni v2.4h, #128, lsl #8
; CHECK-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.copysign.v4f16(<4 x half> %a, <4 x half> %b)
  ret <4 x half> %c
}

define <8 x half> @copysign_v8f16(<8 x half> %a, <8 x half> %b) {
; CHECK-LABEL: copysign_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mvni v2.8h, #128, lsl #8
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.copysign.v8f16(<8 x half> %a, <8 x half> %b)
  ret <8 x half> %c
}

define <16 x half> @copysign_v16f16(<16 x half> %a, <16 x half> %b) {
; CHECK-LABEL: copysign_v16f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mvni v4.8h, #128, lsl #8
; CHECK-NEXT:    bif v0.16b, v2.16b, v4.16b
; CHECK-NEXT:    bif v1.16b, v3.16b, v4.16b
; CHECK-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.copysign.v16f16(<16 x half> %a, <16 x half> %b)
  ret <16 x half> %c
}

declare <16 x half> @llvm.copysign.v16f16(<16 x half>, <16 x half>)
declare <2 x double> @llvm.copysign.v2f64(<2 x double>, <2 x double>)
declare <2 x float> @llvm.copysign.v2f32(<2 x float>, <2 x float>)
declare <3 x double> @llvm.copysign.v3f64(<3 x double>, <3 x double>)
declare <3 x float> @llvm.copysign.v3f32(<3 x float>, <3 x float>)
declare <4 x double> @llvm.copysign.v4f64(<4 x double>, <4 x double>)
declare <4 x float> @llvm.copysign.v4f32(<4 x float>, <4 x float>)
declare <4 x half> @llvm.copysign.v4f16(<4 x half>, <4 x half>)
declare <7 x half> @llvm.copysign.v7f16(<7 x half>, <7 x half>)
declare <8 x float> @llvm.copysign.v8f32(<8 x float>, <8 x float>)
declare <8 x half> @llvm.copysign.v8f16(<8 x half>, <8 x half>)
declare double @llvm.copysign.f64(double, double)
declare float @llvm.copysign.f32(float, float)
declare half @llvm.copysign.f16(half, half)
