; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=infer-address-spaces -assume-default-is-flat-addrspace %s | FileCheck %s

define void @double_ascast(<4 x ptr addrspace(3)> %input) {
; CHECK-LABEL: define void @double_ascast
; CHECK-SAME: (<4 x ptr addrspace(3)> [[INPUT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @use(<4 x ptr addrspace(3)> [[INPUT]])
; CHECK-NEXT:    ret void
;
entry:
  %tmp0 = addrspacecast <4 x ptr addrspace(3)> %input to <4 x ptr>
  %tmp1 = addrspacecast <4 x ptr> %tmp0 to <4 x ptr addrspace(3)>
  call void @use(<4 x ptr addrspace(3)> %tmp1)
  ret void
}

define void @double_gep(ptr addrspace(3) %input, <4 x i64> %i, i64 %j) {
; CHECK-LABEL: define void @double_gep
; CHECK-SAME: (ptr addrspace(3) [[INPUT:%.*]], <4 x i64> [[I:%.*]], i64 [[J:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr float, ptr addrspace(3) [[INPUT]], <4 x i64> [[I]]
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr float, <4 x ptr addrspace(3)> [[TMP1]], i64 [[J]]
; CHECK-NEXT:    call void @use(<4 x ptr addrspace(3)> [[TMP2]])
; CHECK-NEXT:    ret void
;
entry:
  %tmp0 = addrspacecast ptr addrspace(3) %input to ptr
  %tmp1 = getelementptr float, ptr %tmp0, <4 x i64> %i
  %tmp2 = getelementptr float, <4 x ptr> %tmp1, i64 %j
  %tmp3 = addrspacecast <4 x ptr> %tmp2 to <4 x ptr addrspace(3)>
  call void @use(<4 x ptr addrspace(3)> %tmp3)
  ret void
}

define void @inferas_phi(<4 x ptr addrspace(3)> %input, i1 %cond) {
; CHECK-LABEL: define void @inferas_phi
; CHECK-SAME: (<4 x ptr addrspace(3)> [[INPUT:%.*]], i1 [[COND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND]], label [[INC:%.*]], label [[END:%.*]]
; CHECK:       inc:
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr float, <4 x ptr addrspace(3)> [[INPUT]], i64 1
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[TMP2:%.*]] = phi <4 x ptr addrspace(3)> [ [[INPUT]], [[ENTRY:%.*]] ], [ [[TMP1]], [[INC]] ]
; CHECK-NEXT:    call void @use(<4 x ptr addrspace(3)> [[TMP2]])
; CHECK-NEXT:    ret void
;
entry:
  %tmp0 = addrspacecast <4 x ptr addrspace(3)> %input to <4 x ptr>
  br i1 %cond, label %inc, label %end

inc:
  %tmp1 = getelementptr float, <4 x ptr> %tmp0, i64 1
  br label %end

end:
  %tmp2 = phi <4 x ptr> [ %tmp0, %entry ], [ %tmp1, %inc ]
  %tmp3 = addrspacecast <4 x ptr> %tmp2 to <4 x ptr addrspace(3)>
  call void @use(<4 x ptr addrspace(3)> %tmp3)
  ret void
}

define void @inferas_ptr2int2ptr(<4 x ptr addrspace(3)> %input) {
; CHECK-LABEL: define void @inferas_ptr2int2ptr
; CHECK-SAME: (<4 x ptr addrspace(3)> [[INPUT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @use(<4 x ptr addrspace(3)> [[INPUT]])
; CHECK-NEXT:    ret void
;
entry:
  %tmp0 = addrspacecast <4 x ptr addrspace(3)> %input to <4 x ptr>
  %tmp1 = ptrtoint <4 x ptr> %tmp0 to <4 x i64>
  %tmp2 = inttoptr <4 x i64> %tmp1 to <4 x ptr>
  %tmp3 = addrspacecast <4 x ptr> %tmp2 to <4 x ptr addrspace(3)>
  call void @use(<4 x ptr addrspace(3)> %tmp3)
  ret void
}

define void @inferas_loop(<4 x ptr addrspace(3)> %begin, <4 x ptr addrspace(3)> %end) {
; CHECK-LABEL: define void @inferas_loop
; CHECK-SAME: (<4 x ptr addrspace(3)> [[BEGIN:%.*]], <4 x ptr addrspace(3)> [[END:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[NOW:%.*]] = phi <4 x ptr addrspace(3)> [ [[BEGIN]], [[ENTRY:%.*]] ], [ [[NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    call void @use(<4 x ptr addrspace(3)> [[NOW]])
; CHECK-NEXT:    [[NEXT]] = getelementptr float, <4 x ptr addrspace(3)> [[NOW]], i64 1
; CHECK-NEXT:    [[VEQ:%.*]] = icmp eq <4 x ptr addrspace(3)> [[NEXT]], [[END]]
; CHECK-NEXT:    [[MASK:%.*]] = bitcast <4 x i1> [[VEQ]] to i4
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i4 [[MASK]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %begin0 = addrspacecast <4 x ptr addrspace(3)> %begin to <4 x ptr>
  %end0 = addrspacecast <4 x ptr addrspace(3)> %end to <4 x ptr>
  br label %loop

loop:
  %now = phi <4 x ptr> [ %begin0, %entry ], [ %next, %loop ]
  %now3 = addrspacecast <4 x ptr> %now to <4 x ptr addrspace(3)>
  call void @use(<4 x ptr addrspace(3)> %now3)
  %next = getelementptr float, <4 x ptr> %now, i64 1
  %veq = icmp eq <4 x ptr> %next, %end0
  %mask = bitcast <4 x i1> %veq to i4
  %cond = icmp eq i4 %mask, 0
  br i1 %cond, label %loop, label %exit

exit:
  ret void
}

declare void @use(<4 x ptr addrspace(3)>)
