; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -passes=jump-threading %s | FileCheck %s

; Value of predicate known on all inputs (trivial case)
; Note: InstCombine/EarlyCSE would also get this case
define void @test(ptr %p, ptr %addr) {
; CHECK-LABEL: define void @test
; CHECK-SAME: (ptr [[P:%.*]], ptr [[ADDR:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP0:%.*]] = icmp eq ptr [[P]], null
; CHECK-NEXT:    br i1 [[CMP0]], label [[EXIT:%.*]], label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[P1:%.*]] = phi ptr [ [[P]], [[ENTRY:%.*]] ], [ [[P1]], [[LOOP]] ]
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %cmp0 = icmp eq ptr %p, null
  br i1 %cmp0, label %exit, label %loop
loop:
  %p1 = phi ptr [%p, %entry], [%p1, %loop]
  %cmp1 = icmp eq ptr %p1, null
  br i1 %cmp1, label %exit, label %loop
exit:
  ret void
}

; Value of predicate known on all inputs (non-trivial)
define void @test2(ptr %p) {
; CHECK-LABEL: define void @test2
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP0:%.*]] = icmp eq ptr [[P]], null
; CHECK-NEXT:    br i1 [[CMP0]], label [[EXIT:%.*]], label [[BACKEDGE:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[P1:%.*]] = phi ptr [ [[P]], [[ENTRY:%.*]] ], [ [[P2:%.*]], [[BACKEDGE]] ]
; CHECK-NEXT:    [[P2]] = load ptr, ptr [[P1]], align 8
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq ptr [[P2]], null
; CHECK-NEXT:    br i1 [[CMP2]], label [[EXIT]], label [[BACKEDGE]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %cmp0 = icmp eq ptr %p, null
  br i1 %cmp0, label %exit, label %loop
loop:
  %p1 = phi ptr [%p, %entry], [%p2, %backedge]
  %cmp1 = icmp eq ptr %p1, null
  br i1 %cmp1, label %exit, label %backedge
backedge:
  %p2 = load ptr, ptr %p1
  %cmp2 = icmp eq ptr %p2, null
  br i1 %cmp2, label %exit, label %loop
exit:
  ret void
}

; If the inputs don't branch the same way, we can't rewrite
; Well, we could unroll this loop exactly twice, but that's
; a different transform.
define void @test_mixed(ptr %p) {
; CHECK-LABEL: define void @test_mixed
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP0:%.*]] = icmp eq ptr [[P]], null
; CHECK-NEXT:    br i1 [[CMP0]], label [[EXIT:%.*]], label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %cmp0 = icmp eq ptr %p, null
  br i1 %cmp0, label %exit, label %loop
loop:
  %p1 = phi ptr [%p, %entry], [%p1, %loop]
  %cmp1 = icmp ne ptr %p1, null
  br i1 %cmp1, label %exit, label %loop
exit:
  ret void
}

; The eq predicate is always true if we go through the path from
; L1 to L3, no matter the phi result %t5 is on the lhs or rhs of
; the predicate.
declare void @goo()
declare void @hoo()

define void @test3(i32 %m, ptr %t1) {
; CHECK-LABEL: define void @test3
; CHECK-SAME: (i32 [[M:%.*]], ptr [[T1:%.*]]) {
; CHECK-NEXT:  L1:
; CHECK-NEXT:    [[T0:%.*]] = add i32 [[M]], 7
; CHECK-NEXT:    [[T2:%.*]] = load ptr, ptr [[T1]], align 8
; CHECK-NEXT:    [[T3:%.*]] = icmp eq ptr [[T2]], null
; CHECK-NEXT:    br i1 [[T3]], label [[L4:%.*]], label [[L3:%.*]]
; CHECK:       L3:
; CHECK-NEXT:    [[T4:%.*]] = load i32, ptr [[T2]], align 4
; CHECK-NEXT:    [[T6:%.*]] = icmp eq i32 [[T0]], [[T4]]
; CHECK-NEXT:    br i1 [[T6]], label [[L4]], label [[L5:%.*]]
; CHECK:       L4:
; CHECK-NEXT:    call void @goo()
; CHECK-NEXT:    ret void
; CHECK:       L5:
; CHECK-NEXT:    call void @hoo()
; CHECK-NEXT:    ret void
;
L1:
  %t0 = add i32 %m, 7
  %t2 = load ptr, ptr %t1, align 8

  %t3 = icmp eq ptr %t2, null
  br i1 %t3, label %L3, label %L2

L2:
  %t4 = load i32, ptr %t2, align 4
  br label %L3

L3:
  %t5 = phi i32 [ %t0, %L1 ], [ %t4, %L2 ]
  %t6 = icmp eq i32 %t0, %t5
  br i1 %t6, label %L4, label %L5

L4:
  call void @goo()
  ret void

L5:
  call void @hoo()
  ret void
}
