; NOTE: Assertions have been autogenerated by utils/update_test_checks.py

; The tests in this file check that we do not simplify based on metadata that is
; not available on all code paths.

; RUN: opt < %s -S -passes=newgvn | FileCheck %s

define i1 @test1(ptr %arg, i1 %arg2) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    br i1 [[ARG2:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LOAD1:%.*]] = load ptr, ptr [[ARG:%.*]], align 8, !nonnull [[META0:![0-9]+]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq ptr [[LOAD1]], null
; CHECK-NEXT:    ret i1 [[CMP1]]
; CHECK:       bb2:
; CHECK-NEXT:    [[LOAD2:%.*]] = load ptr, ptr [[ARG]], align 8
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq ptr [[LOAD2]], null
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  br i1 %arg2, label %bb1, label %bb2

bb1:
  %load1 = load ptr, ptr %arg, !nonnull !0
  %cmp1 = icmp eq ptr %load1, null
  ret i1 %cmp1

bb2:
  %load2 = load ptr, ptr %arg
  %cmp2 = icmp eq ptr %load2, null
  ret i1 %cmp2
}

define i1 @test2(ptr %arg, i1 %arg2) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    br i1 [[ARG2:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LOAD1:%.*]] = load ptr, ptr [[ARG:%.*]], align 8
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq ptr [[LOAD1]], null
; CHECK-NEXT:    ret i1 [[CMP1]]
; CHECK:       bb2:
; CHECK-NEXT:    [[LOAD2:%.*]] = load ptr, ptr [[ARG]], align 8, !nonnull [[META0]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq ptr [[LOAD2]], null
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  br i1 %arg2, label %bb1, label %bb2

bb1:
  %load1 = load ptr, ptr %arg
  %cmp1 = icmp eq ptr %load1, null
  ret i1 %cmp1

bb2:
  %load2 = load ptr, ptr %arg, !nonnull !0
  %cmp2 = icmp eq ptr %load2, null
  ret i1 %cmp2
}


define i1 @test3(ptr %ptr, i1 %arg2) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    br i1 [[ARG2:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LOAD1:%.*]] = load i32, ptr [[PTR:%.*]], align 4, !range [[RNG1:![0-9]+]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[LOAD1]], 999
; CHECK-NEXT:    ret i1 [[CMP1]]
; CHECK:       bb2:
; CHECK-NEXT:    [[LOAD2:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ne i32 [[LOAD2]], 999
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  br i1 %arg2, label %bb1, label %bb2

bb1:
  %load1 = load i32, ptr %ptr, !range !1
  %cmp1 = icmp ne i32 %load1, 999
  ret i1 %cmp1

bb2:
  %load2 = load i32, ptr %ptr
  %cmp2 = icmp ne i32 %load2, 999
  ret i1 %cmp2
}

define i1 @test4(ptr %ptr, i1 %arg2) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    br i1 [[ARG2:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LOAD1:%.*]] = load i32, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[LOAD1]], 999
; CHECK-NEXT:    ret i1 [[CMP1]]
; CHECK:       bb2:
; CHECK-NEXT:    [[LOAD2:%.*]] = load i32, ptr [[PTR]], align 4, !range [[RNG1]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ne i32 [[LOAD2]], 999
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  br i1 %arg2, label %bb1, label %bb2

bb1:
  %load1 = load i32, ptr %ptr
  %cmp1 = icmp ne i32 %load1, 999
  ret i1 %cmp1

bb2:
  %load2 = load i32, ptr %ptr, !range !1
  %cmp2 = icmp ne i32 %load2, 999
  ret i1 %cmp2
}

define i1 @test5(ptr %ptr, i1 %arg2) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    br i1 [[ARG2:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LOAD1:%.*]] = load i32, ptr [[PTR:%.*]], align 4, !range [[RNG1]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[LOAD1]], 999
; CHECK-NEXT:    ret i1 [[CMP1]]
; CHECK:       bb2:
; CHECK-NEXT:    [[LOAD2:%.*]] = load i32, ptr [[PTR]], align 4
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[LOAD2]], 999
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  br i1 %arg2, label %bb1, label %bb2

bb1:
  %load1 = load i32, ptr %ptr, !range !1
  %cmp1 = icmp slt i32 %load1, 999
  ret i1 %cmp1

bb2:
  %load2 = load i32, ptr %ptr
  %cmp2 = icmp slt i32 %load2, 999
  ret i1 %cmp2
}

define i1 @test6(ptr %ptr, i1 %arg2) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    br i1 [[ARG2:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[LOAD1:%.*]] = load i32, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i32 [[LOAD1]], 999
; CHECK-NEXT:    ret i1 [[CMP1]]
; CHECK:       bb2:
; CHECK-NEXT:    [[LOAD2:%.*]] = load i32, ptr [[PTR]], align 4, !range [[RNG1]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[LOAD2]], 999
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  br i1 %arg2, label %bb1, label %bb2

bb1:
  %load1 = load i32, ptr %ptr
  %cmp1 = icmp slt i32 %load1, 999
  ret i1 %cmp1

bb2:
  %load2 = load i32, ptr %ptr, !range !1
  %cmp2 = icmp slt i32 %load2, 999
  ret i1 %cmp2
}

!0 = !{}
!1 = !{ i32 10, i32 20 }
