; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-NOFP16
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-FP16
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-NOFP16
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-FP16

define double @ceil_f64(double %a) {
; CHECK-LABEL: ceil_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.ceil.f64(double %a)
  ret double %c
}

define float @ceil_f32(float %a) {
; CHECK-LABEL: ceil_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.ceil.f32(float %a)
  ret float %c
}

define half @ceil_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: ceil_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    frintp s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ceil_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintp h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: ceil_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    frintp s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ceil_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintp h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.ceil.f16(half %a)
  ret half %c
}

define <2 x double> @ceil_v2f64(<2 x double> %a) {
; CHECK-LABEL: ceil_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.ceil.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @ceil_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: ceil_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    frintp v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    frintp v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ceil_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    frintp d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    frintp v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.ceil.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @ceil_v4f64(<4 x double> %a) {
; CHECK-LABEL: ceil_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp v0.2d, v0.2d
; CHECK-NEXT:    frintp v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.ceil.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @ceil_v2f32(<2 x float> %a) {
; CHECK-LABEL: ceil_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.ceil.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @ceil_v3f32(<3 x float> %a) {
; CHECK-LABEL: ceil_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.ceil.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @ceil_v4f32(<4 x float> %a) {
; CHECK-LABEL: ceil_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.ceil.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @ceil_v8f32(<8 x float> %a) {
; CHECK-LABEL: ceil_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintp v0.4s, v0.4s
; CHECK-NEXT:    frintp v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.ceil.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @ceil_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: ceil_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintp v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintp v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ceil_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintp v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: ceil_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    frintp v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    frintp v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ceil_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintp v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.ceil.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @ceil_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: ceil_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    frintp v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ceil_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintp v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: ceil_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    frintp v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ceil_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintp v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.ceil.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @ceil_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: ceil_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintp v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintp v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ceil_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintp v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: ceil_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    frintp v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    frintp v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ceil_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintp v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.ceil.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @ceil_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: ceil_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-NOFP16-NEXT:    frintp v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintp v1.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    frintp v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintp v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ceil_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintp v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    frintp v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: ceil_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    frintp v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    frintp v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    frintp v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    frintp v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ceil_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintp v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    frintp v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.ceil.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @floor_f64(double %a) {
; CHECK-LABEL: floor_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.floor.f64(double %a)
  ret double %c
}

define float @floor_f32(float %a) {
; CHECK-LABEL: floor_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.floor.f32(float %a)
  ret float %c
}

define half @floor_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: floor_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    frintm s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: floor_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintm h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: floor_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    frintm s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: floor_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintm h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.floor.f16(half %a)
  ret half %c
}

define <2 x double> @floor_v2f64(<2 x double> %a) {
; CHECK-LABEL: floor_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.floor.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @floor_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: floor_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    frintm v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    frintm v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: floor_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    frintm d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    frintm v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.floor.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @floor_v4f64(<4 x double> %a) {
; CHECK-LABEL: floor_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm v0.2d, v0.2d
; CHECK-NEXT:    frintm v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.floor.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @floor_v2f32(<2 x float> %a) {
; CHECK-LABEL: floor_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.floor.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @floor_v3f32(<3 x float> %a) {
; CHECK-LABEL: floor_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.floor.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @floor_v4f32(<4 x float> %a) {
; CHECK-LABEL: floor_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.floor.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @floor_v8f32(<8 x float> %a) {
; CHECK-LABEL: floor_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintm v0.4s, v0.4s
; CHECK-NEXT:    frintm v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.floor.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @floor_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: floor_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintm v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintm v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: floor_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintm v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: floor_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    frintm v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    frintm v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: floor_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintm v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.floor.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @floor_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: floor_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    frintm v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: floor_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintm v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: floor_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    frintm v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: floor_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintm v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.floor.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @floor_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: floor_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintm v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintm v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: floor_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintm v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: floor_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    frintm v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    frintm v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: floor_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintm v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.floor.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @floor_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: floor_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-NOFP16-NEXT:    frintm v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintm v1.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    frintm v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintm v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: floor_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintm v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    frintm v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: floor_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    frintm v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    frintm v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    frintm v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    frintm v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: floor_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintm v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    frintm v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.floor.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @nearbyint_f64(double %a) {
; CHECK-LABEL: nearbyint_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.nearbyint.f64(double %a)
  ret double %c
}

define float @nearbyint_f32(float %a) {
; CHECK-LABEL: nearbyint_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.nearbyint.f32(float %a)
  ret float %c
}

define half @nearbyint_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: nearbyint_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    frinti s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: nearbyint_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinti h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: nearbyint_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    frinti s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: nearbyint_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinti h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.nearbyint.f16(half %a)
  ret half %c
}

define <2 x double> @nearbyint_v2f64(<2 x double> %a) {
; CHECK-LABEL: nearbyint_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.nearbyint.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @nearbyint_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: nearbyint_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    frinti v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    frinti v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: nearbyint_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    frinti d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    frinti v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.nearbyint.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @nearbyint_v4f64(<4 x double> %a) {
; CHECK-LABEL: nearbyint_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti v0.2d, v0.2d
; CHECK-NEXT:    frinti v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.nearbyint.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @nearbyint_v2f32(<2 x float> %a) {
; CHECK-LABEL: nearbyint_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.nearbyint.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @nearbyint_v3f32(<3 x float> %a) {
; CHECK-LABEL: nearbyint_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.nearbyint.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @nearbyint_v4f32(<4 x float> %a) {
; CHECK-LABEL: nearbyint_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @nearbyint_v8f32(<8 x float> %a) {
; CHECK-LABEL: nearbyint_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinti v0.4s, v0.4s
; CHECK-NEXT:    frinti v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.nearbyint.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @nearbyint_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: nearbyint_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frinti v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frinti v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: nearbyint_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinti v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: nearbyint_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    frinti v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    frinti v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: nearbyint_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinti v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.nearbyint.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @nearbyint_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: nearbyint_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    frinti v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: nearbyint_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinti v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: nearbyint_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    frinti v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: nearbyint_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinti v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.nearbyint.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @nearbyint_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: nearbyint_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frinti v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frinti v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: nearbyint_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinti v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: nearbyint_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    frinti v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    frinti v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: nearbyint_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinti v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.nearbyint.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @nearbyint_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: nearbyint_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-NOFP16-NEXT:    frinti v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    frinti v1.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    frinti v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    frinti v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: nearbyint_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinti v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    frinti v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: nearbyint_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    frinti v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    frinti v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    frinti v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    frinti v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: nearbyint_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinti v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    frinti v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.nearbyint.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @roundeven_f64(double %a) {
; CHECK-LABEL: roundeven_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.roundeven.f64(double %a)
  ret double %c
}

define float @roundeven_f32(float %a) {
; CHECK-LABEL: roundeven_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.roundeven.f32(float %a)
  ret float %c
}

define half @roundeven_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: roundeven_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    frintn s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: roundeven_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintn h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: roundeven_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    frintn s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: roundeven_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintn h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.roundeven.f16(half %a)
  ret half %c
}

define <2 x double> @roundeven_v2f64(<2 x double> %a) {
; CHECK-LABEL: roundeven_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.roundeven.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @roundeven_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: roundeven_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    frintn v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    frintn v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: roundeven_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    frintn d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    frintn v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.roundeven.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @roundeven_v4f64(<4 x double> %a) {
; CHECK-LABEL: roundeven_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn v0.2d, v0.2d
; CHECK-NEXT:    frintn v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.roundeven.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @roundeven_v2f32(<2 x float> %a) {
; CHECK-LABEL: roundeven_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.roundeven.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @roundeven_v3f32(<3 x float> %a) {
; CHECK-LABEL: roundeven_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.roundeven.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @roundeven_v4f32(<4 x float> %a) {
; CHECK-LABEL: roundeven_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.roundeven.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @roundeven_v8f32(<8 x float> %a) {
; CHECK-LABEL: roundeven_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintn v0.4s, v0.4s
; CHECK-NEXT:    frintn v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.roundeven.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @roundeven_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: roundeven_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintn v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintn v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: roundeven_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintn v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: roundeven_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    frintn v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    frintn v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: roundeven_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintn v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.roundeven.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @roundeven_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: roundeven_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    frintn v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: roundeven_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintn v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: roundeven_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    frintn v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: roundeven_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintn v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.roundeven.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @roundeven_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: roundeven_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintn v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintn v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: roundeven_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintn v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: roundeven_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    frintn v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    frintn v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: roundeven_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintn v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.roundeven.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @roundeven_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: roundeven_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-NOFP16-NEXT:    frintn v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintn v1.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    frintn v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintn v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: roundeven_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintn v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    frintn v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: roundeven_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    frintn v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    frintn v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    frintn v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    frintn v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: roundeven_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintn v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    frintn v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.roundeven.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @rint_f64(double %a) {
; CHECK-LABEL: rint_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.rint.f64(double %a)
  ret double %c
}

define float @rint_f32(float %a) {
; CHECK-LABEL: rint_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.rint.f32(float %a)
  ret float %c
}

define half @rint_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: rint_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    frintx s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: rint_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintx h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: rint_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    frintx s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: rint_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintx h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.rint.f16(half %a)
  ret half %c
}

define <2 x double> @rint_v2f64(<2 x double> %a) {
; CHECK-LABEL: rint_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.rint.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @rint_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: rint_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    frintx v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    frintx v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: rint_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    frintx d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    frintx v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.rint.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @rint_v4f64(<4 x double> %a) {
; CHECK-LABEL: rint_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx v0.2d, v0.2d
; CHECK-NEXT:    frintx v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.rint.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @rint_v2f32(<2 x float> %a) {
; CHECK-LABEL: rint_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.rint.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @rint_v3f32(<3 x float> %a) {
; CHECK-LABEL: rint_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.rint.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @rint_v4f32(<4 x float> %a) {
; CHECK-LABEL: rint_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.rint.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @rint_v8f32(<8 x float> %a) {
; CHECK-LABEL: rint_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintx v0.4s, v0.4s
; CHECK-NEXT:    frintx v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.rint.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @rint_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: rint_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintx v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintx v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: rint_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintx v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: rint_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    frintx v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    frintx v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: rint_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintx v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.rint.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @rint_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: rint_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    frintx v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: rint_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintx v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: rint_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    frintx v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: rint_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintx v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.rint.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @rint_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: rint_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintx v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintx v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: rint_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintx v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: rint_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    frintx v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    frintx v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: rint_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintx v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.rint.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @rint_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: rint_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-NOFP16-NEXT:    frintx v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintx v1.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    frintx v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintx v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: rint_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintx v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    frintx v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: rint_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    frintx v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    frintx v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    frintx v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    frintx v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: rint_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintx v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    frintx v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.rint.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @round_f64(double %a) {
; CHECK-LABEL: round_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.round.f64(double %a)
  ret double %c
}

define float @round_f32(float %a) {
; CHECK-LABEL: round_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.round.f32(float %a)
  ret float %c
}

define half @round_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: round_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    frinta s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: round_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinta h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: round_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    frinta s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: round_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinta h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.round.f16(half %a)
  ret half %c
}

define <2 x double> @round_v2f64(<2 x double> %a) {
; CHECK-LABEL: round_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.round.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @round_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: round_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    frinta v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    frinta v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: round_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    frinta d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    frinta v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.round.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @round_v4f64(<4 x double> %a) {
; CHECK-LABEL: round_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta v0.2d, v0.2d
; CHECK-NEXT:    frinta v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.round.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @round_v2f32(<2 x float> %a) {
; CHECK-LABEL: round_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.round.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @round_v3f32(<3 x float> %a) {
; CHECK-LABEL: round_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.round.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @round_v4f32(<4 x float> %a) {
; CHECK-LABEL: round_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.round.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @round_v8f32(<8 x float> %a) {
; CHECK-LABEL: round_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frinta v0.4s, v0.4s
; CHECK-NEXT:    frinta v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.round.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @round_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: round_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frinta v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frinta v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: round_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinta v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: round_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    frinta v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    frinta v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: round_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinta v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.round.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @round_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: round_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    frinta v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: round_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinta v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: round_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    frinta v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: round_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinta v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.round.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @round_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: round_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frinta v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frinta v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: round_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinta v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: round_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    frinta v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    frinta v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: round_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinta v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.round.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @round_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: round_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-NOFP16-NEXT:    frinta v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    frinta v1.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    frinta v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    frinta v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: round_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frinta v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    frinta v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: round_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    frinta v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    frinta v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    frinta v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    frinta v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: round_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frinta v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    frinta v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.round.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

define double @trunc_f64(double %a) {
; CHECK-LABEL: trunc_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.trunc.f64(double %a)
  ret double %c
}

define float @trunc_f32(float %a) {
; CHECK-LABEL: trunc_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.trunc.f32(float %a)
  ret float %c
}

define half @trunc_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: trunc_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    frintz s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: trunc_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintz h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: trunc_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    frintz s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: trunc_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintz h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.trunc.f16(half %a)
  ret half %c
}

define <2 x double> @trunc_v2f64(<2 x double> %a) {
; CHECK-LABEL: trunc_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.trunc.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @trunc_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: trunc_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    frintz v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    frintz v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: trunc_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    frintz d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    frintz v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.trunc.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @trunc_v4f64(<4 x double> %a) {
; CHECK-LABEL: trunc_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz v0.2d, v0.2d
; CHECK-NEXT:    frintz v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.trunc.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @trunc_v2f32(<2 x float> %a) {
; CHECK-LABEL: trunc_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.trunc.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @trunc_v3f32(<3 x float> %a) {
; CHECK-LABEL: trunc_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.trunc.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @trunc_v4f32(<4 x float> %a) {
; CHECK-LABEL: trunc_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.trunc.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @trunc_v8f32(<8 x float> %a) {
; CHECK-LABEL: trunc_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    frintz v0.4s, v0.4s
; CHECK-NEXT:    frintz v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.trunc.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @trunc_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: trunc_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintz v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintz v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: trunc_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintz v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: trunc_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    frintz v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    frintz v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: trunc_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintz v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.trunc.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @trunc_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: trunc_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    frintz v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: trunc_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintz v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: trunc_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    frintz v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: trunc_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintz v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.trunc.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @trunc_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: trunc_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v2.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    frintz v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    frintz v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: trunc_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintz v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: trunc_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    frintz v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    frintz v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: trunc_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintz v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.trunc.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @trunc_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: trunc_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v4.4s, v0.8h
; CHECK-SD-NOFP16-NEXT:    fcvtl2 v5.4s, v1.8h
; CHECK-SD-NOFP16-NEXT:    frintz v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintz v1.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    frintz v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    frintz v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: trunc_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    frintz v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    frintz v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: trunc_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl v3.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v1.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    frintz v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    frintz v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    frintz v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    frintz v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: trunc_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    frintz v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    frintz v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.trunc.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

declare <16 x half> @llvm.ceil.v16f16(<16 x half>)
declare <16 x half> @llvm.floor.v16f16(<16 x half>)
declare <16 x half> @llvm.nearbyint.v16f16(<16 x half>)
declare <16 x half> @llvm.rint.v16f16(<16 x half>)
declare <16 x half> @llvm.round.v16f16(<16 x half>)
declare <16 x half> @llvm.roundeven.v16f16(<16 x half>)
declare <16 x half> @llvm.trunc.v16f16(<16 x half>)
declare <2 x double> @llvm.ceil.v2f64(<2 x double>)
declare <2 x double> @llvm.floor.v2f64(<2 x double>)
declare <2 x double> @llvm.nearbyint.v2f64(<2 x double>)
declare <2 x double> @llvm.rint.v2f64(<2 x double>)
declare <2 x double> @llvm.round.v2f64(<2 x double>)
declare <2 x double> @llvm.roundeven.v2f64(<2 x double>)
declare <2 x double> @llvm.trunc.v2f64(<2 x double>)
declare <2 x float> @llvm.ceil.v2f32(<2 x float>)
declare <2 x float> @llvm.floor.v2f32(<2 x float>)
declare <2 x float> @llvm.nearbyint.v2f32(<2 x float>)
declare <2 x float> @llvm.rint.v2f32(<2 x float>)
declare <2 x float> @llvm.round.v2f32(<2 x float>)
declare <2 x float> @llvm.roundeven.v2f32(<2 x float>)
declare <2 x float> @llvm.trunc.v2f32(<2 x float>)
declare <3 x double> @llvm.ceil.v3f64(<3 x double>)
declare <3 x double> @llvm.floor.v3f64(<3 x double>)
declare <3 x double> @llvm.nearbyint.v3f64(<3 x double>)
declare <3 x double> @llvm.rint.v3f64(<3 x double>)
declare <3 x double> @llvm.round.v3f64(<3 x double>)
declare <3 x double> @llvm.roundeven.v3f64(<3 x double>)
declare <3 x double> @llvm.trunc.v3f64(<3 x double>)
declare <3 x float> @llvm.ceil.v3f32(<3 x float>)
declare <3 x float> @llvm.floor.v3f32(<3 x float>)
declare <3 x float> @llvm.nearbyint.v3f32(<3 x float>)
declare <3 x float> @llvm.rint.v3f32(<3 x float>)
declare <3 x float> @llvm.round.v3f32(<3 x float>)
declare <3 x float> @llvm.roundeven.v3f32(<3 x float>)
declare <3 x float> @llvm.trunc.v3f32(<3 x float>)
declare <4 x double> @llvm.ceil.v4f64(<4 x double>)
declare <4 x double> @llvm.floor.v4f64(<4 x double>)
declare <4 x double> @llvm.nearbyint.v4f64(<4 x double>)
declare <4 x double> @llvm.rint.v4f64(<4 x double>)
declare <4 x double> @llvm.round.v4f64(<4 x double>)
declare <4 x double> @llvm.roundeven.v4f64(<4 x double>)
declare <4 x double> @llvm.trunc.v4f64(<4 x double>)
declare <4 x float> @llvm.ceil.v4f32(<4 x float>)
declare <4 x float> @llvm.floor.v4f32(<4 x float>)
declare <4 x float> @llvm.nearbyint.v4f32(<4 x float>)
declare <4 x float> @llvm.rint.v4f32(<4 x float>)
declare <4 x float> @llvm.round.v4f32(<4 x float>)
declare <4 x float> @llvm.roundeven.v4f32(<4 x float>)
declare <4 x float> @llvm.trunc.v4f32(<4 x float>)
declare <4 x half> @llvm.ceil.v4f16(<4 x half>)
declare <4 x half> @llvm.floor.v4f16(<4 x half>)
declare <4 x half> @llvm.nearbyint.v4f16(<4 x half>)
declare <4 x half> @llvm.rint.v4f16(<4 x half>)
declare <4 x half> @llvm.round.v4f16(<4 x half>)
declare <4 x half> @llvm.roundeven.v4f16(<4 x half>)
declare <4 x half> @llvm.trunc.v4f16(<4 x half>)
declare <7 x half> @llvm.ceil.v7f16(<7 x half>)
declare <7 x half> @llvm.floor.v7f16(<7 x half>)
declare <7 x half> @llvm.nearbyint.v7f16(<7 x half>)
declare <7 x half> @llvm.rint.v7f16(<7 x half>)
declare <7 x half> @llvm.round.v7f16(<7 x half>)
declare <7 x half> @llvm.roundeven.v7f16(<7 x half>)
declare <7 x half> @llvm.trunc.v7f16(<7 x half>)
declare <8 x float> @llvm.ceil.v8f32(<8 x float>)
declare <8 x float> @llvm.floor.v8f32(<8 x float>)
declare <8 x float> @llvm.nearbyint.v8f32(<8 x float>)
declare <8 x float> @llvm.rint.v8f32(<8 x float>)
declare <8 x float> @llvm.round.v8f32(<8 x float>)
declare <8 x float> @llvm.roundeven.v8f32(<8 x float>)
declare <8 x float> @llvm.trunc.v8f32(<8 x float>)
declare <8 x half> @llvm.ceil.v8f16(<8 x half>)
declare <8 x half> @llvm.floor.v8f16(<8 x half>)
declare <8 x half> @llvm.nearbyint.v8f16(<8 x half>)
declare <8 x half> @llvm.rint.v8f16(<8 x half>)
declare <8 x half> @llvm.round.v8f16(<8 x half>)
declare <8 x half> @llvm.roundeven.v8f16(<8 x half>)
declare <8 x half> @llvm.trunc.v8f16(<8 x half>)
declare double @llvm.ceil.f64(double)
declare double @llvm.floor.f64(double)
declare double @llvm.nearbyint.f64(double)
declare double @llvm.rint.f64(double)
declare double @llvm.round.f64(double)
declare double @llvm.roundeven.f64(double)
declare double @llvm.trunc.f64(double)
declare float @llvm.ceil.f32(float)
declare float @llvm.floor.f32(float)
declare float @llvm.nearbyint.f32(float)
declare float @llvm.rint.f32(float)
declare float @llvm.round.f32(float)
declare float @llvm.roundeven.f32(float)
declare float @llvm.trunc.f32(float)
declare half @llvm.ceil.f16(half)
declare half @llvm.floor.f16(half)
declare half @llvm.nearbyint.f16(half)
declare half @llvm.rint.f16(half)
declare half @llvm.round.f16(half)
declare half @llvm.roundeven.f16(half)
declare half @llvm.trunc.f16(half)
