; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;; These test functions previously triggered the following error when emitting machine code:
;; LLVM ERROR: Attempting to emit UCVTFv1i64 instruction but the Feature_HasNEON predicate(s) are not met
; RUN: llc -mtriple=aarch64 -mattr=+neon,+fullfp16,+alternate-sextload-cvt-f32-pattern < %s | FileCheck %s --check-prefixes=CHECK,NEON-ENABLED
; RUN: llc -mtriple=aarch64 -mattr=-neon,+fullfp16,+alternate-sextload-cvt-f32-pattern < %s | FileCheck %s --check-prefixes=CHECK,NEON-DISABLED
;; Emit an object file so that verifyPredicates is called (it is not used for ASM output).
; RUN: llc -mtriple=aarch64 -mattr=-neon,+fullfp16 -o /dev/null %s --asm-show-inst -filetype=obj

define double @ui8_to_double(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: ui8_to_double:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr b0, [x0]
; NEON-ENABLED-NEXT:    ucvtf d0, d0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: ui8_to_double:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldrb w8, [x0]
; NEON-DISABLED-NEXT:    ucvtf d0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i8, ptr %i, align 1
  %conv = uitofp i8 %ld to double
  ret double %conv
}

define float @ui8_to_float(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: ui8_to_float:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr b0, [x0]
; NEON-ENABLED-NEXT:    ucvtf s0, s0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: ui8_to_float:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldrb w8, [x0]
; NEON-DISABLED-NEXT:    ucvtf s0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i8, ptr %i, align 1
  %conv = uitofp i8 %ld to float
  ret float %conv
}

define half @ui8_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: ui8_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrb w8, [x0]
; CHECK-NEXT:    ucvtf h0, w8
; CHECK-NEXT:    ret
entry:
  %ld = load i8, ptr %i, align 1
  %conv = uitofp i8 %ld to half
  ret half %conv
}

define double @ui16_to_double(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: ui16_to_double:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr h0, [x0]
; NEON-ENABLED-NEXT:    ucvtf d0, d0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: ui16_to_double:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldrh w8, [x0]
; NEON-DISABLED-NEXT:    ucvtf d0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i16, ptr %i, align 1
  %conv = uitofp i16 %ld to double
  ret double %conv
}

define float @ui16_to_float(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: ui16_to_float:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr h0, [x0]
; NEON-ENABLED-NEXT:    ucvtf s0, s0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: ui16_to_float:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldrh w8, [x0]
; NEON-DISABLED-NEXT:    ucvtf s0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i16, ptr %i, align 1
  %conv = uitofp i16 %ld to float
  ret float %conv
}

define half @ui16_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: ui16_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ucvtf h0, w8
; CHECK-NEXT:    ret
entry:
  %ld = load i16, ptr %i, align 1
  %conv = uitofp i16 %ld to half
  ret half %conv
}

define double @ui32_to_double(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: ui32_to_double:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr s0, [x0]
; NEON-ENABLED-NEXT:    ucvtf d0, d0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: ui32_to_double:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldr w8, [x0]
; NEON-DISABLED-NEXT:    ucvtf d0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i32, ptr %i, align 1
  %conv = uitofp i32 %ld to double
  ret double %conv
}

define float @ui32_to_float(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: ui32_to_float:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr s0, [x0]
; NEON-ENABLED-NEXT:    ucvtf s0, s0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: ui32_to_float:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldr w8, [x0]
; NEON-DISABLED-NEXT:    ucvtf s0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i32, ptr %i, align 1
  %conv = uitofp i32 %ld to float
  ret float %conv
}

define half @ui32_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: ui32_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ucvtf h0, w8
; CHECK-NEXT:    ret
entry:
  %ld = load i32, ptr %i, align 1
  %conv = uitofp i32 %ld to half
  ret half %conv
}

define double @ui64_to_double(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: ui64_to_double:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr d0, [x0]
; NEON-ENABLED-NEXT:    ucvtf d0, d0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: ui64_to_double:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldr x8, [x0]
; NEON-DISABLED-NEXT:    ucvtf d0, x8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i64, ptr %i, align 1
  %conv = uitofp i64 %ld to double
  ret double %conv
}

define float @ui64_to_float(ptr %i, ptr %f) {
; CHECK-LABEL: ui64_to_float:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ucvtf s0, x8
; CHECK-NEXT:    ret
entry:
  %ld = load i64, ptr %i, align 1
  %conv = uitofp i64 %ld to float
  ret float %conv
}

define half @ui64_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: ui64_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ucvtf h0, x8
; CHECK-NEXT:    ret
entry:
  %ld = load i64, ptr %i, align 1
  %conv = uitofp i64 %ld to half
  ret half %conv
}


define double @si8_to_double(ptr %i, ptr %f) {
; CHECK-LABEL: si8_to_double:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrsb w8, [x0]
; CHECK-NEXT:    scvtf d0, w8
; CHECK-NEXT:    ret
entry:
  %ld = load i8, ptr %i, align 1
  %conv = sitofp i8 %ld to double
  ret double %conv
}

define float @si8_to_float(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: si8_to_float:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr b0, [x0]
; NEON-ENABLED-NEXT:    sshll v0.8h, v0.8b, #0
; NEON-ENABLED-NEXT:    sshll v0.4s, v0.4h, #0
; NEON-ENABLED-NEXT:    scvtf s0, s0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: si8_to_float:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldrsb w8, [x0]
; NEON-DISABLED-NEXT:    scvtf s0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i8, ptr %i, align 1
  %conv = sitofp i8 %ld to float
  ret float %conv
}

define half @si8_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: si8_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrsb w8, [x0]
; CHECK-NEXT:    scvtf h0, w8
; CHECK-NEXT:    ret
entry:
  %ld = load i8, ptr %i, align 1
  %conv = sitofp i8 %ld to half
  ret half %conv
}

define double @si16_to_double(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: si16_to_double:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr h0, [x0]
; NEON-ENABLED-NEXT:    sshll v0.4s, v0.4h, #0
; NEON-ENABLED-NEXT:    sshll v0.2d, v0.2s, #0
; NEON-ENABLED-NEXT:    scvtf d0, d0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: si16_to_double:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldrsh w8, [x0]
; NEON-DISABLED-NEXT:    scvtf d0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i16, ptr %i, align 1
  %conv = sitofp i16 %ld to double
  ret double %conv
}

define float @si16_to_float(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: si16_to_float:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr h0, [x0]
; NEON-ENABLED-NEXT:    sshll v0.4s, v0.4h, #0
; NEON-ENABLED-NEXT:    scvtf s0, s0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: si16_to_float:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldrsh w8, [x0]
; NEON-DISABLED-NEXT:    scvtf s0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i16, ptr %i, align 1
  %conv = sitofp i16 %ld to float
  ret float %conv
}

define half @si16_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: si16_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrsh w8, [x0]
; CHECK-NEXT:    scvtf h0, w8
; CHECK-NEXT:    ret
entry:
  %ld = load i16, ptr %i, align 1
  %conv = sitofp i16 %ld to half
  ret half %conv
}

define double @si32_to_double(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: si32_to_double:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr s0, [x0]
; NEON-ENABLED-NEXT:    sshll v0.2d, v0.2s, #0
; NEON-ENABLED-NEXT:    scvtf d0, d0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: si32_to_double:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldr w8, [x0]
; NEON-DISABLED-NEXT:    scvtf d0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i32, ptr %i, align 1
  %conv = sitofp i32 %ld to double
  ret double %conv
}

define float @si32_to_float(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: si32_to_float:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr s0, [x0]
; NEON-ENABLED-NEXT:    scvtf s0, s0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: si32_to_float:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldr w8, [x0]
; NEON-DISABLED-NEXT:    scvtf s0, w8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i32, ptr %i, align 1
  %conv = sitofp i32 %ld to float
  ret float %conv
}

define half @si32_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: si32_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    scvtf h0, w8
; CHECK-NEXT:    ret
entry:
  %ld = load i32, ptr %i, align 1
  %conv = sitofp i32 %ld to half
  ret half %conv
}

define double @si64_to_double(ptr %i, ptr %f) {
; NEON-ENABLED-LABEL: si64_to_double:
; NEON-ENABLED:       // %bb.0: // %entry
; NEON-ENABLED-NEXT:    ldr d0, [x0]
; NEON-ENABLED-NEXT:    scvtf d0, d0
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: si64_to_double:
; NEON-DISABLED:       // %bb.0: // %entry
; NEON-DISABLED-NEXT:    ldr x8, [x0]
; NEON-DISABLED-NEXT:    scvtf d0, x8
; NEON-DISABLED-NEXT:    ret
entry:
  %ld = load i64, ptr %i, align 1
  %conv = sitofp i64 %ld to double
  ret double %conv
}

define float @si64_to_float(ptr %i, ptr %f) {
; CHECK-LABEL: si64_to_float:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    scvtf s0, x8
; CHECK-NEXT:    ret
entry:
  %ld = load i64, ptr %i, align 1
  %conv = sitofp i64 %ld to float
  ret float %conv
}

define half @si64_to_half(ptr %i, ptr %f) {
; CHECK-LABEL: si64_to_half:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    scvtf h0, x8
; CHECK-NEXT:    ret
entry:
  %ld = load i64, ptr %i, align 1
  %conv = sitofp i64 %ld to half
  ret half %conv
}
