; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck %s --check-prefix=GFX9
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck %s --check-prefix=GFX10
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck %s --check-prefix=GFX11

define amdgpu_kernel void @test0() {
; GFX9-LABEL: test0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: test0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: test0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_endpgm
  tail call void @llvm.amdgcn.endpgm()
  unreachable
}

define void @test1() {
; GFX9-LABEL: test1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: test1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: test1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_endpgm
  tail call void @llvm.amdgcn.endpgm()
  unreachable
}

define amdgpu_kernel void @test2(ptr %p, i32 %x) {
; GFX9-LABEL: test2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x2c
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lt_i32 s0, 1
; GFX9-NEXT:    s_cbranch_scc0 .LBB2_2
; GFX9-NEXT:  ; %bb.1: ; %else
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    flat_store_dword v[0:1], v2
; GFX9-NEXT:    s_endpgm
; GFX9-NEXT:  .LBB2_2: ; %then
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: test2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x2c
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lt_i32 s0, 1
; GFX10-NEXT:    s_cbranch_scc0 .LBB2_2
; GFX10-NEXT:  ; %bb.1: ; %else
; GFX10-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v2, s0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    flat_store_dword v[0:1], v2
; GFX10-NEXT:    s_endpgm
; GFX10-NEXT:  .LBB2_2: ; %then
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: test2:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x2c
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lt_i32 s0, 1
; GFX11-NEXT:    s_cbranch_scc0 .LBB2_2
; GFX11-NEXT:  ; %bb.1: ; %else
; GFX11-NEXT:    s_load_b64 s[2:3], s[2:3], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-NEXT:    s_endpgm
; GFX11-NEXT:  .LBB2_2: ; %then
; GFX11-NEXT:    s_endpgm
  %cond = icmp sgt i32 %x, 0
  br i1 %cond, label %then, label %else

then:
  tail call void @llvm.amdgcn.endpgm()
  unreachable

else:
  store i32 %x, ptr %p
  ret void
}

declare void @llvm.amdgcn.endpgm()
