; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-simplifylib,instcombine -amdgpu-prelink %s | FileCheck %s

target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-p7:160:256:256:32-p8:128:128-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5-G1-ni:7:8:9"

declare float @_Z4powrff(float, float)
declare <2 x float> @_Z4powrDv2_fS_(<2 x float>, <2 x float>)
declare <3 x float> @_Z4powrDv3_fS_(<3 x float>, <3 x float>)
declare <4 x float> @_Z4powrDv4_fS_(<4 x float>, <4 x float>)
declare <8 x float> @_Z4powrDv8_fS_(<8 x float>, <8 x float>)
declare <16 x float> @_Z4powrDv16_fS_(<16 x float>, <16 x float>)
declare double @_Z4powrdd(double, double)
declare <2 x double> @_Z4powrDv2_dS_(<2 x double>, <2 x double>)
declare <3 x double> @_Z4powrDv3_dS_(<3 x double>, <3 x double>)
declare <4 x double> @_Z4powrDv4_dS_(<4 x double>, <4 x double>)
declare <8 x double> @_Z4powrDv8_dS_(<8 x double>, <8 x double>)
declare <16 x double> @_Z4powrDv16_dS_(<16 x double>, <16 x double>)
declare half @_Z4powrDhDh(half, half)
declare <2 x half> @_Z4powrDv2_DhS_(<2 x half>, <2 x half>)
declare <3 x half> @_Z4powrDv3_DhS_(<3 x half>, <3 x half>)
declare <4 x half> @_Z4powrDv4_DhS_(<4 x half>, <4 x half>)
declare <8 x half> @_Z4powrDv8_DhS_(<8 x half>, <8 x half>)
declare <16 x half> @_Z4powrDv16_DhS_(<16 x half>, <16 x half>)

define float @test_powr_fast_f32(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_fast_f32
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call fast float @llvm.log2.f32(float [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul fast float [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call fast float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    ret float [[__EXP2]]
;
  %powr = tail call fast float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define <2 x float> @test_powr_fast_v2f32(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_fast_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call fast <2 x float> @llvm.log2.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul fast <2 x float> [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call fast <2 x float> @llvm.exp2.v2f32(<2 x float> [[__YLOGX]])
; CHECK-NEXT:    ret <2 x float> [[__EXP2]]
;
  %powr = tail call fast <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %powr
}

define float @test_powr_afn_f32(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_afn_f32
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define float @test_powr_afn_f32_nnan(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_nnan
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call nnan afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn nnan float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %powr
}

define <3 x float> @test_powr_afn_v3f32(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_afn_v3f32
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> [[X]], <3 x float> [[Y]])
; CHECK-NEXT:    ret <3 x float> [[POWR]]
;
  %powr = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> %y)
  ret <3 x float> %powr
}

define <4 x float> @test_powr_afn_v4f32(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: define <4 x float> @test_powr_afn_v4f32
; CHECK-SAME: (<4 x float> [[X:%.*]], <4 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <4 x float> @_Z4powrDv4_fS_(<4 x float> [[X]], <4 x float> [[Y]])
; CHECK-NEXT:    ret <4 x float> [[POWR]]
;
  %powr = tail call afn <4 x float> @_Z4powrDv4_fS_(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %powr
}

define <8 x float> @test_powr_afn_v8f32(<8 x float> %x, <8 x float> %y) {
; CHECK-LABEL: define <8 x float> @test_powr_afn_v8f32
; CHECK-SAME: (<8 x float> [[X:%.*]], <8 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <8 x float> @_Z4powrDv8_fS_(<8 x float> [[X]], <8 x float> [[Y]])
; CHECK-NEXT:    ret <8 x float> [[POWR]]
;
  %powr = tail call afn <8 x float> @_Z4powrDv8_fS_(<8 x float> %x, <8 x float> %y)
  ret <8 x float> %powr
}

define <16 x float> @test_powr_afn_v16f32(<16 x float> %x, <16 x float> %y) {
; CHECK-LABEL: define <16 x float> @test_powr_afn_v16f32
; CHECK-SAME: (<16 x float> [[X:%.*]], <16 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <16 x float> @_Z4powrDv16_fS_(<16 x float> [[X]], <16 x float> [[Y]])
; CHECK-NEXT:    ret <16 x float> [[POWR]]
;
  %powr = tail call afn <16 x float> @_Z4powrDv16_fS_(<16 x float> %x, <16 x float> %y)
  ret <16 x float> %powr
}

define double @test_powr_afn_f64(double %x, double %y) {
; CHECK-LABEL: define double @test_powr_afn_f64
; CHECK-SAME: (double [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn double @_Z4powrdd(double [[X]], double [[Y]])
; CHECK-NEXT:    ret double [[POWR]]
;
  %powr = tail call afn double @_Z4powrdd(double %x, double %y)
  ret double %powr
}

define <2 x double> @test_powr_afn_v2f64(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_powr_afn_v2f64
; CHECK-SAME: (<2 x double> [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x double> @_Z4powrDv2_dS_(<2 x double> [[X]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[POWR]]
;
  %powr = tail call afn <2 x double> @_Z4powrDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %powr
}

define <3 x double> @test_powr_afn_v3f64(<3 x double> %x, <3 x double> %y) {
; CHECK-LABEL: define <3 x double> @test_powr_afn_v3f64
; CHECK-SAME: (<3 x double> [[X:%.*]], <3 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <3 x double> @_Z4powrDv3_dS_(<3 x double> [[X]], <3 x double> [[Y]])
; CHECK-NEXT:    ret <3 x double> [[POWR]]
;
  %powr = tail call afn <3 x double> @_Z4powrDv3_dS_(<3 x double> %x, <3 x double> %y)
  ret <3 x double> %powr
}

define <4 x double> @test_powr_afn_v4f64(<4 x double> %x, <4 x double> %y) {
; CHECK-LABEL: define <4 x double> @test_powr_afn_v4f64
; CHECK-SAME: (<4 x double> [[X:%.*]], <4 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <4 x double> @_Z4powrDv4_dS_(<4 x double> [[X]], <4 x double> [[Y]])
; CHECK-NEXT:    ret <4 x double> [[POWR]]
;
  %powr = tail call afn <4 x double> @_Z4powrDv4_dS_(<4 x double> %x, <4 x double> %y)
  ret <4 x double> %powr
}

define <8 x double> @test_powr_afn_v8f64(<8 x double> %x, <8 x double> %y) {
; CHECK-LABEL: define <8 x double> @test_powr_afn_v8f64
; CHECK-SAME: (<8 x double> [[X:%.*]], <8 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <8 x double> @_Z4powrDv8_dS_(<8 x double> [[X]], <8 x double> [[Y]])
; CHECK-NEXT:    ret <8 x double> [[POWR]]
;
  %powr = tail call afn <8 x double> @_Z4powrDv8_dS_(<8 x double> %x, <8 x double> %y)
  ret <8 x double> %powr
}

define <16 x double> @test_powr_afn_v16f64(<16 x double> %x, <16 x double> %y) {
; CHECK-LABEL: define <16 x double> @test_powr_afn_v16f64
; CHECK-SAME: (<16 x double> [[X:%.*]], <16 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <16 x double> @_Z4powrDv16_dS_(<16 x double> [[X]], <16 x double> [[Y]])
; CHECK-NEXT:    ret <16 x double> [[POWR]]
;
  %powr = tail call afn <16 x double> @_Z4powrDv16_dS_(<16 x double> %x, <16 x double> %y)
  ret <16 x double> %powr
}

define half @test_powr_afn_f16(half %x, half %y) {
; CHECK-LABEL: define half @test_powr_afn_f16
; CHECK-SAME: (half [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn half @_Z4powrDhDh(half [[X]], half [[Y]])
; CHECK-NEXT:    ret half [[POWR]]
;
  %powr = tail call afn half @_Z4powrDhDh(half %x, half %y)
  ret half %powr
}

define <2 x half> @test_powr_afn_v2f16(<2 x half> %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_powr_afn_v2f16
; CHECK-SAME: (<2 x half> [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x half> @_Z4powrDv2_DhS_(<2 x half> [[X]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[POWR]]
;
  %powr = tail call afn <2 x half> @_Z4powrDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %powr
}

define <3 x half> @test_powr_afn_v3f16(<3 x half> %x, <3 x half> %y) {
; CHECK-LABEL: define <3 x half> @test_powr_afn_v3f16
; CHECK-SAME: (<3 x half> [[X:%.*]], <3 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <3 x half> @_Z4powrDv3_DhS_(<3 x half> [[X]], <3 x half> [[Y]])
; CHECK-NEXT:    ret <3 x half> [[POWR]]
;
  %powr = tail call afn <3 x half> @_Z4powrDv3_DhS_(<3 x half> %x, <3 x half> %y)
  ret <3 x half> %powr
}

define <4 x half> @test_powr_afn_v4f16(<4 x half> %x, <4 x half> %y) {
; CHECK-LABEL: define <4 x half> @test_powr_afn_v4f16
; CHECK-SAME: (<4 x half> [[X:%.*]], <4 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <4 x half> @_Z4powrDv4_DhS_(<4 x half> [[X]], <4 x half> [[Y]])
; CHECK-NEXT:    ret <4 x half> [[POWR]]
;
  %powr = tail call afn <4 x half> @_Z4powrDv4_DhS_(<4 x half> %x, <4 x half> %y)
  ret <4 x half> %powr
}

define <8 x half> @test_powr_afn_v8f16(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: define <8 x half> @test_powr_afn_v8f16
; CHECK-SAME: (<8 x half> [[X:%.*]], <8 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <8 x half> @_Z4powrDv8_DhS_(<8 x half> [[X]], <8 x half> [[Y]])
; CHECK-NEXT:    ret <8 x half> [[POWR]]
;
  %powr = tail call afn <8 x half> @_Z4powrDv8_DhS_(<8 x half> %x, <8 x half> %y)
  ret <8 x half> %powr
}

define <16 x half> @test_powr_afn_v16f16(<16 x half> %x, <16 x half> %y) {
; CHECK-LABEL: define <16 x half> @test_powr_afn_v16f16
; CHECK-SAME: (<16 x half> [[X:%.*]], <16 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <16 x half> @_Z4powrDv16_DhS_(<16 x half> [[X]], <16 x half> [[Y]])
; CHECK-NEXT:    ret <16 x half> [[POWR]]
;
  %powr = tail call afn <16 x half> @_Z4powrDv16_DhS_(<16 x half> %x, <16 x half> %y)
  ret <16 x half> %powr
}

define float @test_powr_f32(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_f32
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define float @test_powr_f32_nnan(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_f32_nnan
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call nnan float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call nnan float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define <2 x float> @test_powr_v2f32(<2 x float> %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_v2f32
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %powr
}

define <3 x float> @test_powr_v3f32(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_v3f32
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <3 x float> @_Z4powrDv3_fS_(<3 x float> [[X]], <3 x float> [[Y]])
; CHECK-NEXT:    ret <3 x float> [[POWR]]
;
  %powr = tail call <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> %y)
  ret <3 x float> %powr
}

define <4 x float> @test_powr_v4f32(<4 x float> %x, <4 x float> %y) {
; CHECK-LABEL: define <4 x float> @test_powr_v4f32
; CHECK-SAME: (<4 x float> [[X:%.*]], <4 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <4 x float> @_Z4powrDv4_fS_(<4 x float> [[X]], <4 x float> [[Y]])
; CHECK-NEXT:    ret <4 x float> [[POWR]]
;
  %powr = tail call <4 x float> @_Z4powrDv4_fS_(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %powr
}

define <8 x float> @test_powr_v8f32(<8 x float> %x, <8 x float> %y) {
; CHECK-LABEL: define <8 x float> @test_powr_v8f32
; CHECK-SAME: (<8 x float> [[X:%.*]], <8 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <8 x float> @_Z4powrDv8_fS_(<8 x float> [[X]], <8 x float> [[Y]])
; CHECK-NEXT:    ret <8 x float> [[POWR]]
;
  %powr = tail call <8 x float> @_Z4powrDv8_fS_(<8 x float> %x, <8 x float> %y)
  ret <8 x float> %powr
}

define <16 x float> @test_powr_v16f32(<16 x float> %x, <16 x float> %y) {
; CHECK-LABEL: define <16 x float> @test_powr_v16f32
; CHECK-SAME: (<16 x float> [[X:%.*]], <16 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <16 x float> @_Z4powrDv16_fS_(<16 x float> [[X]], <16 x float> [[Y]])
; CHECK-NEXT:    ret <16 x float> [[POWR]]
;
  %powr = tail call <16 x float> @_Z4powrDv16_fS_(<16 x float> %x, <16 x float> %y)
  ret <16 x float> %powr
}

define double @test_powr_f64(double %x, double %y) {
; CHECK-LABEL: define double @test_powr_f64
; CHECK-SAME: (double [[X:%.*]], double [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call double @_Z4powrdd(double [[X]], double [[Y]])
; CHECK-NEXT:    ret double [[POWR]]
;
  %powr = tail call double @_Z4powrdd(double %x, double %y)
  ret double %powr
}

define <2 x double> @test_powr_v2f64(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: define <2 x double> @test_powr_v2f64
; CHECK-SAME: (<2 x double> [[X:%.*]], <2 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <2 x double> @_Z4powrDv2_dS_(<2 x double> [[X]], <2 x double> [[Y]])
; CHECK-NEXT:    ret <2 x double> [[POWR]]
;
  %powr = tail call <2 x double> @_Z4powrDv2_dS_(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %powr
}

define <3 x double> @test_powr_v3f64(<3 x double> %x, <3 x double> %y) {
; CHECK-LABEL: define <3 x double> @test_powr_v3f64
; CHECK-SAME: (<3 x double> [[X:%.*]], <3 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <3 x double> @_Z4powrDv3_dS_(<3 x double> [[X]], <3 x double> [[Y]])
; CHECK-NEXT:    ret <3 x double> [[POWR]]
;
  %powr = tail call <3 x double> @_Z4powrDv3_dS_(<3 x double> %x, <3 x double> %y)
  ret <3 x double> %powr
}

define <4 x double> @test_powr_v4f64(<4 x double> %x, <4 x double> %y) {
; CHECK-LABEL: define <4 x double> @test_powr_v4f64
; CHECK-SAME: (<4 x double> [[X:%.*]], <4 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <4 x double> @_Z4powrDv4_dS_(<4 x double> [[X]], <4 x double> [[Y]])
; CHECK-NEXT:    ret <4 x double> [[POWR]]
;
  %powr = tail call <4 x double> @_Z4powrDv4_dS_(<4 x double> %x, <4 x double> %y)
  ret <4 x double> %powr
}

define <8 x double> @test_powr_v8f64(<8 x double> %x, <8 x double> %y) {
; CHECK-LABEL: define <8 x double> @test_powr_v8f64
; CHECK-SAME: (<8 x double> [[X:%.*]], <8 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <8 x double> @_Z4powrDv8_dS_(<8 x double> [[X]], <8 x double> [[Y]])
; CHECK-NEXT:    ret <8 x double> [[POWR]]
;
  %powr = tail call <8 x double> @_Z4powrDv8_dS_(<8 x double> %x, <8 x double> %y)
  ret <8 x double> %powr
}

define <16 x double> @test_powr_v16f64(<16 x double> %x, <16 x double> %y) {
; CHECK-LABEL: define <16 x double> @test_powr_v16f64
; CHECK-SAME: (<16 x double> [[X:%.*]], <16 x double> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <16 x double> @_Z4powrDv16_dS_(<16 x double> [[X]], <16 x double> [[Y]])
; CHECK-NEXT:    ret <16 x double> [[POWR]]
;
  %powr = tail call <16 x double> @_Z4powrDv16_dS_(<16 x double> %x, <16 x double> %y)
  ret <16 x double> %powr
}

define half @test_powr_f16(half %x, half %y) {
; CHECK-LABEL: define half @test_powr_f16
; CHECK-SAME: (half [[X:%.*]], half [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call half @_Z4powrDhDh(half [[X]], half [[Y]])
; CHECK-NEXT:    ret half [[POWR]]
;
  %powr = tail call half @_Z4powrDhDh(half %x, half %y)
  ret half %powr
}

define <2 x half> @test_powr_v2f16(<2 x half> %x, <2 x half> %y) {
; CHECK-LABEL: define <2 x half> @test_powr_v2f16
; CHECK-SAME: (<2 x half> [[X:%.*]], <2 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <2 x half> @_Z4powrDv2_DhS_(<2 x half> [[X]], <2 x half> [[Y]])
; CHECK-NEXT:    ret <2 x half> [[POWR]]
;
  %powr = tail call <2 x half> @_Z4powrDv2_DhS_(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %powr
}

define <3 x half> @test_powr_v3f16(<3 x half> %x, <3 x half> %y) {
; CHECK-LABEL: define <3 x half> @test_powr_v3f16
; CHECK-SAME: (<3 x half> [[X:%.*]], <3 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <3 x half> @_Z4powrDv3_DhS_(<3 x half> [[X]], <3 x half> [[Y]])
; CHECK-NEXT:    ret <3 x half> [[POWR]]
;
  %powr = tail call <3 x half> @_Z4powrDv3_DhS_(<3 x half> %x, <3 x half> %y)
  ret <3 x half> %powr
}

define <4 x half> @test_powr_v4f16(<4 x half> %x, <4 x half> %y) {
; CHECK-LABEL: define <4 x half> @test_powr_v4f16
; CHECK-SAME: (<4 x half> [[X:%.*]], <4 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <4 x half> @_Z4powrDv4_DhS_(<4 x half> [[X]], <4 x half> [[Y]])
; CHECK-NEXT:    ret <4 x half> [[POWR]]
;
  %powr = tail call <4 x half> @_Z4powrDv4_DhS_(<4 x half> %x, <4 x half> %y)
  ret <4 x half> %powr
}

define <8 x half> @test_powr_v8f16(<8 x half> %x, <8 x half> %y) {
; CHECK-LABEL: define <8 x half> @test_powr_v8f16
; CHECK-SAME: (<8 x half> [[X:%.*]], <8 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <8 x half> @_Z4powrDv8_DhS_(<8 x half> [[X]], <8 x half> [[Y]])
; CHECK-NEXT:    ret <8 x half> [[POWR]]
;
  %powr = tail call <8 x half> @_Z4powrDv8_DhS_(<8 x half> %x, <8 x half> %y)
  ret <8 x half> %powr
}

define <16 x half> @test_powr_v16f16(<16 x half> %x, <16 x half> %y) {
; CHECK-LABEL: define <16 x half> @test_powr_v16f16
; CHECK-SAME: (<16 x half> [[X:%.*]], <16 x half> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <16 x half> @_Z4powrDv16_DhS_(<16 x half> [[X]], <16 x half> [[Y]])
; CHECK-NEXT:    ret <16 x half> [[POWR]]
;
  %powr = tail call <16 x half> @_Z4powrDv16_DhS_(<16 x half> %x, <16 x half> %y)
  ret <16 x half> %powr
}

define float @test_powr_afn_f32_minsize(float %x, float %y) #0 {
; CHECK-LABEL: define float @test_powr_afn_f32_minsize
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define float @test_powr_afn_f32_nnan_minsize(float %x, float %y) #0 {
; CHECK-LABEL: define float @test_powr_afn_f32_nnan_minsize
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[POWR:%.*]] = tail call nnan afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn nnan float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define float @test_powr_afn_f32_noinline(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_noinline
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y]]) #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float %y) #1
  ret float %powr
}

define float @test_powr_afn_f32_nnan_noinline(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_nnan_noinline
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call nnan afn float @_Z4powrff(float [[X]], float [[Y]]) #[[ATTR4]]
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn nnan float @_Z4powrff(float %x, float %y) #1
  ret float %powr
}

define float @test_powr_afn_f32_strictfp(float %x, float %y) #2 {
; CHECK-LABEL: define float @test_powr_afn_f32_strictfp
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[POWR:%.*]] = tail call nnan nsz afn float @_Z4powrff(float [[X]], float [[Y]]) #[[ATTR1]]
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn nsz nnan float @_Z4powrff(float %x, float %y) #2
  ret float %powr
}

define float @test_powr_fast_f32_nobuiltin(float %x, float %y) {
; CHECK-LABEL: define float @test_powr_fast_f32_nobuiltin
; CHECK-SAME: (float [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call fast float @_Z4powrff(float [[X]], float [[Y]]) #[[ATTR5:[0-9]+]]
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call fast float @_Z4powrff(float %x, float %y) #3
  ret float %powr
}

define float @test_powr_afn_f32_poison(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_poison
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float poison)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float poison)
  ret float %powr
}

define float @test_powr_afn_f32_0.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_0.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %powr = tail call afn float @_Z4powrff(float %x, float 0.0)
  ret float %powr
}

define float @test_powr_afn_f32_neg0.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg0.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float 1.000000e+00
;
  %powr = tail call afn float @_Z4powrff(float %x, float -0.0)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_0.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_0.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 1.000000e+00, float 1.000000e+00>
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 0.0, float 0.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg0.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg0.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> <float 1.000000e+00, float 1.000000e+00>
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -0.0, float -0.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_0.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_0.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 0.000000e+00, float -0.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 0.0, float -0.0>)
  ret <2 x float> %powr
}

define <3 x float> @test_powr_afn_v3f32_0.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_afn_v3f32_0.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    ret <3 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>
;
  %powr = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> <float 0.0, float poison, float 0.0>)
  ret <3 x float> %powr
}

define <3 x float> @test_powr_afn_v3f32_neg0.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_afn_v3f32_neg0.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    ret <3 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>
;
  %powr = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> <float -0.0, float poison, float -0.0>)
  ret <3 x float> %powr
}

define float @test_powr_afn_f32_0.5(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_0.5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call afn float @_Z4sqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2SQRT]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 0.5)
  ret float %powr
}

define float @test_powr_afn_f32_neg0.5(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg0.5
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call afn float @_Z5rsqrtf(float [[X]])
; CHECK-NEXT:    ret float [[__POW2RSQRT]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float -0.5)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_0.5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_0.5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call afn <2 x float> @_Z4sqrtDv2_f(<2 x float> [[X]])
; CHECK-NEXT:    ret <2 x float> [[__POW2SQRT]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 0.5, float 0.5>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg0.5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg0.5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call afn <2 x float> @_Z5rsqrtDv2_f(<2 x float> [[X]])
; CHECK-NEXT:    ret <2 x float> [[__POW2RSQRT]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -0.5, float -0.5>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_0.5(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_0.5
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 5.000000e-01, float -5.000000e-01>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 0.5, float -0.5>)
  ret <2 x float> %powr
}

define <3 x float> @test_powr_afn_v3f32_0.5_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_afn_v3f32_0.5_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__POW2SQRT:%.*]] = call afn <3 x float> @_Z4sqrtDv3_f(<3 x float> [[X]])
; CHECK-NEXT:    ret <3 x float> [[__POW2SQRT]]
;
  %powr = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> <float 0.5, float poison, float 0.5>)
  ret <3 x float> %powr
}

define <3 x float> @test_powr_afn_v3f32_neg0.5_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_afn_v3f32_neg0.5_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__POW2RSQRT:%.*]] = call afn <3 x float> @_Z5rsqrtDv3_f(<3 x float> [[X]])
; CHECK-NEXT:    ret <3 x float> [[__POW2RSQRT]]
;
  %powr = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> <float -0.5, float poison, float -0.5>)
  ret <3 x float> %powr
}

define float @test_powr_afn_f32_1.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_1.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    ret float [[X]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 1.0)
  ret float %powr
}

define float @test_powr_afn_f32_neg1.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg1.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv afn float 1.000000e+00, [[X]]
; CHECK-NEXT:    ret float [[__POWRECIP]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float -1.0)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_1.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_1.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    ret <2 x float> [[X]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 1.0, float 1.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg1.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg1.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv afn <2 x float> <float 1.000000e+00, float 1.000000e+00>, [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POWRECIP]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -1.0, float -1.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_1.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_1.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 1.000000e+00, float -1.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 1.0, float -1.0>)
  ret <2 x float> %powr
}

define <3 x float> @test_powr_afn_v3f32_1.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_afn_v3f32_1.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    ret <3 x float> [[X]]
;
  %powr = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> <float 1.0, float poison, float 1.0>)
  ret <3 x float> %powr
}

define <3 x float> @test_powr_afn_v3f32_neg1.0_splat_undef(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: define <3 x float> @test_powr_afn_v3f32_neg1.0_splat_undef
; CHECK-SAME: (<3 x float> [[X:%.*]], <3 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__POWRECIP:%.*]] = fdiv afn <3 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>, [[X]]
; CHECK-NEXT:    ret <3 x float> [[__POWRECIP]]
;
  %powr = tail call afn <3 x float> @_Z4powrDv3_fS_(<3 x float> %x, <3 x float> <float -1.0, float poison, float -1.0>)
  ret <3 x float> %powr
}

define float @test_powr_afn_f32_2.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_2.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2:%.*]] = fmul afn float [[X]], [[X]]
; CHECK-NEXT:    ret float [[__POW2]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 2.0)
  ret float %powr
}

define float @test_powr_afn_f32_neg2.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg2.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float -2.000000e+00)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float -2.0)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_2.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_2.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[__POW2:%.*]] = fmul afn <2 x float> [[X]], [[X]]
; CHECK-NEXT:    ret <2 x float> [[__POW2]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 2.0, float 2.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg2.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg2.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float -2.000000e+00, float -2.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -2.0, float -2.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_2.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_2.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 2.000000e+00, float -2.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 2.0, float -2.0>)
  ret <2 x float> %powr
}

define float @test_powr_afn_f32_3.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_3.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float 3.000000e+00)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 3.0)
  ret float %powr
}

define float @test_powr_afn_f32_neg3.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg3.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float -3.000000e+00)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float -3.0)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_3.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_3.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 3.000000e+00, float 3.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 3.0, float 3.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg3.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg3.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float -3.000000e+00, float -3.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -3.0, float -3.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_3.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_3.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 3.000000e+00, float -3.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 3.0, float -3.0>)
  ret <2 x float> %powr
}

define float @test_powr_afn_f32_3.99(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_3.99
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float 0x400FEB8520000000)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 0x400FEB8520000000)
  ret float %powr
}

define float @test_powr_afn_f32_neg3.99(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg3.99
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float 0xC00FEB8520000000)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 0xC00FEB8520000000)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_3.99(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_3.99
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 0x400FEB8520000000, float 0x400FEB8520000000>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 0x400FEB8520000000, float 0x400FEB8520000000>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg3.99(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg3.99
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 0xC00FEB8520000000, float 0xC00FEB8520000000>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 0xC00FEB8520000000, float 0xC00FEB8520000000>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_3.99(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_3.99
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 0x400FEB8520000000, float 0xC00FEB8520000000>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 0x400FEB8520000000, float 0xC00FEB8520000000>)
  ret <2 x float> %powr
}

define float @test_powr_afn_f32_8.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_8.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float 8.000000e+00)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 8.0)
  ret float %powr
}

define float @test_powr_afn_f32_neg8.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg8.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float -8.000000e+00)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float -8.0)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_8.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_8.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 8.000000e+00, float 8.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 8.0, float 8.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg8.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg8.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float -8.000000e+00, float -8.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -8.0, float -8.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_8.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_8.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 8.000000e+00, float -8.000000e+00>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 8.0, float -8.0>)
  ret <2 x float> %powr
}

define float @test_powr_afn_f32_12.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_12.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float 1.200000e+01)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 12.0)
  ret float %powr
}

define float @test_powr_afn_f32_neg12.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg12.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float -1.200000e+01)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float -12.0)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_12.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_12.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 1.200000e+01, float 1.200000e+01>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 12.0, float 12.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg12.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg12.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float -1.200000e+01, float -1.200000e+01>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -12.0, float -12.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_12.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_12.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 1.200000e+01, float -1.200000e+01>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 12.0, float -12.0>)
  ret <2 x float> %powr
}

define float @test_powr_afn_f32_13.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_13.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float 1.300000e+01)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float 13.0)
  ret float %powr
}

define float @test_powr_afn_f32_neg13.0(float %x) {
; CHECK-LABEL: define float @test_powr_afn_f32_neg13.0
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float -1.300000e+01)
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float -13.0)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_13.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_13.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 1.300000e+01, float 1.300000e+01>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 13.0, float 13.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_neg13.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_neg13.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float -1.300000e+01, float -1.300000e+01>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float -13.0, float -13.0>)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_plus_minus_13.0(<2 x float> %x) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_plus_minus_13.0
; CHECK-SAME: (<2 x float> [[X:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> <float 1.300000e+01, float -1.300000e+01>)
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> <float 13.0, float -13.0>)
  ret <2 x float> %powr
}

define float @test_powr_afn_f32_nnan_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_nnan_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call nnan afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn nnan float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define float @test_powr_afn_f32_nnan_ninf_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_nnan_ninf_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    ret float [[__EXP2]]
;
  %powr = tail call afn nnan ninf float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define <2 x float> @test_powr_afn_v2f32_nnan_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_nnan_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call nnan afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn nnan <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_nnan_ninf_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_nnan_ninf_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x float> @llvm.log2.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x float> [[__LOG2]], [[Y]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x float> @llvm.exp2.v2f32(<2 x float> [[__YLOGX]])
; CHECK-NEXT:    ret <2 x float> [[__EXP2]]
;
  %powr = tail call afn nnan ninf <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %powr
}

define float @test_powr_f32_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_powr_f32_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define float @test_powr_afn_f32_x_known_positive(float nofpclass(ninf nnorm nsub) %x, float %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_x_known_positive
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[X:%.*]], float [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %powr = tail call afn float @_Z4powrff(float %x, float %y)
  ret float %powr
}

define <2 x float> @test_powr_v2f32_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_v2f32_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_x_known_positive(<2 x float> nofpclass(ninf nnorm nsub) %x, <2 x float> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_x_known_positive
; CHECK-SAME: (<2 x float> nofpclass(ninf nsub nnorm) [[X:%.*]], <2 x float> [[Y:%.*]]) {
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y]])
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %powr
}

define float @test_powr_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_powr_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[POWR:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %y.cast = sitofp i32 %y to float
  %powr = tail call float @_Z4powrff(float %x, float %y.cast)
  ret float %powr
}

define float @test_powr_afn_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %y.cast = sitofp i32 %y to float
  %powr = tail call afn float @_Z4powrff(float %x, float %y.cast)
  ret float %powr
}

define float @test_powr_afn_nnan_ninf_f32_known_integral_sitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_powr_afn_nnan_ninf_f32_known_integral_sitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp i32 [[Y]] to float
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[Y_CAST]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    ret float [[__EXP2]]
;
  %y.cast = sitofp i32 %y to float
  %powr = tail call afn nnan ninf float @_Z4powrff(float %x, float %y.cast)
  ret float %powr
}

define float @test_powr_f32_known_integral_uitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_powr_f32_known_integral_uitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i32 [[Y]] to float
; CHECK-NEXT:    [[POWR:%.*]] = tail call float @_Z4powrff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %y.cast = uitofp i32 %y to float
  %powr = tail call float @_Z4powrff(float %x, float %y.cast)
  ret float %powr
}

define float @test_powr_afn_f32_known_integral_uitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_powr_afn_f32_known_integral_uitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i32 [[Y]] to float
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn float @_Z4powrff(float [[X]], float [[Y_CAST]])
; CHECK-NEXT:    ret float [[POWR]]
;
  %y.cast = uitofp i32 %y to float
  %powr = tail call afn float @_Z4powrff(float %x, float %y.cast)
  ret float %powr
}

define float @test_powr_afn_nnan_ninf_f32_known_integral_uitofp(float %x, i32 %y) {
; CHECK-LABEL: define float @test_powr_afn_nnan_ninf_f32_known_integral_uitofp
; CHECK-SAME: (float [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp i32 [[Y]] to float
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn float @llvm.log2.f32(float [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn float [[__LOG2]], [[Y_CAST]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn float @llvm.exp2.f32(float [[__YLOGX]])
; CHECK-NEXT:    ret float [[__EXP2]]
;
  %y.cast = uitofp i32 %y to float
  %powr = tail call afn nnan ninf float @_Z4powrff(float %x, float %y.cast)
  ret float %powr
}

define <2 x float> @test_powr_afn_nnan_ninf_v2f32_known_integral_sitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_nnan_ninf_v2f32_known_integral_sitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = sitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x float> @llvm.log2.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x float> [[__LOG2]], [[Y_CAST]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x float> @llvm.exp2.v2f32(<2 x float> [[__YLOGX]])
; CHECK-NEXT:    ret <2 x float> [[__EXP2]]
;
  %y.cast = sitofp <2 x i32> %y to <2 x float>
  %powr = tail call afn nnan ninf <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_v2f32_known_integral_uitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_v2f32_known_integral_uitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[POWR:%.*]] = tail call <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y_CAST]])
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %y.cast = uitofp <2 x i32> %y to <2 x float>
  %powr = tail call <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_v2f32_known_integral_uitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_v2f32_known_integral_uitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[POWR:%.*]] = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> [[X]], <2 x float> [[Y_CAST]])
; CHECK-NEXT:    ret <2 x float> [[POWR]]
;
  %y.cast = uitofp <2 x i32> %y to <2 x float>
  %powr = tail call afn <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %powr
}

define <2 x float> @test_powr_afn_nnan_ninf_v2f32_known_integral_uitofp(<2 x float> %x, <2 x i32> %y) {
; CHECK-LABEL: define <2 x float> @test_powr_afn_nnan_ninf_v2f32_known_integral_uitofp
; CHECK-SAME: (<2 x float> [[X:%.*]], <2 x i32> [[Y:%.*]]) {
; CHECK-NEXT:    [[Y_CAST:%.*]] = uitofp <2 x i32> [[Y]] to <2 x float>
; CHECK-NEXT:    [[__LOG2:%.*]] = call nnan ninf afn <2 x float> @llvm.log2.v2f32(<2 x float> [[X]])
; CHECK-NEXT:    [[__YLOGX:%.*]] = fmul nnan ninf afn <2 x float> [[__LOG2]], [[Y_CAST]]
; CHECK-NEXT:    [[__EXP2:%.*]] = call nnan ninf afn <2 x float> @llvm.exp2.v2f32(<2 x float> [[__YLOGX]])
; CHECK-NEXT:    ret <2 x float> [[__EXP2]]
;
  %y.cast = uitofp <2 x i32> %y to <2 x float>
  %powr = tail call afn nnan ninf <2 x float> @_Z4powrDv2_fS_(<2 x float> %x, <2 x float> %y.cast)
  ret <2 x float> %powr
}

attributes #0 = { minsize }
attributes #1 = { noinline }
attributes #2 = { strictfp }
attributes #3 = { nobuiltin }
