; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=amdgcn -mcpu=verde -verify-machineinstrs | FileCheck %s -check-prefix=SI
; RUN: llc < %s -mtriple=amdgcn -mcpu=hawaii -verify-machineinstrs | FileCheck %s  -check-prefix=GFX7
; RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -check-prefix=GFX10
; RUN: llc < %s -mtriple=amdgcn -mcpu=gfx1030 -verify-machineinstrs | FileCheck %s -check-prefix=GFX1030
; RUN: not --crash llc < %s -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs 2>&1 | FileCheck %s -check-prefix=GFX11-ERR

; RUN: llc < %s -global-isel -mtriple=amdgcn -mcpu=verde -verify-machineinstrs | FileCheck %s -check-prefix=G_SI
; RUN: llc < %s -global-isel -mtriple=amdgcn -mcpu=hawaii -verify-machineinstrs | FileCheck %s  -check-prefix=G_GFX7
; RUN: llc < %s -global-isel -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -check-prefix=G_GFX10
; RUN: llc < %s -global-isel -mtriple=amdgcn -mcpu=gfx1030 -verify-machineinstrs | FileCheck %s -check-prefix=G_GFX1030
; RUN: not --crash llc < %s -global-isel -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs 2>&1 | FileCheck %s -check-prefix=G_GFX11-ERR

; GFX11-ERR: LLVM ERROR: Cannot select: intrinsic %llvm.amdgcn.image.atomic.f
; G_GFX11-ERR: LLVM ERROR: cannot select: {{.*}} = G_AMDGPU_INTRIN_IMAGE_LOAD intrinsic(@llvm.amdgcn.image.atomic.f

declare float @llvm.amdgcn.image.atomic.fmin.1d.f32.f32(float, i32, <8 x i32>, i32, i32)
declare float @llvm.amdgcn.image.atomic.fmax.1d.f32.f32(float, i32, <8 x i32>, i32, i32)


define amdgpu_ps float @atomic_fmin_1d(<8 x i32> inreg %rsrc, float %data, i32 %s) {
; SI-LABEL: atomic_fmin_1d:
; SI:       ; %bb.0: ; %main_body
; SI-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 unorm glc
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; GFX7-LABEL: atomic_fmin_1d:
; GFX7:       ; %bb.0: ; %main_body
; GFX7-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 unorm glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: atomic_fmin_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX1030-LABEL: atomic_fmin_1d:
; GFX1030:       ; %bb.0: ; %main_body
; GFX1030-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    ; return to shader part epilog
;
; G_SI-LABEL: atomic_fmin_1d:
; G_SI:       ; %bb.0: ; %main_body
; G_SI-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 unorm glc
; G_SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; G_SI-NEXT:    ; return to shader part epilog
;
; G_GFX7-LABEL: atomic_fmin_1d:
; G_GFX7:       ; %bb.0: ; %main_body
; G_GFX7-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 unorm glc
; G_GFX7-NEXT:    s_waitcnt vmcnt(0)
; G_GFX7-NEXT:    ; return to shader part epilog
;
; G_GFX10-LABEL: atomic_fmin_1d:
; G_GFX10:       ; %bb.0: ; %main_body
; G_GFX10-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; G_GFX10-NEXT:    s_waitcnt vmcnt(0)
; G_GFX10-NEXT:    ; return to shader part epilog
;
; G_GFX1030-LABEL: atomic_fmin_1d:
; G_GFX1030:       ; %bb.0: ; %main_body
; G_GFX1030-NEXT:    image_atomic_fmin v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; G_GFX1030-NEXT:    s_waitcnt vmcnt(0)
; G_GFX1030-NEXT:    ; return to shader part epilog
main_body:
  %v = call float @llvm.amdgcn.image.atomic.fmin.1d.f32.f32(float %data, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret float %v
}

define amdgpu_ps float @atomic_fmax_1d(<8 x i32> inreg %rsrc, float %data, i32 %s) {
; SI-LABEL: atomic_fmax_1d:
; SI:       ; %bb.0: ; %main_body
; SI-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 unorm glc
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    ; return to shader part epilog
;
; GFX7-LABEL: atomic_fmax_1d:
; GFX7:       ; %bb.0: ; %main_body
; GFX7-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 unorm glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: atomic_fmax_1d:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX1030-LABEL: atomic_fmax_1d:
; GFX1030:       ; %bb.0: ; %main_body
; GFX1030-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; GFX1030-NEXT:    s_waitcnt vmcnt(0)
; GFX1030-NEXT:    ; return to shader part epilog
;
; G_SI-LABEL: atomic_fmax_1d:
; G_SI:       ; %bb.0: ; %main_body
; G_SI-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 unorm glc
; G_SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; G_SI-NEXT:    ; return to shader part epilog
;
; G_GFX7-LABEL: atomic_fmax_1d:
; G_GFX7:       ; %bb.0: ; %main_body
; G_GFX7-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 unorm glc
; G_GFX7-NEXT:    s_waitcnt vmcnt(0)
; G_GFX7-NEXT:    ; return to shader part epilog
;
; G_GFX10-LABEL: atomic_fmax_1d:
; G_GFX10:       ; %bb.0: ; %main_body
; G_GFX10-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; G_GFX10-NEXT:    s_waitcnt vmcnt(0)
; G_GFX10-NEXT:    ; return to shader part epilog
;
; G_GFX1030-LABEL: atomic_fmax_1d:
; G_GFX1030:       ; %bb.0: ; %main_body
; G_GFX1030-NEXT:    image_atomic_fmax v0, v1, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D unorm glc
; G_GFX1030-NEXT:    s_waitcnt vmcnt(0)
; G_GFX1030-NEXT:    ; return to shader part epilog
main_body:
  %v = call float @llvm.amdgcn.image.atomic.fmax.1d.f32.f32(float %data, i32 %s, <8 x i32> %rsrc, i32 0, i32 0)
  ret float %v
}
