; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64 -mattr=+zu | FileCheck %s

define i16 @i8(i8 %x) nounwind {
; CHECK-LABEL: i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpb $3, %dil
; CHECK-NEXT:    setzuae %al
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
  %t0 = icmp ugt i8 %x, 2
  %zext = zext i1 %t0 to i16
  ret i16 %zext
}

define i16 @i16(i16 %x) nounwind {
; CHECK-LABEL: i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpw $2, %di
; CHECK-NEXT:    setzub %al
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
  %t0 = icmp ult i16 %x, 2
  %if = select i1 %t0, i16 1, i16 0
  ret i16 %if
}

define i32 @i32(i32 %x) nounwind {
; CHECK-LABEL: i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpl $1, %edi
; CHECK-NEXT:    setzue %al
; CHECK-NEXT:    retq
  %t0 = icmp eq i32 %x, 1
  %if = select i1 %t0, i32 1, i32 0
  ret i32 %if
}

define i64 @i64(i64 %x) nounwind {
; CHECK-LABEL: i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpq $1, %rdi
; CHECK-NEXT:    setzune %al
; CHECK-NEXT:    retq
  %t0 = icmp ne i64 %x, 1
  %if = select i1 %t0, i64 1, i64 0
  ret i64 %if
}
