; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefix=X86

define i8 @ucmp.8.8(i8 %x, i8 %y) nounwind {
; X64-LABEL: ucmp.8.8:
; X64:       # %bb.0:
; X64-NEXT:    cmpb %sil, %dil
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.8.8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    retl
  %1 = call i8 @llvm.ucmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @ucmp.8.16(i16 %x, i16 %y) nounwind {
; X64-LABEL: ucmp.8.16:
; X64:       # %bb.0:
; X64-NEXT:    cmpw %si, %di
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.8.16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpw {{[0-9]+}}(%esp), %ax
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    retl
  %1 = call i8 @llvm.ucmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @ucmp.8.32(i32 %x, i32 %y) nounwind {
; X64-LABEL: ucmp.8.32:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.8.32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    retl
  %1 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @ucmp.8.64(i64 %x, i64 %y) nounwind {
; X64-LABEL: ucmp.8.64:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.8.64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    cmpl %ecx, %esi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    setb %al
; X86-NEXT:    cmpl %esi, %ecx
; X86-NEXT:    sbbl %edi, %edx
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl
  %1 = call i8 @llvm.ucmp(i64 %x, i64 %y)
  ret i8 %1
}

define i8 @ucmp.8.128(i128 %x, i128 %y) nounwind {
; X64-LABEL: ucmp.8.128:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rdi, %rdx
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    sbbq %rsi, %rax
; X64-NEXT:    setb %al
; X64-NEXT:    cmpq %rdx, %rdi
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.8.128:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    sbbl %ecx, %eax
; X86-NEXT:    setb %al
; X86-NEXT:    cmpl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %ebp, %esi
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    sbbl %edi, %ecx
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = call i8 @llvm.ucmp(i128 %x, i128 %y)
  ret i8 %1
}

define i32 @ucmp.32.32(i32 %x, i32 %y) nounwind {
; X64-LABEL: ucmp.32.32:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.32.32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %eax
; X86-NEXT:    retl
  %1 = call i32 @llvm.ucmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @ucmp.32.64(i64 %x, i64 %y) nounwind {
; X64-LABEL: ucmp.32.64:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.32.64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %eax, %edx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %ecx, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %edx, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movsbl %bl, %eax
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %1 = call i32 @llvm.ucmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @ucmp.64.64(i64 %x, i64 %y) nounwind {
; X64-LABEL: ucmp.64.64:
; X64:       # %bb.0:
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbq %al, %rax
; X64-NEXT:    retq
;
; X86-LABEL: ucmp.64.64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl %eax, %edx
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %ecx, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %edx, %eax
; X86-NEXT:    sbbl %esi, %ecx
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movsbl %bl, %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
  %1 = call i64 @llvm.ucmp(i64 %x, i64 %y)
  ret i64 %1
}

define i4 @ucmp_narrow_result(i32 %x, i32 %y) nounwind {
; X64-LABEL: ucmp_narrow_result:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_narrow_result:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    retl
  %1 = call i4 @llvm.ucmp(i32 %x, i32 %y)
  ret i4 %1
}

define i8 @ucmp_narrow_op(i62 %x, i62 %y) nounwind {
; X64-LABEL: ucmp_narrow_op:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $4611686018427387903, %rax # imm = 0x3FFFFFFFFFFFFFFF
; X64-NEXT:    andq %rax, %rsi
; X64-NEXT:    andq %rax, %rdi
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_narrow_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl $1073741823, %ecx # imm = 0x3FFFFFFF
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    andl %ecx, %edx
; X86-NEXT:    andl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    cmpl %esi, %edi
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    setb %al
; X86-NEXT:    cmpl %edi, %esi
; X86-NEXT:    sbbl %ecx, %edx
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl
  %1 = call i8 @llvm.ucmp(i62 %x, i62 %y)
  ret i8 %1
}

define i141 @ucmp_wide_result(i32 %x, i32 %y) nounwind {
; X64-LABEL: ucmp_wide_result:
; X64:       # %bb.0:
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbq %al, %rax
; X64-NEXT:    movq %rax, %rdx
; X64-NEXT:    sarq $63, %rdx
; X64-NEXT:    movl %edx, %ecx
; X64-NEXT:    andl $8191, %ecx # imm = 0x1FFF
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_wide_result:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %cl
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movsbl %cl, %ecx
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    sarl $31, %ecx
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    andl $8191, %ecx # imm = 0x1FFF
; X86-NEXT:    movw %cx, 16(%eax)
; X86-NEXT:    retl $4
  %1 = call i141 @llvm.ucmp(i32 %x, i32 %y)
  ret i141 %1
}

define i8 @ucmp_wide_op(i109 %x, i109 %y) nounwind {
; X64-LABEL: ucmp_wide_op:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $35184372088831, %rax # imm = 0x1FFFFFFFFFFF
; X64-NEXT:    andq %rax, %rsi
; X64-NEXT:    andq %rax, %rcx
; X64-NEXT:    cmpq %rdi, %rdx
; X64-NEXT:    movq %rcx, %rax
; X64-NEXT:    sbbq %rsi, %rax
; X64-NEXT:    setb %al
; X64-NEXT:    cmpq %rdx, %rdi
; X64-NEXT:    sbbq %rcx, %rsi
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_wide_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl $8191, %ecx # imm = 0x1FFF
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    andl %ecx, %edx
; X86-NEXT:    andl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    sbbl %edi, %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, %eax
; X86-NEXT:    sbbl %esi, %eax
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    setb %al
; X86-NEXT:    cmpl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    sbbl %ebx, %esi
; X86-NEXT:    sbbl %ecx, %edx
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %1 = call i8 @llvm.ucmp(i109 %x, i109 %y)
  ret i8 %1
}

define i41 @ucmp_uncommon_types(i7 %x, i7 %y) nounwind {
; X64-LABEL: ucmp_uncommon_types:
; X64:       # %bb.0:
; X64-NEXT:    andb $127, %sil
; X64-NEXT:    andb $127, %dil
; X64-NEXT:    cmpb %sil, %dil
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbq %al, %rax
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_uncommon_types:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andb $127, %al
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    andb $127, %cl
; X86-NEXT:    cmpb %al, %cl
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    retl
  %1 = call i41 @llvm.ucmp(i7 %x, i7 %y)
  ret i41 %1
}

define <4 x i32> @ucmp_normal_vectors(<4 x i32> %x, <4 x i32> %y) nounwind {
; X64-LABEL: ucmp_normal_vectors:
; X64:       # %bb.0:
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,3,3,3]
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm3, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; X64-NEXT:    movdqa %xmm2, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_normal_vectors:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    seta %dl
; X86-NEXT:    sbbb $0, %dl
; X86-NEXT:    movsbl %dl, %edx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    seta %bl
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movsbl %bl, %edi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    seta %bl
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movsbl %bl, %esi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %cl
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movsbl %cl, %ecx
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %esi, 8(%eax)
; X86-NEXT:    movl %edi, 4(%eax)
; X86-NEXT:    movl %edx, (%eax)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
  %1 = call <4 x i32> @llvm.ucmp(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %1
}

define <4 x i8> @ucmp_narrow_vec_result(<4 x i32> %x, <4 x i32> %y) nounwind {
; X64-LABEL: ucmp_narrow_vec_result:
; X64:       # %bb.0:
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,1,1]
; X64-NEXT:    movd %xmm2, %edx
; X64-NEXT:    cmpl %ecx, %edx
; X64-NEXT:    seta %cl
; X64-NEXT:    sbbb $0, %cl
; X64-NEXT:    movzbl %cl, %ecx
; X64-NEXT:    shll $8, %ecx
; X64-NEXT:    orl %eax, %ecx
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; X64-NEXT:    movd %xmm2, %edx
; X64-NEXT:    cmpl %eax, %edx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    shll $16, %eax
; X64-NEXT:    orl %ecx, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X64-NEXT:    movd %xmm0, %edx
; X64-NEXT:    cmpl %ecx, %edx
; X64-NEXT:    seta %cl
; X64-NEXT:    sbbb $0, %cl
; X64-NEXT:    movzbl %cl, %ecx
; X64-NEXT:    shll $24, %ecx
; X64-NEXT:    orl %eax, %ecx
; X64-NEXT:    movd %ecx, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_narrow_vec_result:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %cl
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    seta %ch
; X86-NEXT:    sbbb $0, %ch
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    seta %bl
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    seta %dl
; X86-NEXT:    sbbb $0, %dl
; X86-NEXT:    movb %dl, 3(%eax)
; X86-NEXT:    movb %bl, 2(%eax)
; X86-NEXT:    movb %ch, 1(%eax)
; X86-NEXT:    movb %cl, (%eax)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
  %1 = call <4 x i8> @llvm.ucmp(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i8> %1
}

define <4 x i32> @ucmp_narrow_vec_op(<4 x i8> %x, <4 x i8> %y) nounwind {
; X64-LABEL: ucmp_narrow_vec_op:
; X64:       # %bb.0:
; X64-NEXT:    pxor %xmm2, %xmm2
; X64-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3],xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; X64-NEXT:    pextrw $0, %xmm1, %eax
; X64-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; X64-NEXT:    pextrw $0, %xmm0, %edx
; X64-NEXT:    movdqa %xmm0, %xmm3
; X64-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[3,3,3,3]
; X64-NEXT:    movd %xmm0, %esi
; X64-NEXT:    cmpl %ecx, %esi
; X64-NEXT:    seta %cl
; X64-NEXT:    sbbb $0, %cl
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm0, %esi
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,2,3]
; X64-NEXT:    movd %xmm0, %edi
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    movsbl %cl, %ecx
; X64-NEXT:    movd %ecx, %xmm0
; X64-NEXT:    seta %cl
; X64-NEXT:    sbbb $0, %cl
; X64-NEXT:    movsbl %cl, %ecx
; X64-NEXT:    movd %ecx, %xmm2
; X64-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; X64-NEXT:    cmpl %eax, %edx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,1,1]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_narrow_vec_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %dl
; X86-NEXT:    seta %dl
; X86-NEXT:    sbbb $0, %dl
; X86-NEXT:    movsbl %dl, %edx
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %bl
; X86-NEXT:    seta %bl
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movsbl %bl, %esi
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    seta %ch
; X86-NEXT:    sbbb $0, %ch
; X86-NEXT:    movsbl %ch, %edi
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    seta %cl
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movsbl %cl, %ecx
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %edi, 8(%eax)
; X86-NEXT:    movl %esi, 4(%eax)
; X86-NEXT:    movl %edx, (%eax)
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
  %1 = call <4 x i32> @llvm.ucmp(<4 x i8> %x, <4 x i8> %y)
  ret <4 x i32> %1
}

define <16 x i32> @ucmp_wide_vec_result(<16 x i8> %x, <16 x i8> %y) nounwind {
; X64-LABEL: ucmp_wide_vec_result:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rbp
; X64-NEXT:    pushq %r15
; X64-NEXT:    pushq %r14
; X64-NEXT:    pushq %r13
; X64-NEXT:    pushq %r12
; X64-NEXT:    pushq %rbx
; X64-NEXT:    pxor %xmm2, %xmm2
; X64-NEXT:    movdqa %xmm1, %xmm4
; X64-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; X64-NEXT:    pextrw $0, %xmm4, %edx
; X64-NEXT:    movdqa %xmm4, %xmm3
; X64-NEXT:    pextrw $4, %xmm4, %r9d
; X64-NEXT:    movdqa %xmm4, %xmm5
; X64-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[3,3,3,3]
; X64-NEXT:    movd %xmm4, %eax
; X64-NEXT:    movdqa %xmm0, %xmm6
; X64-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; X64-NEXT:    pextrw $0, %xmm6, %esi
; X64-NEXT:    movdqa %xmm6, %xmm4
; X64-NEXT:    pextrw $4, %xmm6, %r10d
; X64-NEXT:    punpcklwd {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[3,3,3,3]
; X64-NEXT:    movd %xmm7, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movl %eax, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[2,3,2,3]
; X64-NEXT:    movd %xmm7, %ecx
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; X64-NEXT:    movd %xmm7, %edi
; X64-NEXT:    cmpl %ecx, %edi
; X64-NEXT:    seta %cl
; X64-NEXT:    sbbb $0, %cl
; X64-NEXT:    movsbl %cl, %eax
; X64-NEXT:    movl %eax, {{[-0-9]+}}(%r{{[sb]}}p) # 4-byte Spill
; X64-NEXT:    cmpl %edx, %esi
; X64-NEXT:    seta %dl
; X64-NEXT:    sbbb $0, %dl
; X64-NEXT:    movsbl %dl, %edx
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,1,1]
; X64-NEXT:    movd %xmm5, %esi
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,1,1]
; X64-NEXT:    movd %xmm5, %edi
; X64-NEXT:    cmpl %esi, %edi
; X64-NEXT:    seta %sil
; X64-NEXT:    sbbb $0, %sil
; X64-NEXT:    movsbl %sil, %esi
; X64-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[3,3,3,3]
; X64-NEXT:    movd %xmm5, %edi
; X64-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[3,3,3,3]
; X64-NEXT:    movd %xmm5, %r8d
; X64-NEXT:    cmpl %edi, %r8d
; X64-NEXT:    seta %dil
; X64-NEXT:    sbbb $0, %dil
; X64-NEXT:    movsbl %dil, %edi
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[2,3,2,3]
; X64-NEXT:    movd %xmm5, %r8d
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; X64-NEXT:    movd %xmm5, %r11d
; X64-NEXT:    cmpl %r8d, %r11d
; X64-NEXT:    seta %r8b
; X64-NEXT:    sbbb $0, %r8b
; X64-NEXT:    movsbl %r8b, %r8d
; X64-NEXT:    cmpl %r9d, %r10d
; X64-NEXT:    seta %r9b
; X64-NEXT:    sbbb $0, %r9b
; X64-NEXT:    movsbl %r9b, %r9d
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,1,1]
; X64-NEXT:    movd %xmm3, %r10d
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,1,1]
; X64-NEXT:    movd %xmm3, %r11d
; X64-NEXT:    cmpl %r10d, %r11d
; X64-NEXT:    seta %r10b
; X64-NEXT:    sbbb $0, %r10b
; X64-NEXT:    movsbl %r10b, %r10d
; X64-NEXT:    punpckhbw {{.*#+}} xmm1 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; X64-NEXT:    pextrw $0, %xmm1, %ebx
; X64-NEXT:    movdqa %xmm1, %xmm4
; X64-NEXT:    pextrw $4, %xmm1, %r11d
; X64-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1],xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm3, %r14d
; X64-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm2[8],xmm0[9],xmm2[9],xmm0[10],xmm2[10],xmm0[11],xmm2[11],xmm0[12],xmm2[12],xmm0[13],xmm2[13],xmm0[14],xmm2[14],xmm0[15],xmm2[15]
; X64-NEXT:    pextrw $0, %xmm0, %r15d
; X64-NEXT:    movdqa %xmm0, %xmm5
; X64-NEXT:    pextrw $4, %xmm0, %ebp
; X64-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3]
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[3,3,3,3]
; X64-NEXT:    movd %xmm3, %r12d
; X64-NEXT:    cmpl %r14d, %r12d
; X64-NEXT:    seta %r14b
; X64-NEXT:    sbbb $0, %r14b
; X64-NEXT:    movsbl %r14b, %r14d
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm3, %r12d
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; X64-NEXT:    movd %xmm3, %r13d
; X64-NEXT:    cmpl %r12d, %r13d
; X64-NEXT:    seta %r12b
; X64-NEXT:    sbbb $0, %r12b
; X64-NEXT:    cmpl %ebx, %r15d
; X64-NEXT:    seta %bl
; X64-NEXT:    sbbb $0, %bl
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm1, %r15d
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    movd %xmm0, %r13d
; X64-NEXT:    cmpl %r15d, %r13d
; X64-NEXT:    seta %r15b
; X64-NEXT:    sbbb $0, %r15b
; X64-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[3,3,3,3]
; X64-NEXT:    movd %xmm0, %r13d
; X64-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[3,3,3,3]
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    cmpl %r13d, %eax
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[2,3,2,3]
; X64-NEXT:    movd %xmm0, %r13d
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[2,3,2,3]
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %r13d, %ecx
; X64-NEXT:    movsbl %r12b, %ecx
; X64-NEXT:    movsbl %bl, %ebx
; X64-NEXT:    movsbl %r15b, %r15d
; X64-NEXT:    movd {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 4-byte Folded Reload
; X64-NEXT:    # xmm2 = mem[0],zero,zero,zero
; X64-NEXT:    movd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 4-byte Folded Reload
; X64-NEXT:    # xmm3 = mem[0],zero,zero,zero
; X64-NEXT:    movd %edx, %xmm0
; X64-NEXT:    movd %esi, %xmm6
; X64-NEXT:    movd %edi, %xmm7
; X64-NEXT:    movd %r8d, %xmm8
; X64-NEXT:    movd %r9d, %xmm1
; X64-NEXT:    movd %r10d, %xmm9
; X64-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; X64-NEXT:    movd %r14d, %xmm10
; X64-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; X64-NEXT:    movd %ecx, %xmm6
; X64-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; X64-NEXT:    movd %ebx, %xmm2
; X64-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; X64-NEXT:    movd %r15d, %xmm3
; X64-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm8[0]
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm7
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm8
; X64-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm10[0],xmm6[1],xmm10[1]
; X64-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm6[0]
; X64-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; X64-NEXT:    cmpl %r11d, %ebp
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,1,1]
; X64-NEXT:    movd %xmm4, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,1,1]
; X64-NEXT:    movd %xmm4, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movsbl %al, %eax
; X64-NEXT:    movd %eax, %xmm4
; X64-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm8[0]
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    popq %rbp
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_wide_vec_result:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    movb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    movb {{[0-9]+}}(%esp), %dh
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %bh
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    seta %cl
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %bh
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %bl
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %dh
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %ch
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %ah
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %dl
; X86-NEXT:    seta %bl
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, (%esp) # 1-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %bh
; X86-NEXT:    sbbb $0, %bh
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %edi
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %ebp
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %esi
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %edx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpb {{[0-9]+}}(%esp), %al
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movsbl %al, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %ecx, 60(%eax)
; X86-NEXT:    movl %edx, 56(%eax)
; X86-NEXT:    movl %esi, 52(%eax)
; X86-NEXT:    movl %ebp, 48(%eax)
; X86-NEXT:    movl %edi, 44(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 40(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; X86-NEXT:    movsbl %bh, %ecx
; X86-NEXT:    movl %ecx, 36(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movsbl (%esp), %edx # 1-byte Folded Reload
; X86-NEXT:    movl %edx, 32(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 1-byte Folded Reload
; X86-NEXT:    movsbl %bl, %edi
; X86-NEXT:    movl %edi, 28(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %edi # 1-byte Folded Reload
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 1-byte Folded Reload
; X86-NEXT:    movl %ebx, 24(%eax)
; X86-NEXT:    movl %edi, 20(%eax)
; X86-NEXT:    movl %edx, 16(%eax)
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl %esi, 8(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    movsbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movl %ecx, (%eax)
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
  %1 = call <16 x i32> @llvm.ucmp(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i32> %1
}

define <16 x i8> @ucmp_wide_vec_op(<16 x i32> %x, <16 x i32> %y) nounwind {
; X64-LABEL: ucmp_wide_vec_op:
; X64:       # %bb.0:
; X64-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[3,3,3,3]
; X64-NEXT:    movd %xmm8, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm8 = xmm3[3,3,3,3]
; X64-NEXT:    movd %xmm8, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm8
; X64-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[2,3,2,3]
; X64-NEXT:    movd %xmm9, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm9 = xmm3[2,3,2,3]
; X64-NEXT:    movd %xmm9, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm9
; X64-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3],xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; X64-NEXT:    movd %xmm7, %eax
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm8
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,1,1]
; X64-NEXT:    movd %xmm7, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,1,1]
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0],xmm3[0],xmm8[1],xmm3[1],xmm8[2],xmm3[2],xmm8[3],xmm3[3],xmm8[4],xmm3[4],xmm8[5],xmm3[5],xmm8[6],xmm3[6],xmm8[7],xmm3[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1],xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[3,3,3,3]
; X64-NEXT:    movd %xmm3, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[3,3,3,3]
; X64-NEXT:    movd %xmm3, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; X64-NEXT:    movd %xmm7, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[2,3,2,3]
; X64-NEXT:    movd %xmm7, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm7
; X64-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1],xmm7[2],xmm3[2],xmm7[3],xmm3[3],xmm7[4],xmm3[4],xmm7[5],xmm3[5],xmm7[6],xmm3[6],xmm7[7],xmm3[7]
; X64-NEXT:    movd %xmm6, %eax
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,1,1]
; X64-NEXT:    movd %xmm6, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm7[0],xmm3[1],xmm7[1],xmm3[2],xmm7[2],xmm3[3],xmm7[3]
; X64-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1]
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[3,3,3,3]
; X64-NEXT:    movd %xmm2, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,3,3,3]
; X64-NEXT:    movd %xmm2, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[2,3,2,3]
; X64-NEXT:    movd %xmm6, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[2,3,2,3]
; X64-NEXT:    movd %xmm6, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm6
; X64-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,1,1]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1],xmm2[2],xmm1[2],xmm2[3],xmm1[3],xmm2[4],xmm1[4],xmm2[5],xmm1[5],xmm2[6],xmm1[6],xmm2[7],xmm1[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3]
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[3,3,3,3]
; X64-NEXT:    movd %xmm1, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[3,3,3,3]
; X64-NEXT:    movd %xmm1, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; X64-NEXT:    movd %xmm5, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[2,3,2,3]
; X64-NEXT:    movd %xmm5, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm5
; X64-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1],xmm5[2],xmm1[2],xmm5[3],xmm1[3],xmm5[4],xmm1[4],xmm5[5],xmm1[5],xmm5[6],xmm1[6],xmm5[7],xmm1[7]
; X64-NEXT:    movd %xmm4, %eax
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,1,1]
; X64-NEXT:    movd %xmm4, %eax
; X64-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    movd %xmm0, %ecx
; X64-NEXT:    cmpl %eax, %ecx
; X64-NEXT:    seta %al
; X64-NEXT:    sbbb $0, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1],xmm1[2],xmm5[2],xmm1[3],xmm5[3]
; X64-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; X64-NEXT:    movdqa %xmm1, %xmm0
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_wide_vec_op:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %al
; X86-NEXT:    sbbb $0, %al
; X86-NEXT:    movb %al, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    seta %bh
; X86-NEXT:    sbbb $0, %bh
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %bl
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %dh
; X86-NEXT:    sbbb $0, %dh
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %ch
; X86-NEXT:    sbbb $0, %ch
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %dl
; X86-NEXT:    sbbb $0, %dl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    seta %cl
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb %cl, 15(%eax)
; X86-NEXT:    movb %dl, 14(%eax)
; X86-NEXT:    movb %ch, 13(%eax)
; X86-NEXT:    movb %dh, 12(%eax)
; X86-NEXT:    movb %bl, 11(%eax)
; X86-NEXT:    movb %bh, 10(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 9(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 8(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 7(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 6(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 5(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 4(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 3(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 2(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, 1(%eax)
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    movb %cl, (%eax)
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
  %1 = call <16 x i8> @llvm.ucmp(<16 x i32> %x, <16 x i32> %y)
  ret <16 x i8> %1
}

define <17 x i2> @ucmp_uncommon_vectors(<17 x i71> %x, <17 x i71> %y) nounwind {
; X64-LABEL: ucmp_uncommon_vectors:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rbp
; X64-NEXT:    pushq %r15
; X64-NEXT:    pushq %r14
; X64-NEXT:    pushq %r13
; X64-NEXT:    pushq %r12
; X64-NEXT:    pushq %rbx
; X64-NEXT:    subq $120, %rsp
; X64-NEXT:    movq %r9, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %rcx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %rsi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq %rdi, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    andl $127, %edx
; X64-NEXT:    movq %rdx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    andl $127, %r8d
; X64-NEXT:    movq %r8, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, (%rsp) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; X64-NEXT:    andl $127, %r12d
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r14
; X64-NEXT:    andl $127, %r14d
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq %rax, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rbx
; X64-NEXT:    andl $127, %ebx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; X64-NEXT:    andl $127, %r15d
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rbp
; X64-NEXT:    andl $127, %ebp
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; X64-NEXT:    andl $127, %r11d
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r13
; X64-NEXT:    andl $127, %r13d
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; X64-NEXT:    andl $127, %r10d
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; X64-NEXT:    andl $127, %esi
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    andl $127, %edi
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    andl $127, %eax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; X64-NEXT:    andl $127, %edx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r9
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r8
; X64-NEXT:    cmpq %r9, %r8
; X64-NEXT:    movq %rdx, %rcx
; X64-NEXT:    sbbq %rax, %rcx
; X64-NEXT:    setb %cl
; X64-NEXT:    cmpq %r8, %r9
; X64-NEXT:    sbbq %rdx, %rax
; X64-NEXT:    sbbb $0, %cl
; X64-NEXT:    movb %cl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    cmpq %rax, %rcx
; X64-NEXT:    movq %rdi, %rdx
; X64-NEXT:    sbbq %rsi, %rdx
; X64-NEXT:    setb %dl
; X64-NEXT:    cmpq %rcx, %rax
; X64-NEXT:    sbbq %rdi, %rsi
; X64-NEXT:    sbbb $0, %dl
; X64-NEXT:    movb %dl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    cmpq %rax, %rcx
; X64-NEXT:    movq %r10, %rdx
; X64-NEXT:    sbbq %r13, %rdx
; X64-NEXT:    setb %dl
; X64-NEXT:    cmpq %rcx, %rax
; X64-NEXT:    sbbq %r10, %r13
; X64-NEXT:    sbbb $0, %dl
; X64-NEXT:    movb %dl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    cmpq %rax, %rcx
; X64-NEXT:    movq %r11, %rdx
; X64-NEXT:    sbbq %rbp, %rdx
; X64-NEXT:    setb %dl
; X64-NEXT:    cmpq %rcx, %rax
; X64-NEXT:    sbbq %r11, %rbp
; X64-NEXT:    sbbb $0, %dl
; X64-NEXT:    movb %dl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    cmpq %rax, %rcx
; X64-NEXT:    movq %r15, %rdx
; X64-NEXT:    sbbq %rbx, %rdx
; X64-NEXT:    setb %dl
; X64-NEXT:    cmpq %rcx, %rax
; X64-NEXT:    sbbq %r15, %rbx
; X64-NEXT:    sbbb $0, %dl
; X64-NEXT:    movb %dl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    cmpq %rax, %rcx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; X64-NEXT:    movq %rsi, %rdx
; X64-NEXT:    sbbq %r14, %rdx
; X64-NEXT:    setb %dl
; X64-NEXT:    cmpq %rcx, %rax
; X64-NEXT:    sbbq %rsi, %r14
; X64-NEXT:    sbbb $0, %dl
; X64-NEXT:    movb %dl, {{[-0-9]+}}(%r{{[sb]}}p) # 1-byte Spill
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; X64-NEXT:    cmpq %rcx, %rdx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rsi # 8-byte Reload
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    sbbq %r12, %rax
; X64-NEXT:    setb %r13b
; X64-NEXT:    cmpq %rdx, %rcx
; X64-NEXT:    sbbq %rsi, %r12
; X64-NEXT:    sbbb $0, %r13b
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; X64-NEXT:    cmpq %rdx, %rsi
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdi # 8-byte Reload
; X64-NEXT:    movq %rdi, %rcx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %rcx
; X64-NEXT:    setb %bpl
; X64-NEXT:    cmpq %rsi, %rdx
; X64-NEXT:    sbbq %rdi, %rax
; X64-NEXT:    sbbb $0, %bpl
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    cmpq %rsi, %rdi
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq %rcx, %rdx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %rdx
; X64-NEXT:    setb %r11b
; X64-NEXT:    cmpq %rdi, %rsi
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    sbbb $0, %r11b
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r8
; X64-NEXT:    cmpq %rdi, %r8
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq %rcx, %rsi
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %rsi
; X64-NEXT:    setb %sil
; X64-NEXT:    cmpq %r8, %rdi
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    sbbb $0, %sil
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r8
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r9
; X64-NEXT:    cmpq %r8, %r9
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq %rcx, %rdi
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %rdi
; X64-NEXT:    setb %dil
; X64-NEXT:    cmpq %r9, %r8
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    sbbb $0, %dil
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r9
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; X64-NEXT:    cmpq %r9, %r10
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq %rcx, %r8
; X64-NEXT:    movq (%rsp), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %r8
; X64-NEXT:    setb %r8b
; X64-NEXT:    cmpq %r10, %r9
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    sbbb $0, %r8b
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rbx
; X64-NEXT:    cmpq %r10, %rbx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    movq %rcx, %r9
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %r9
; X64-NEXT:    setb %r9b
; X64-NEXT:    cmpq %rbx, %r10
; X64-NEXT:    sbbq %rcx, %rax
; X64-NEXT:    sbbb $0, %r9b
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rbx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    cmpq %rax, %rbx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Reload
; X64-NEXT:    movq %rdx, %r10
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    sbbq %rcx, %r10
; X64-NEXT:    setb %r10b
; X64-NEXT:    cmpq %rbx, %rax
; X64-NEXT:    sbbq %rdx, %rcx
; X64-NEXT:    sbbb $0, %r10b
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r14
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    cmpq %rcx, %r14
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Reload
; X64-NEXT:    movq %rdx, %rbx
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %rbx
; X64-NEXT:    setb %bl
; X64-NEXT:    cmpq %r14, %rcx
; X64-NEXT:    sbbq %rdx, %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; X64-NEXT:    sbbb $0, %bl
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    cmpq %rcx, %r15
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Reload
; X64-NEXT:    movq %rdx, %r14
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rax # 8-byte Reload
; X64-NEXT:    sbbq %rax, %r14
; X64-NEXT:    setb %r14b
; X64-NEXT:    cmpq %r15, %rcx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; X64-NEXT:    sbbq %rdx, %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; X64-NEXT:    sbbb $0, %r14b
; X64-NEXT:    cmpq %r12, %rax
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdx # 8-byte Reload
; X64-NEXT:    movq %rdx, %r15
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rcx # 8-byte Reload
; X64-NEXT:    sbbq %rcx, %r15
; X64-NEXT:    setb %r15b
; X64-NEXT:    cmpq %rax, %r12
; X64-NEXT:    movzbl {{[-0-9]+}}(%r{{[sb]}}p), %eax # 1-byte Folded Reload
; X64-NEXT:    movd %eax, %xmm0
; X64-NEXT:    movzbl {{[-0-9]+}}(%r{{[sb]}}p), %eax # 1-byte Folded Reload
; X64-NEXT:    movd %eax, %xmm1
; X64-NEXT:    movzbl {{[-0-9]+}}(%r{{[sb]}}p), %eax # 1-byte Folded Reload
; X64-NEXT:    movd %eax, %xmm2
; X64-NEXT:    movzbl {{[-0-9]+}}(%r{{[sb]}}p), %eax # 1-byte Folded Reload
; X64-NEXT:    movd %eax, %xmm3
; X64-NEXT:    movzbl {{[-0-9]+}}(%r{{[sb]}}p), %eax # 1-byte Folded Reload
; X64-NEXT:    movd %eax, %xmm4
; X64-NEXT:    movzbl {{[-0-9]+}}(%r{{[sb]}}p), %eax # 1-byte Folded Reload
; X64-NEXT:    movd %eax, %xmm5
; X64-NEXT:    movzbl %r13b, %eax
; X64-NEXT:    movd %eax, %xmm6
; X64-NEXT:    movzbl %bpl, %eax
; X64-NEXT:    movd %eax, %xmm7
; X64-NEXT:    movzbl %r11b, %eax
; X64-NEXT:    movd %eax, %xmm8
; X64-NEXT:    movzbl %sil, %eax
; X64-NEXT:    movd %eax, %xmm9
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    movd %eax, %xmm10
; X64-NEXT:    movzbl %r8b, %eax
; X64-NEXT:    movd %eax, %xmm11
; X64-NEXT:    movzbl %r9b, %eax
; X64-NEXT:    movd %eax, %xmm12
; X64-NEXT:    movzbl %r10b, %eax
; X64-NEXT:    movd %eax, %xmm13
; X64-NEXT:    movzbl %bl, %eax
; X64-NEXT:    movd %eax, %xmm14
; X64-NEXT:    movzbl %r14b, %eax
; X64-NEXT:    movd %eax, %xmm15
; X64-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3],xmm1[4],xmm0[4],xmm1[5],xmm0[5],xmm1[6],xmm0[6],xmm1[7],xmm0[7]
; X64-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1],xmm3[2],xmm2[2],xmm3[3],xmm2[3],xmm3[4],xmm2[4],xmm3[5],xmm2[5],xmm3[6],xmm2[6],xmm3[7],xmm2[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1],xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; X64-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3],xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; X64-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3],xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm7 = xmm7[0],xmm5[0],xmm7[1],xmm5[1],xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; X64-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm3[0],xmm7[1],xmm3[1]
; X64-NEXT:    punpcklbw {{.*#+}} xmm9 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3],xmm9[4],xmm8[4],xmm9[5],xmm8[5],xmm9[6],xmm8[6],xmm9[7],xmm8[7]
; X64-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3],xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm11 = xmm11[0],xmm9[0],xmm11[1],xmm9[1],xmm11[2],xmm9[2],xmm11[3],xmm9[3]
; X64-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm12[0],xmm13[1],xmm12[1],xmm13[2],xmm12[2],xmm13[3],xmm12[3],xmm13[4],xmm12[4],xmm13[5],xmm12[5],xmm13[6],xmm12[6],xmm13[7],xmm12[7]
; X64-NEXT:    punpcklbw {{.*#+}} xmm15 = xmm15[0],xmm14[0],xmm15[1],xmm14[1],xmm15[2],xmm14[2],xmm15[3],xmm14[3],xmm15[4],xmm14[4],xmm15[5],xmm14[5],xmm15[6],xmm14[6],xmm15[7],xmm14[7]
; X64-NEXT:    punpcklwd {{.*#+}} xmm15 = xmm15[0],xmm13[0],xmm15[1],xmm13[1],xmm15[2],xmm13[2],xmm15[3],xmm13[3]
; X64-NEXT:    punpckldq {{.*#+}} xmm15 = xmm15[0],xmm11[0],xmm15[1],xmm11[1]
; X64-NEXT:    punpcklqdq {{.*#+}} xmm15 = xmm15[0],xmm7[0]
; X64-NEXT:    sbbq %rdx, %rcx
; X64-NEXT:    sbbb $0, %r15b
; X64-NEXT:    movzbl %r15b, %eax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    movq {{[-0-9]+}}(%r{{[sb]}}p), %rdi # 8-byte Reload
; X64-NEXT:    movb %al, 4(%rdi)
; X64-NEXT:    movdqa %xmm15, -{{[0-9]+}}(%rsp)
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    andl $3, %ecx
; X64-NEXT:    leaq (%rcx,%rax,4), %rax
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    andl $3, %ecx
; X64-NEXT:    shll $4, %ecx
; X64-NEXT:    orq %rax, %rcx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    shll $6, %eax
; X64-NEXT:    orq %rcx, %rax
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    andl $3, %ecx
; X64-NEXT:    shll $8, %ecx
; X64-NEXT:    orq %rax, %rcx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    shll $10, %eax
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %edx
; X64-NEXT:    andl $3, %edx
; X64-NEXT:    shll $12, %edx
; X64-NEXT:    orq %rax, %rdx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %esi
; X64-NEXT:    andl $3, %esi
; X64-NEXT:    shll $14, %esi
; X64-NEXT:    orq %rdx, %rsi
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    shll $16, %eax
; X64-NEXT:    orq %rsi, %rax
; X64-NEXT:    orq %rcx, %rax
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    andl $3, %ecx
; X64-NEXT:    shll $18, %ecx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %edx
; X64-NEXT:    andl $3, %edx
; X64-NEXT:    shll $20, %edx
; X64-NEXT:    orq %rcx, %rdx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    andl $3, %ecx
; X64-NEXT:    shll $22, %ecx
; X64-NEXT:    orq %rdx, %rcx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %edx
; X64-NEXT:    andl $3, %edx
; X64-NEXT:    shll $24, %edx
; X64-NEXT:    orq %rcx, %rdx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    andl $3, %ecx
; X64-NEXT:    shlq $26, %rcx
; X64-NEXT:    orq %rdx, %rcx
; X64-NEXT:    orq %rax, %rcx
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    shlq $28, %rax
; X64-NEXT:    movzbl -{{[0-9]+}}(%rsp), %edx
; X64-NEXT:    andl $3, %edx
; X64-NEXT:    shlq $30, %rdx
; X64-NEXT:    orq %rax, %rdx
; X64-NEXT:    orq %rcx, %rdx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movl %edx, (%rdi)
; X64-NEXT:    addq $120, %rsp
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    popq %rbp
; X64-NEXT:    retq
;
; X86-LABEL: ucmp_uncommon_vectors:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $132, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    andl $127, %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $127, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    andl $127, %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    andl $127, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl $0, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, %esi
; X86-NEXT:    sbbl %eax, %esi
; X86-NEXT:    movl %edi, %esi
; X86-NEXT:    sbbl %edx, %esi
; X86-NEXT:    movl $0, %esi
; X86-NEXT:    sbbl %esi, %esi
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    sbbl %ebx, %eax
; X86-NEXT:    sbbl %edi, %edx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    sbbl %ebp, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    sbbl %ebp, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    sbbl %ebp, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    sbbl %ebp, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    sbbl %ebp, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl %eax, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    sbbl %ebp, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    sbbl %ebx, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %ebp, %ebx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    sbbl %ebx, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %ebp, %ebx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    sbbl %edx, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, %edi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    sbbl %ebx, %edi
; X86-NEXT:    movl $0, %edi
; X86-NEXT:    sbbl %edi, %edi
; X86-NEXT:    setb %cl
; X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    sbbl %ebp, %ebx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl %eax, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %edx
; X86-NEXT:    sbbl %esi, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, %edx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    sbbl %ebx, %edx
; X86-NEXT:    movl $0, %edx
; X86-NEXT:    sbbl %edx, %edx
; X86-NEXT:    setb %dl
; X86-NEXT:    cmpl %ecx, %eax
; X86-NEXT:    sbbl %edi, %esi
; X86-NEXT:    sbbl %ebp, %ebx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %dl
; X86-NEXT:    movb %dl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl %eax, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    sbbl %esi, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    sbbl %edx, %ebx
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %ebx, %ebx
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, %eax
; X86-NEXT:    sbbl %edi, %esi
; X86-NEXT:    sbbl %ebp, %edx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmpl %eax, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    sbbl %esi, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    movl %ebp, %ebx
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    sbbl %edx, %ebx
; X86-NEXT:    movl $0, %ebx
; X86-NEXT:    sbbl %ebx, %ebx
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %ecx, %eax
; X86-NEXT:    sbbl %edi, %esi
; X86-NEXT:    sbbl %ebp, %edx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movb %bl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %ebp
; X86-NEXT:    sbbl %esi, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    sbbl %edx, %ebp
; X86-NEXT:    movl $0, %ebp
; X86-NEXT:    sbbl %ebp, %ebp
; X86-NEXT:    setb %cl
; X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %edi, %esi
; X86-NEXT:    sbbl %ebx, %edx
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movb %cl, {{[-0-9]+}}(%e{{[sb]}}p) # 1-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    sbbl %edi, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    movl $0, %eax
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    setb %bl
; X86-NEXT:    cmpl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %ebp, %edi
; X86-NEXT:    sbbl %ecx, %edx
; X86-NEXT:    movl $0, %ecx
; X86-NEXT:    sbbl %ecx, %ecx
; X86-NEXT:    sbbb $0, %bl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %ebp
; X86-NEXT:    sbbl %edi, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    movl %eax, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    sbbl %edx, %ebp
; X86-NEXT:    movl $0, %ebp
; X86-NEXT:    sbbl %ebp, %ebp
; X86-NEXT:    setb %bh
; X86-NEXT:    cmpl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl %ecx, %edi
; X86-NEXT:    sbbl %eax, %edx
; X86-NEXT:    movl $0, %ecx
; X86-NEXT:    sbbl %ecx, %ecx
; X86-NEXT:    sbbb $0, %bh
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    cmpl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %esi, %ebp
; X86-NEXT:    sbbl %edi, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; X86-NEXT:    movl %edx, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    sbbl %eax, %ebp
; X86-NEXT:    movl $0, %ebp
; X86-NEXT:    sbbl %ebp, %ebp
; X86-NEXT:    setb %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    cmpl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    sbbl %esi, %edi
; X86-NEXT:    sbbl %edx, %eax
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    sbbl %eax, %eax
; X86-NEXT:    sbbb $0, %cl
; X86-NEXT:    movzbl %cl, %ecx
; X86-NEXT:    andl $3, %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movb %cl, 4(%edi)
; X86-NEXT:    movzbl %bh, %ebp
; X86-NEXT:    movzbl %bl, %ecx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 1-byte Folded Reload
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 1-byte Folded Reload
; X86-NEXT:    andl $3, %ebp
; X86-NEXT:    andl $3, %ecx
; X86-NEXT:    leal (%ecx,%ebp,4), %ecx
; X86-NEXT:    andl $3, %eax
; X86-NEXT:    shll $4, %eax
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    andl $3, %ebx
; X86-NEXT:    shll $6, %ebx
; X86-NEXT:    orl %eax, %ebx
; X86-NEXT:    andl $3, %esi
; X86-NEXT:    shll $8, %esi
; X86-NEXT:    orl %ebx, %esi
; X86-NEXT:    andl $3, %edx
; X86-NEXT:    shll $10, %edx
; X86-NEXT:    orl %esi, %edx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    andl $3, %eax
; X86-NEXT:    shll $12, %eax
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    andl $3, %ecx
; X86-NEXT:    shll $14, %ecx
; X86-NEXT:    orl %eax, %ecx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    andl $3, %eax
; X86-NEXT:    shll $16, %eax
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; X86-NEXT:    andl $3, %esi
; X86-NEXT:    shll $18, %esi
; X86-NEXT:    orl %eax, %esi
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 1-byte Folded Reload
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    andl $3, %eax
; X86-NEXT:    shll $20, %eax
; X86-NEXT:    orl %esi, %eax
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 1-byte Folded Reload
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 1-byte Folded Reload
; X86-NEXT:    orl %edx, %eax
; X86-NEXT:    andl $3, %ecx
; X86-NEXT:    shll $22, %ecx
; X86-NEXT:    andl $3, %esi
; X86-NEXT:    shll $24, %esi
; X86-NEXT:    orl %ecx, %esi
; X86-NEXT:    andl $3, %ebx
; X86-NEXT:    shll $26, %ebx
; X86-NEXT:    orl %esi, %ebx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 1-byte Folded Reload
; X86-NEXT:    andl $3, %ecx
; X86-NEXT:    shll $28, %ecx
; X86-NEXT:    orl %ebx, %ecx
; X86-NEXT:    movzbl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 1-byte Folded Reload
; X86-NEXT:    shll $30, %edx
; X86-NEXT:    orl %ecx, %edx
; X86-NEXT:    orl %eax, %edx
; X86-NEXT:    movl %edx, (%edi)
; X86-NEXT:    movl %edi, %eax
; X86-NEXT:    addl $132, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
  %1 = call <17 x i2> @llvm.ucmp(<17 x i71> %x, <17 x i71> %y)
  ret <17 x i2> %1
}
