; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i16_stride2_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i16_stride2_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; SSE-NEXT:    movd %xmm1, (%rsi)
; SSE-NEXT:    movd %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i16_stride2_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX-NEXT:    vmovd %xmm1, (%rsi)
; AVX-NEXT:    vmovd %xmm0, (%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i16_stride2_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX2-NEXT:    vmovd %xmm1, (%rsi)
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i16_stride2_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FP-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX2-FP-NEXT:    vmovd %xmm1, (%rsi)
; AVX2-FP-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i16_stride2_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX2-FCP-NEXT:    vmovd %xmm1, (%rsi)
; AVX2-FCP-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i16_stride2_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512-NEXT:    vmovd %xmm1, (%rsi)
; AVX512-NEXT:    vmovd %xmm0, (%rdx)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i16_stride2_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512-FCP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512-FCP-NEXT:    vmovd %xmm1, (%rsi)
; AVX512-FCP-NEXT:    vmovd %xmm0, (%rdx)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i16_stride2_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512DQ-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512DQ-NEXT:    vmovd %xmm1, (%rsi)
; AVX512DQ-NEXT:    vmovd %xmm0, (%rdx)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i16_stride2_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovd %xmm1, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovd %xmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_stride2_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512BW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512BW-NEXT:    vmovd %xmm1, (%rsi)
; AVX512BW-NEXT:    vmovd %xmm0, (%rdx)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i16_stride2_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FCP-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovd %xmm1, (%rsi)
; AVX512BW-FCP-NEXT:    vmovd %xmm0, (%rdx)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i16_stride2_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovd %xmm1, (%rsi)
; AVX512DQ-BW-NEXT:    vmovd %xmm0, (%rdx)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i16_stride2_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[1,3,2,3,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovd %xmm1, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovd %xmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <4 x i16>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <4 x i16> %wide.vec, <4 x i16> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec1 = shufflevector <4 x i16> %wide.vec, <4 x i16> poison, <2 x i32> <i32 1, i32 3>
  store <2 x i16> %strided.vec0, ptr %out.vec0, align 64
  store <2 x i16> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i16_stride2_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i16_stride2_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,6,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[3,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,7,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,0,3,2,4,5,6,7]
; SSE-NEXT:    movq %xmm1, (%rsi)
; SSE-NEXT:    movq %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i16_stride2_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,1,4,5,8,9,12,13,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovq %xmm1, (%rsi)
; AVX-NEXT:    vmovq %xmm0, (%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i16_stride2_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,1,4,5,8,9,12,13,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vmovq %xmm1, (%rsi)
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i16_stride2_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,1,4,5,8,9,12,13,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX2-FP-NEXT:    vmovq %xmm1, (%rsi)
; AVX2-FP-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i16_stride2_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,1,4,5,8,9,12,13,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX2-FCP-NEXT:    vmovq %xmm1, (%rsi)
; AVX2-FCP-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i16_stride2_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512-NEXT:    vmovq %xmm1, (%rdx)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i16_stride2_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512-FCP-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512-FCP-NEXT:    vmovq %xmm1, (%rdx)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i16_stride2_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512DQ-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512DQ-NEXT:    vmovq %xmm1, (%rdx)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i16_stride2_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512DQ-FCP-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovq %xmm1, (%rdx)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_stride2_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512BW-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512BW-NEXT:    vmovq %xmm1, (%rdx)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i16_stride2_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512BW-FCP-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512BW-FCP-NEXT:    vmovq %xmm1, (%rdx)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i16_stride2_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512DQ-BW-NEXT:    vmovq %xmm1, (%rdx)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i16_stride2_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[2,3,6,7,10,11,14,15,u,u,u,u,u,u,u,u]
; AVX512DQ-BW-FCP-NEXT:    vpmovdw %xmm0, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovq %xmm1, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <8 x i16>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <8 x i16> %wide.vec, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %strided.vec1 = shufflevector <8 x i16> %wide.vec, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  store <4 x i16> %strided.vec0, ptr %out.vec0, align 64
  store <4 x i16> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i16_stride2_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i16_stride2_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    psrad $16, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pslld $16, %xmm3
; SSE-NEXT:    psrad $16, %xmm3
; SSE-NEXT:    packssdw %xmm2, %xmm3
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm3, (%rsi)
; SSE-NEXT:    movdqa %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i16_stride2_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa (%rdi), %xmm1
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0],xmm0[1],xmm2[2],xmm0[3],xmm2[4],xmm0[5],xmm2[6],xmm0[7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i16_stride2_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX2-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0],xmm0[1],xmm2[2],xmm0[3],xmm2[4],xmm0[5],xmm2[6],xmm0[7]
; AVX2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX2-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX2-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX2-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i16_stride2_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-FP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX2-FP-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0],xmm0[1],xmm2[2],xmm0[3],xmm2[4],xmm0[5],xmm2[6],xmm0[7]
; AVX2-FP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX2-FP-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX2-FP-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX2-FP-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX2-FP-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-FP-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX2-FP-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i16_stride2_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FCP-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0],xmm0[1],xmm2[2],xmm0[3],xmm2[4],xmm0[5],xmm2[6],xmm0[7]
; AVX2-FCP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX2-FCP-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX2-FCP-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX2-FCP-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-FCP-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX2-FCP-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i16_stride2_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i16_stride2_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-FCP-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512-FCP-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512-FCP-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i16_stride2_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512DQ-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512DQ-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i16_stride2_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512DQ-FCP-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512DQ-FCP-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_stride2_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512BW-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512BW-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i16_stride2_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512BW-FCP-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512BW-FCP-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i16_stride2_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512DQ-BW-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512DQ-BW-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i16_stride2_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vpsrld $16, %ymm0, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpmovdw %ymm0, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vpmovdw %ymm1, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <16 x i16>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <16 x i16> %wide.vec, <16 x i16> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %strided.vec1 = shufflevector <16 x i16> %wide.vec, <16 x i16> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  store <8 x i16> %strided.vec0, ptr %out.vec0, align 64
  store <8 x i16> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i16_stride2_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i16_stride2_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm2
; SSE-NEXT:    movdqa 32(%rdi), %xmm1
; SSE-NEXT:    movdqa 48(%rdi), %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pslld $16, %xmm4
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pslld $16, %xmm5
; SSE-NEXT:    psrad $16, %xmm5
; SSE-NEXT:    packssdw %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pslld $16, %xmm4
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pslld $16, %xmm6
; SSE-NEXT:    psrad $16, %xmm6
; SSE-NEXT:    packssdw %xmm4, %xmm6
; SSE-NEXT:    psrad $16, %xmm3
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    packssdw %xmm3, %xmm1
; SSE-NEXT:    psrad $16, %xmm2
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm6, (%rsi)
; SSE-NEXT:    movdqa %xmm5, 16(%rsi)
; SSE-NEXT:    movdqa %xmm0, (%rdx)
; SSE-NEXT:    movdqa %xmm1, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i16_stride2_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa (%rdi), %xmm1
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm4
; AVX-NEXT:    vpblendw {{.*#+}} xmm5 = xmm4[0],xmm0[1],xmm4[2],xmm0[3],xmm4[4],xmm0[5],xmm4[6],xmm0[7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm3[0],xmm0[1],xmm3[2],xmm0[3],xmm3[4],xmm0[5],xmm3[6],xmm0[7]
; AVX-NEXT:    vpackusdw %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3],xmm2[4],xmm0[5],xmm2[6],xmm0[7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1],xmm1[2],xmm0[3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX-NEXT:    vpackusdw %xmm6, %xmm0, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm4, %xmm4
; AVX-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX-NEXT:    vpackusdw %xmm4, %xmm3, %xmm3
; AVX-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX-NEXT:    vmovdqa %xmm5, 16(%rsi)
; AVX-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX-NEXT:    vmovdqa %xmm3, 16(%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i16_stride2_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm1[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm3 = ymm0[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm3 = ymm3[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[0,2],ymm2[0,2],ymm3[4,6],ymm2[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-NEXT:    vmovdqa %ymm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i16_stride2_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [84148480,218892552,353636624,488380696]
; AVX2-FP-NEXT:    vpshufb %ymm2, %ymm1, %ymm3
; AVX2-FP-NEXT:    vpshufb %ymm2, %ymm0, %ymm2
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm3 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-FP-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-FP-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i16_stride2_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm2 = [84148480,218892552,353636624,488380696]
; AVX2-FCP-NEXT:    vpshufb %ymm2, %ymm1, %ymm3
; AVX2-FCP-NEXT:    vpshufb %ymm2, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm3[0,2],ymm2[4,6],ymm3[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm3 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-FCP-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i16_stride2_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i16_stride2_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512-FCP-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i16_stride2_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i16_stride2_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_stride2_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512BW-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512BW-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i16_stride2_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512BW-FCP-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i16_stride2_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-BW-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i16_stride2_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpsrld $16, %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vpmovdw %zmm1, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <32 x i16>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <32 x i16> %wide.vec, <32 x i16> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %strided.vec1 = shufflevector <32 x i16> %wide.vec, <32 x i16> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  store <16 x i16> %strided.vec0, ptr %out.vec0, align 64
  store <16 x i16> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i16_stride2_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i16_stride2_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa 64(%rdi), %xmm0
; SSE-NEXT:    movdqa 80(%rdi), %xmm4
; SSE-NEXT:    movdqa 96(%rdi), %xmm1
; SSE-NEXT:    movdqa 112(%rdi), %xmm6
; SSE-NEXT:    movdqa (%rdi), %xmm2
; SSE-NEXT:    movdqa 16(%rdi), %xmm7
; SSE-NEXT:    movdqa 32(%rdi), %xmm3
; SSE-NEXT:    movdqa 48(%rdi), %xmm9
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pslld $16, %xmm8
; SSE-NEXT:    psrad $16, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pslld $16, %xmm5
; SSE-NEXT:    psrad $16, %xmm5
; SSE-NEXT:    packssdw %xmm8, %xmm5
; SSE-NEXT:    movdqa %xmm7, %xmm10
; SSE-NEXT:    pslld $16, %xmm10
; SSE-NEXT:    psrad $16, %xmm10
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    pslld $16, %xmm8
; SSE-NEXT:    psrad $16, %xmm8
; SSE-NEXT:    packssdw %xmm10, %xmm8
; SSE-NEXT:    movdqa %xmm6, %xmm11
; SSE-NEXT:    pslld $16, %xmm11
; SSE-NEXT:    psrad $16, %xmm11
; SSE-NEXT:    movdqa %xmm1, %xmm10
; SSE-NEXT:    pslld $16, %xmm10
; SSE-NEXT:    psrad $16, %xmm10
; SSE-NEXT:    packssdw %xmm11, %xmm10
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    pslld $16, %xmm11
; SSE-NEXT:    psrad $16, %xmm11
; SSE-NEXT:    movdqa %xmm0, %xmm12
; SSE-NEXT:    pslld $16, %xmm12
; SSE-NEXT:    psrad $16, %xmm12
; SSE-NEXT:    packssdw %xmm11, %xmm12
; SSE-NEXT:    psrad $16, %xmm9
; SSE-NEXT:    psrad $16, %xmm3
; SSE-NEXT:    packssdw %xmm9, %xmm3
; SSE-NEXT:    psrad $16, %xmm7
; SSE-NEXT:    psrad $16, %xmm2
; SSE-NEXT:    packssdw %xmm7, %xmm2
; SSE-NEXT:    psrad $16, %xmm6
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    packssdw %xmm6, %xmm1
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm12, 32(%rsi)
; SSE-NEXT:    movdqa %xmm10, 48(%rsi)
; SSE-NEXT:    movdqa %xmm8, (%rsi)
; SSE-NEXT:    movdqa %xmm5, 16(%rsi)
; SSE-NEXT:    movdqa %xmm0, 32(%rdx)
; SSE-NEXT:    movdqa %xmm1, 48(%rdx)
; SSE-NEXT:    movdqa %xmm2, (%rdx)
; SSE-NEXT:    movdqa %xmm3, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i16_stride2_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vmovdqa (%rdi), %xmm1
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm3
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm4
; AVX-NEXT:    vpblendw {{.*#+}} xmm5 = xmm4[0],xmm0[1],xmm4[2],xmm0[3],xmm4[4],xmm0[5],xmm4[6],xmm0[7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm3[0],xmm0[1],xmm3[2],xmm0[3],xmm3[4],xmm0[5],xmm3[6],xmm0[7]
; AVX-NEXT:    vpackusdw %xmm5, %xmm6, %xmm5
; AVX-NEXT:    vpblendw {{.*#+}} xmm6 = xmm2[0],xmm0[1],xmm2[2],xmm0[3],xmm2[4],xmm0[5],xmm2[6],xmm0[7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm7 = xmm1[0],xmm0[1],xmm1[2],xmm0[3],xmm1[4],xmm0[5],xmm1[6],xmm0[7]
; AVX-NEXT:    vpackusdw %xmm6, %xmm7, %xmm6
; AVX-NEXT:    vmovdqa 112(%rdi), %xmm7
; AVX-NEXT:    vpblendw {{.*#+}} xmm8 = xmm7[0],xmm0[1],xmm7[2],xmm0[3],xmm7[4],xmm0[5],xmm7[6],xmm0[7]
; AVX-NEXT:    vmovdqa 96(%rdi), %xmm9
; AVX-NEXT:    vpblendw {{.*#+}} xmm10 = xmm9[0],xmm0[1],xmm9[2],xmm0[3],xmm9[4],xmm0[5],xmm9[6],xmm0[7]
; AVX-NEXT:    vpackusdw %xmm8, %xmm10, %xmm8
; AVX-NEXT:    vmovdqa 80(%rdi), %xmm10
; AVX-NEXT:    vpblendw {{.*#+}} xmm11 = xmm10[0],xmm0[1],xmm10[2],xmm0[3],xmm10[4],xmm0[5],xmm10[6],xmm0[7]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm12
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm12[0],xmm0[1],xmm12[2],xmm0[3],xmm12[4],xmm0[5],xmm12[6],xmm0[7]
; AVX-NEXT:    vpackusdw %xmm11, %xmm0, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm4, %xmm4
; AVX-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX-NEXT:    vpackusdw %xmm4, %xmm3, %xmm3
; AVX-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpsrld $16, %xmm7, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm9, %xmm4
; AVX-NEXT:    vpackusdw %xmm2, %xmm4, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm10, %xmm4
; AVX-NEXT:    vpsrld $16, %xmm12, %xmm7
; AVX-NEXT:    vpackusdw %xmm4, %xmm7, %xmm4
; AVX-NEXT:    vmovdqa %xmm0, 32(%rsi)
; AVX-NEXT:    vmovdqa %xmm8, 48(%rsi)
; AVX-NEXT:    vmovdqa %xmm6, (%rsi)
; AVX-NEXT:    vmovdqa %xmm5, 16(%rsi)
; AVX-NEXT:    vmovdqa %xmm4, 32(%rdx)
; AVX-NEXT:    vmovdqa %xmm2, 48(%rdx)
; AVX-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX-NEXT:    vmovdqa %xmm3, 16(%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i16_stride2_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm4 = ymm3[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm4 = ymm4[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm2[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vshufps {{.*#+}} ymm4 = ymm5[0,2],ymm4[0,2],ymm5[4,6],ymm4[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm1[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm6 = ymm0[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm6 = ymm6[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[0,2],ymm5[0,2],ymm6[4,6],ymm5[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,1,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm6 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-NEXT:    vpshufb %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpshufb %ymm6, %ymm2, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vpshufb %ymm6, %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm5, (%rsi)
; AVX2-NEXT:    vmovaps %ymm4, 32(%rsi)
; AVX2-NEXT:    vmovdqa %ymm0, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm2, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i16_stride2_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-FP-NEXT:    vpmovsxdq {{.*#+}} ymm4 = [84148480,218892552,353636624,488380696]
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm3, %ymm5
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm2, %ymm6
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[0,2],ymm5[0,2],ymm6[4,6],ymm5[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm1, %ymm6
; AVX2-FP-NEXT:    vpshufb %ymm4, %ymm0, %ymm4
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,2],ymm6[0,2],ymm4[4,6],ymm6[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm6 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-FP-NEXT:    vpshufb %ymm6, %ymm3, %ymm3
; AVX2-FP-NEXT:    vpshufb %ymm6, %ymm2, %ymm2
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm6, %ymm1, %ymm1
; AVX2-FP-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm4, (%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm5, 32(%rsi)
; AVX2-FP-NEXT:    vmovdqa %ymm0, (%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm2, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i16_stride2_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm4 = [84148480,218892552,353636624,488380696]
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm3, %ymm5
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm2, %ymm6
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[0,2],ymm5[0,2],ymm6[4,6],ymm5[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm1, %ymm6
; AVX2-FCP-NEXT:    vpshufb %ymm4, %ymm0, %ymm4
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[0,2],ymm6[0,2],ymm4[4,6],ymm6[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm6 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-FCP-NEXT:    vpshufb %ymm6, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vpshufb %ymm6, %ymm2, %ymm2
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm6, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpshufb %ymm6, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm4, (%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 32(%rsi)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm2, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i16_stride2_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vpsrld $16, %zmm0, %zmm2
; AVX512-NEXT:    vpsrld $16, %zmm1, %zmm3
; AVX512-NEXT:    vpmovdw %zmm1, 32(%rsi)
; AVX512-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512-NEXT:    vpmovdw %zmm3, 32(%rdx)
; AVX512-NEXT:    vpmovdw %zmm2, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i16_stride2_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vpsrld $16, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpsrld $16, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpmovdw %zmm1, 32(%rsi)
; AVX512-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512-FCP-NEXT:    vpmovdw %zmm3, 32(%rdx)
; AVX512-FCP-NEXT:    vpmovdw %zmm2, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i16_stride2_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vpsrld $16, %zmm0, %zmm2
; AVX512DQ-NEXT:    vpsrld $16, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpmovdw %zmm1, 32(%rsi)
; AVX512DQ-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-NEXT:    vpmovdw %zmm3, 32(%rdx)
; AVX512DQ-NEXT:    vpmovdw %zmm2, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i16_stride2_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vpsrld $16, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpsrld $16, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm1, 32(%rsi)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm3, 32(%rdx)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm2, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_stride2_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i16_stride2_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i16_stride2_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512DQ-BW-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i16_stride2_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm2 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm3 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <64 x i16>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <64 x i16> %wide.vec, <64 x i16> poison, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62>
  %strided.vec1 = shufflevector <64 x i16> %wide.vec, <64 x i16> poison, <32 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63>
  store <32 x i16> %strided.vec0, ptr %out.vec0, align 64
  store <32 x i16> %strided.vec1, ptr %out.vec1, align 64
  ret void
}

define void @load_i16_stride2_vf64(ptr %in.vec, ptr %out.vec0, ptr %out.vec1) nounwind {
; SSE-LABEL: load_i16_stride2_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $40, %rsp
; SSE-NEXT:    movdqa 160(%rdi), %xmm14
; SSE-NEXT:    movdqa %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 176(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 64(%rdi), %xmm11
; SSE-NEXT:    movdqa %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 80(%rdi), %xmm1
; SSE-NEXT:    movdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 96(%rdi), %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 112(%rdi), %xmm4
; SSE-NEXT:    movdqa %xmm4, (%rsp) # 16-byte Spill
; SSE-NEXT:    movdqa (%rdi), %xmm10
; SSE-NEXT:    movdqa %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 16(%rdi), %xmm7
; SSE-NEXT:    movdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 32(%rdi), %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa 48(%rdi), %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    pslld $16, %xmm13
; SSE-NEXT:    psrad $16, %xmm13
; SSE-NEXT:    packssdw %xmm0, %xmm13
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    pslld $16, %xmm10
; SSE-NEXT:    psrad $16, %xmm10
; SSE-NEXT:    packssdw %xmm0, %xmm10
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    pslld $16, %xmm9
; SSE-NEXT:    psrad $16, %xmm9
; SSE-NEXT:    packssdw %xmm0, %xmm9
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    pslld $16, %xmm11
; SSE-NEXT:    psrad $16, %xmm11
; SSE-NEXT:    packssdw %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    pslld $16, %xmm14
; SSE-NEXT:    psrad $16, %xmm14
; SSE-NEXT:    packssdw %xmm0, %xmm14
; SSE-NEXT:    movdqa 144(%rdi), %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm0
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    movdqa 128(%rdi), %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm15
; SSE-NEXT:    pslld $16, %xmm15
; SSE-NEXT:    psrad $16, %xmm15
; SSE-NEXT:    packssdw %xmm0, %xmm15
; SSE-NEXT:    movdqa 240(%rdi), %xmm12
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    movdqa 224(%rdi), %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pslld $16, %xmm3
; SSE-NEXT:    psrad $16, %xmm3
; SSE-NEXT:    packssdw %xmm1, %xmm3
; SSE-NEXT:    movdqa 208(%rdi), %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pslld $16, %xmm4
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    movdqa 192(%rdi), %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    packssdw %xmm4, %xmm1
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    packssdw %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    packssdw %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    packssdw %xmm0, %xmm4
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm4
; SSE-NEXT:    packssdw %xmm0, %xmm4
; SSE-NEXT:    psrad $16, %xmm7
; SSE-NEXT:    psrad $16, %xmm8
; SSE-NEXT:    packssdw %xmm7, %xmm8
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; SSE-NEXT:    psrad $16, %xmm7
; SSE-NEXT:    packssdw %xmm0, %xmm7
; SSE-NEXT:    psrad $16, %xmm6
; SSE-NEXT:    psrad $16, %xmm2
; SSE-NEXT:    packssdw %xmm6, %xmm2
; SSE-NEXT:    psrad $16, %xmm12
; SSE-NEXT:    psrad $16, %xmm5
; SSE-NEXT:    packssdw %xmm12, %xmm5
; SSE-NEXT:    movdqa %xmm1, 96(%rsi)
; SSE-NEXT:    movdqa %xmm3, 112(%rsi)
; SSE-NEXT:    movdqa %xmm15, 64(%rsi)
; SSE-NEXT:    movdqa %xmm14, 80(%rsi)
; SSE-NEXT:    movdqa %xmm11, 32(%rsi)
; SSE-NEXT:    movdqa %xmm9, 48(%rsi)
; SSE-NEXT:    movdqa %xmm10, (%rsi)
; SSE-NEXT:    movdqa %xmm13, 16(%rsi)
; SSE-NEXT:    movdqa %xmm5, 112(%rdx)
; SSE-NEXT:    movdqa %xmm2, 96(%rdx)
; SSE-NEXT:    movdqa %xmm7, 80(%rdx)
; SSE-NEXT:    movdqa %xmm8, 64(%rdx)
; SSE-NEXT:    movdqa %xmm4, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    addq $40, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i16_stride2_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $24, %rsp
; AVX-NEXT:    vpxor %xmm11, %xmm11, %xmm11
; AVX-NEXT:    vmovdqa 176(%rdi), %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm11[1],xmm0[2],xmm11[3],xmm0[4],xmm11[5],xmm0[6],xmm11[7]
; AVX-NEXT:    vmovdqa 160(%rdi), %xmm9
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm9[0],xmm11[1],xmm9[2],xmm11[3],xmm9[4],xmm11[5],xmm9[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovdqa (%rdi), %xmm6
; AVX-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm7
; AVX-NEXT:    vmovdqa 48(%rdi), %xmm10
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm10[0],xmm11[1],xmm10[2],xmm11[3],xmm10[4],xmm11[5],xmm10[6],xmm11[7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm7[0],xmm11[1],xmm7[2],xmm11[3],xmm7[4],xmm11[5],xmm7[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 144(%rdi), %xmm5
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm5[0],xmm11[1],xmm5[2],xmm11[3],xmm5[4],xmm11[5],xmm5[6],xmm11[7]
; AVX-NEXT:    vmovdqa 128(%rdi), %xmm4
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0],xmm11[1],xmm4[2],xmm11[3],xmm4[4],xmm11[5],xmm4[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm2, %xmm3, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm8[0],xmm11[1],xmm8[2],xmm11[3],xmm8[4],xmm11[5],xmm8[6],xmm11[7]
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm6[0],xmm11[1],xmm6[2],xmm11[3],xmm6[4],xmm11[5],xmm6[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm2, %xmm3, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 112(%rdi), %xmm12
; AVX-NEXT:    vpblendw {{.*#+}} xmm2 = xmm12[0],xmm11[1],xmm12[2],xmm11[3],xmm12[4],xmm11[5],xmm12[6],xmm11[7]
; AVX-NEXT:    vmovdqa 96(%rdi), %xmm13
; AVX-NEXT:    vpblendw {{.*#+}} xmm8 = xmm13[0],xmm11[1],xmm13[2],xmm11[3],xmm13[4],xmm11[5],xmm13[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm2, %xmm8, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 80(%rdi), %xmm15
; AVX-NEXT:    vpblendw {{.*#+}} xmm14 = xmm15[0],xmm11[1],xmm15[2],xmm11[3],xmm15[4],xmm11[5],xmm15[6],xmm11[7]
; AVX-NEXT:    vmovdqa 64(%rdi), %xmm6
; AVX-NEXT:    vpblendw {{.*#+}} xmm3 = xmm6[0],xmm11[1],xmm6[2],xmm11[3],xmm6[4],xmm11[5],xmm6[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm14, %xmm3, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovdqa 240(%rdi), %xmm3
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm3[0],xmm11[1],xmm3[2],xmm11[3],xmm3[4],xmm11[5],xmm3[6],xmm11[7]
; AVX-NEXT:    vmovdqa 224(%rdi), %xmm0
; AVX-NEXT:    vpblendw {{.*#+}} xmm8 = xmm0[0],xmm11[1],xmm0[2],xmm11[3],xmm0[4],xmm11[5],xmm0[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm1, %xmm8, %xmm14
; AVX-NEXT:    vmovdqa 208(%rdi), %xmm8
; AVX-NEXT:    vpblendw {{.*#+}} xmm1 = xmm8[0],xmm11[1],xmm8[2],xmm11[3],xmm8[4],xmm11[5],xmm8[6],xmm11[7]
; AVX-NEXT:    vmovdqa 192(%rdi), %xmm2
; AVX-NEXT:    vpblendw {{.*#+}} xmm11 = xmm2[0],xmm11[1],xmm2[2],xmm11[3],xmm2[4],xmm11[5],xmm2[6],xmm11[7]
; AVX-NEXT:    vpackusdw %xmm1, %xmm11, %xmm1
; AVX-NEXT:    vpsrld $16, %xmm3, %xmm3
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    vpackusdw %xmm3, %xmm0, %xmm11
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm9, %xmm3
; AVX-NEXT:    vpackusdw %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm5, %xmm3
; AVX-NEXT:    vpsrld $16, %xmm4, %xmm4
; AVX-NEXT:    vpackusdw %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vpsrld $16, %xmm10, %xmm4
; AVX-NEXT:    vpsrld $16, %xmm7, %xmm5
; AVX-NEXT:    vpackusdw %xmm4, %xmm5, %xmm4
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX-NEXT:    vpsrld $16, %xmm5, %xmm5
; AVX-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX-NEXT:    vpsrld $16, %xmm7, %xmm7
; AVX-NEXT:    vpackusdw %xmm5, %xmm7, %xmm5
; AVX-NEXT:    vpsrld $16, %xmm8, %xmm7
; AVX-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX-NEXT:    vpackusdw %xmm7, %xmm2, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm12, %xmm7
; AVX-NEXT:    vpsrld $16, %xmm13, %xmm8
; AVX-NEXT:    vpackusdw %xmm7, %xmm8, %xmm7
; AVX-NEXT:    vpsrld $16, %xmm15, %xmm8
; AVX-NEXT:    vpsrld $16, %xmm6, %xmm6
; AVX-NEXT:    vpackusdw %xmm8, %xmm6, %xmm6
; AVX-NEXT:    vmovdqa %xmm1, 96(%rsi)
; AVX-NEXT:    vmovdqa %xmm14, 112(%rsi)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm1, 32(%rsi)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm1, 48(%rsi)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm1, (%rsi)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm1, 64(%rsi)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm1, 16(%rsi)
; AVX-NEXT:    vmovaps (%rsp), %xmm1 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm1, 80(%rsi)
; AVX-NEXT:    vmovdqa %xmm6, 32(%rdx)
; AVX-NEXT:    vmovdqa %xmm7, 48(%rdx)
; AVX-NEXT:    vmovdqa %xmm2, 96(%rdx)
; AVX-NEXT:    vmovdqa %xmm5, (%rdx)
; AVX-NEXT:    vmovdqa %xmm4, 16(%rdx)
; AVX-NEXT:    vmovdqa %xmm3, 64(%rdx)
; AVX-NEXT:    vmovdqa %xmm0, 80(%rdx)
; AVX-NEXT:    vmovdqa %xmm11, 112(%rdx)
; AVX-NEXT:    addq $24, %rsp
; AVX-NEXT:    retq
;
; AVX2-LABEL: load_i16_stride2_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa 128(%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 160(%rdi), %ymm1
; AVX2-NEXT:    vmovdqa 192(%rdi), %ymm4
; AVX2-NEXT:    vmovdqa 224(%rdi), %ymm6
; AVX2-NEXT:    vmovdqa (%rdi), %ymm3
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm5
; AVX2-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX2-NEXT:    vmovdqa 96(%rdi), %ymm8
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm2 = ymm8[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm2 = ymm2[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm7[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vshufps {{.*#+}} ymm2 = ymm9[0,2],ymm2[0,2],ymm9[4,6],ymm2[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm9 = ymm6[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm9 = ymm9[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm10 = ymm4[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm10[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[0,2],ymm9[0,2],ymm10[4,6],ymm9[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,1,3]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm10 = ymm5[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm10 = ymm10[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm3[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm11[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vshufps {{.*#+}} ymm10 = ymm11[0,2],ymm10[0,2],ymm11[4,6],ymm10[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,1,3]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm11 = ymm1[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm11 = ymm11[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vpshuflw {{.*#+}} ymm12 = ymm0[0,2,2,3,4,5,6,7,8,10,10,11,12,13,14,15]
; AVX2-NEXT:    vpshufhw {{.*#+}} ymm12 = ymm12[0,1,2,3,4,6,6,7,8,9,10,11,12,14,14,15]
; AVX2-NEXT:    vshufps {{.*#+}} ymm11 = ymm12[0,2],ymm11[0,2],ymm12[4,6],ymm11[4,6]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,2,1,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm12 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-NEXT:    vpshufb %ymm12, %ymm8, %ymm8
; AVX2-NEXT:    vpshufb %ymm12, %ymm7, %ymm7
; AVX2-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3],ymm7[4,5],ymm8[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,1,3]
; AVX2-NEXT:    vpshufb %ymm12, %ymm6, %ymm6
; AVX2-NEXT:    vpshufb %ymm12, %ymm4, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1],ymm6[2,3],ymm4[4,5],ymm6[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-NEXT:    vpshufb %ymm12, %ymm5, %ymm5
; AVX2-NEXT:    vpshufb %ymm12, %ymm3, %ymm3
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3],ymm3[4,5],ymm5[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,1,3]
; AVX2-NEXT:    vpshufb %ymm12, %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm12, %ymm0, %ymm0
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm11, 64(%rsi)
; AVX2-NEXT:    vmovaps %ymm10, (%rsi)
; AVX2-NEXT:    vmovaps %ymm9, 96(%rsi)
; AVX2-NEXT:    vmovaps %ymm2, 32(%rsi)
; AVX2-NEXT:    vmovdqa %ymm0, 64(%rdx)
; AVX2-NEXT:    vmovdqa %ymm3, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm4, 96(%rdx)
; AVX2-NEXT:    vmovdqa %ymm7, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: load_i16_stride2_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovdqa 128(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovdqa 160(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovdqa 192(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovdqa 224(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovdqa (%rdi), %ymm5
; AVX2-FP-NEXT:    vmovdqa 32(%rdi), %ymm6
; AVX2-FP-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX2-FP-NEXT:    vmovdqa 96(%rdi), %ymm8
; AVX2-FP-NEXT:    vpmovsxdq {{.*#+}} ymm9 = [84148480,218892552,353636624,488380696]
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm8, %ymm2
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm7, %ymm10
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm2 = ymm10[0,2],ymm2[0,2],ymm10[4,6],ymm2[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm4, %ymm10
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm3, %ymm11
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm10 = ymm11[0,2],ymm10[0,2],ymm11[4,6],ymm10[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm6, %ymm11
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm5, %ymm12
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm11 = ymm12[0,2],ymm11[0,2],ymm12[4,6],ymm11[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm1, %ymm12
; AVX2-FP-NEXT:    vpshufb %ymm9, %ymm0, %ymm9
; AVX2-FP-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[0,2],ymm12[0,2],ymm9[4,6],ymm12[4,6]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,1,3]
; AVX2-FP-NEXT:    vmovdqa {{.*#+}} ymm12 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm8, %ymm8
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm7, %ymm7
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3],ymm7[4,5],ymm8[6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm4, %ymm4
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm3, %ymm3
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm6, %ymm4
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm5, %ymm5
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm1, %ymm1
; AVX2-FP-NEXT:    vpshufb %ymm12, %ymm0, %ymm0
; AVX2-FP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm9, 64(%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm11, (%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm10, 96(%rsi)
; AVX2-FP-NEXT:    vmovaps %ymm2, 32(%rsi)
; AVX2-FP-NEXT:    vmovdqa %ymm0, 64(%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm4, (%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm3, 96(%rdx)
; AVX2-FP-NEXT:    vmovdqa %ymm7, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: load_i16_stride2_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovdqa 128(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovdqa 160(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovdqa 192(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovdqa 224(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovdqa (%rdi), %ymm5
; AVX2-FCP-NEXT:    vmovdqa 32(%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX2-FCP-NEXT:    vmovdqa 96(%rdi), %ymm8
; AVX2-FCP-NEXT:    vpmovsxdq {{.*#+}} ymm9 = [84148480,218892552,353636624,488380696]
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm8, %ymm2
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm7, %ymm10
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm2 = ymm10[0,2],ymm2[0,2],ymm10[4,6],ymm2[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm4, %ymm10
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm3, %ymm11
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm10 = ymm11[0,2],ymm10[0,2],ymm11[4,6],ymm10[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm6, %ymm11
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm5, %ymm12
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm11 = ymm12[0,2],ymm11[0,2],ymm12[4,6],ymm11[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm1, %ymm12
; AVX2-FCP-NEXT:    vpshufb %ymm9, %ymm0, %ymm9
; AVX2-FCP-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[0,2],ymm12[0,2],ymm9[4,6],ymm12[4,6]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[0,2,1,3]
; AVX2-FCP-NEXT:    vmovdqa {{.*#+}} ymm12 = [2,3,6,7,10,11,14,15,2,3,6,7,10,11,14,15,18,19,22,23,26,27,30,31,18,19,22,23,26,27,30,31]
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3],ymm7[4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm4, %ymm4
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm3, %ymm3
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3],ymm3[4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm6, %ymm4
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm5, %ymm5
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm4 = ymm4[0,2,1,3]
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vpshufb %ymm12, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm9, 64(%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm11, (%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 96(%rsi)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 32(%rsi)
; AVX2-FCP-NEXT:    vmovdqa %ymm0, 64(%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm4, (%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm3, 96(%rdx)
; AVX2-FCP-NEXT:    vmovdqa %ymm7, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: load_i16_stride2_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-NEXT:    vpmovdw %zmm1, %ymm4
; AVX512-NEXT:    vpsrld $16, %zmm1, %zmm1
; AVX512-NEXT:    vpsrld $16, %zmm0, %zmm5
; AVX512-NEXT:    vpsrld $16, %zmm3, %zmm6
; AVX512-NEXT:    vpsrld $16, %zmm2, %zmm7
; AVX512-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm4, 32(%rsi)
; AVX512-NEXT:    vpmovdw %zmm2, 64(%rsi)
; AVX512-NEXT:    vpmovdw %zmm3, 96(%rsi)
; AVX512-NEXT:    vpmovdw %zmm7, 64(%rdx)
; AVX512-NEXT:    vpmovdw %zmm6, 96(%rdx)
; AVX512-NEXT:    vpmovdw %zmm5, (%rdx)
; AVX512-NEXT:    vpmovdw %zmm1, 32(%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: load_i16_stride2_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-FCP-NEXT:    vpmovdw %zmm1, %ymm4
; AVX512-FCP-NEXT:    vpsrld $16, %zmm1, %zmm1
; AVX512-FCP-NEXT:    vpsrld $16, %zmm0, %zmm5
; AVX512-FCP-NEXT:    vpsrld $16, %zmm3, %zmm6
; AVX512-FCP-NEXT:    vpsrld $16, %zmm2, %zmm7
; AVX512-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512-FCP-NEXT:    vmovdqa %ymm4, 32(%rsi)
; AVX512-FCP-NEXT:    vpmovdw %zmm2, 64(%rsi)
; AVX512-FCP-NEXT:    vpmovdw %zmm3, 96(%rsi)
; AVX512-FCP-NEXT:    vpmovdw %zmm7, 64(%rdx)
; AVX512-FCP-NEXT:    vpmovdw %zmm6, 96(%rdx)
; AVX512-FCP-NEXT:    vpmovdw %zmm5, (%rdx)
; AVX512-FCP-NEXT:    vpmovdw %zmm1, 32(%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: load_i16_stride2_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-NEXT:    vpmovdw %zmm1, %ymm4
; AVX512DQ-NEXT:    vpsrld $16, %zmm1, %zmm1
; AVX512DQ-NEXT:    vpsrld $16, %zmm0, %zmm5
; AVX512DQ-NEXT:    vpsrld $16, %zmm3, %zmm6
; AVX512DQ-NEXT:    vpsrld $16, %zmm2, %zmm7
; AVX512DQ-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-NEXT:    vmovdqa %ymm4, 32(%rsi)
; AVX512DQ-NEXT:    vpmovdw %zmm2, 64(%rsi)
; AVX512DQ-NEXT:    vpmovdw %zmm3, 96(%rsi)
; AVX512DQ-NEXT:    vpmovdw %zmm7, 64(%rdx)
; AVX512DQ-NEXT:    vpmovdw %zmm6, 96(%rdx)
; AVX512DQ-NEXT:    vpmovdw %zmm5, (%rdx)
; AVX512DQ-NEXT:    vpmovdw %zmm1, 32(%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: load_i16_stride2_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm1, %ymm4
; AVX512DQ-FCP-NEXT:    vpsrld $16, %zmm1, %zmm1
; AVX512DQ-FCP-NEXT:    vpsrld $16, %zmm0, %zmm5
; AVX512DQ-FCP-NEXT:    vpsrld $16, %zmm3, %zmm6
; AVX512DQ-FCP-NEXT:    vpsrld $16, %zmm2, %zmm7
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm0, (%rsi)
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm4, 32(%rsi)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm2, 64(%rsi)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm3, 96(%rsi)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm7, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm6, 96(%rdx)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm5, (%rdx)
; AVX512DQ-FCP-NEXT:    vpmovdw %zmm1, 32(%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: load_i16_stride2_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-NEXT:    vpermt2w %zmm1, %zmm4, %zmm5
; AVX512BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512BW-NEXT:    vpermt2w %zmm1, %zmm6, %zmm0
; AVX512BW-NEXT:    vpermt2w %zmm3, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: load_i16_stride2_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2w %zmm1, %zmm4, %zmm5
; AVX512BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512BW-FCP-NEXT:    vpermt2w %zmm1, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2w %zmm3, %zmm6, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: load_i16_stride2_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2w %zmm1, %zmm4, %zmm5
; AVX512DQ-BW-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512DQ-BW-NEXT:    vpermt2w %zmm1, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2w %zmm3, %zmm6, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: load_i16_stride2_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm4 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm1, %zmm4, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermi2w %zmm3, %zmm2, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbw {{.*#+}} zmm6 = [1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63]
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm1, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2w %zmm3, %zmm6, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 64(%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rsi)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %wide.vec = load <128 x i16>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <128 x i16> %wide.vec, <128 x i16> poison, <64 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62, i32 64, i32 66, i32 68, i32 70, i32 72, i32 74, i32 76, i32 78, i32 80, i32 82, i32 84, i32 86, i32 88, i32 90, i32 92, i32 94, i32 96, i32 98, i32 100, i32 102, i32 104, i32 106, i32 108, i32 110, i32 112, i32 114, i32 116, i32 118, i32 120, i32 122, i32 124, i32 126>
  %strided.vec1 = shufflevector <128 x i16> %wide.vec, <128 x i16> poison, <64 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63, i32 65, i32 67, i32 69, i32 71, i32 73, i32 75, i32 77, i32 79, i32 81, i32 83, i32 85, i32 87, i32 89, i32 91, i32 93, i32 95, i32 97, i32 99, i32 101, i32 103, i32 105, i32 107, i32 109, i32 111, i32 113, i32 115, i32 117, i32 119, i32 121, i32 123, i32 125, i32 127>
  store <64 x i16> %strided.vec0, ptr %out.vec0, align 64
  store <64 x i16> %strided.vec1, ptr %out.vec1, align 64
  ret void
}
