// SPDX-License-Identifier: GPL-2.0-only
/*
 * getopt-support.c -- getopt support
 * (C)Copyright 2000-2024 by Hiroshi Takekawa
 * This file is part of multiskkserv.
 *
 * Last Modified: Sat Feb 24 15:52:52 2024.
 */

#include <stdio.h>

#define REQUIRE_STRING_H
#include "compat.h"

#include "libstring.h"
#include "getopt-support.h"

char *
gen_optstring(Option opt[])
{
  int i;
  String *s;
  char *optstr;

  s = string_create();
  i = 0;
  while (opt[i].longopt != NULL) {
    string_cat_ch(s, opt[i].opt);
    switch (opt[i].argreq) {
    case _NO_ARGUMENT:
      break;
    case _REQUIRED_ARGUMENT:
      string_cat_ch(s, ':');
      break;
    case _OPTIONAL_ARGUMENT:
      string_cat(s, "::");
      break;
    }
    i++;
  }

  optstr = strdup(string_get(s));

  string_destroy(s);

  return optstr;
}

void
print_option_usage(Option opt[])
{
  int i;

  i = 0;
  while (opt[i].longopt != NULL) {
    printf(" %c(%s): \t%s\n",
	   opt[i].opt, opt[i].longopt, opt[i].description);
    i++;
  }
}
